/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.util;

import htsjdk.samtools.SAMRecord;
import java.util.Objects;

public final class PrimaryAlignmentKey
implements Comparable<PrimaryAlignmentKey> {
    private final PairStatus pairStatus;
    private final String readName;

    public PrimaryAlignmentKey(SAMRecord rec) {
        if (rec.isSecondaryOrSupplementary()) {
            throw new IllegalArgumentException("PrimaryAligmentKey cannot be a secondary or suplementary alignment");
        }
        this.pairStatus = rec.getReadPairedFlag() ? (rec.getSecondOfPairFlag() ? PairStatus.SECOND : PairStatus.FIRST) : PairStatus.UNPAIRED;
        this.readName = rec.getReadName();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.readName, this.pairStatus});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrimaryAlignmentKey)) {
            return false;
        }
        PrimaryAlignmentKey that = (PrimaryAlignmentKey)o;
        return this.compareTo(that) == 0;
    }

    @Override
    public int compareTo(PrimaryAlignmentKey that) {
        int comp = this.readName.compareTo(that.readName);
        if (comp == 0) {
            comp = this.pairStatus.compareTo(that.pairStatus);
        }
        return comp;
    }

    private static enum PairStatus {
        UNPAIRED,
        FIRST,
        SECOND;

    }
}

