/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.analysis.CollectQualityYieldMetrics;
import picard.analysis.MergeableMetricBase;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;

@CommandLineProgramProperties(summary="Combines multiple QualityYieldMetrics files into a single file. This tool is used in cases where the metrics are calculated separately on shards of the same read-group.", oneLineSummary="Combines multiple QualityYieldMetrics files into a single file.", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
public class AccumulateQualityYieldMetrics
extends CommandLineProgram {
    @Argument(shortName="I", doc="Input QualityYieldMetrics files to merge.", minElements=1)
    public List<File> INPUT;
    @Argument(shortName="O", doc="Output QualityYieldMetric file to write.")
    public File OUTPUT;

    @Override
    protected int doWork() {
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        CollectQualityYieldMetrics.QualityYieldMetrics finalMetric = new CollectQualityYieldMetrics.QualityYieldMetrics();
        this.INPUT.forEach(file -> finalMetric.merge((MergeableMetricBase)((Object)((Object)MetricsFile.readBeans((File)file).get(0)))));
        finalMetric.calculateDerivedFields();
        MetricsFile outputMetricsFile = new MetricsFile();
        outputMetricsFile.addMetric((MetricBase)finalMetric);
        outputMetricsFile.write(this.OUTPUT);
        return 0;
    }
}

