/*
 * Decompiled with CFR 0.152.
 */
package picard.util.IntervalList;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import java.util.List;
import picard.util.IntervalList.IntervalListScattererByBaseCount;

public class IntervalListScattererWithoutSubdivision
extends IntervalListScattererByBaseCount {
    @Override
    public List<Interval> takeSome(Interval interval, long idealSplitWeight, long currentSize, double projectedSizeOfRemaining) {
        long projectedSize = currentSize + this.intervalWeight(interval);
        if (this.shouldIncludeInterval(idealSplitWeight, projectedSizeOfRemaining, projectedSize)) {
            return CollectionUtil.makeList((Object[])new Interval[]{interval, null});
        }
        return CollectionUtil.makeList((Object[])new Interval[]{null, interval});
    }

    protected boolean shouldIncludeInterval(long idealSplitWeight, double projectedSizeOfRemaining, long projectedSize) {
        return projectedSize <= idealSplitWeight;
    }

    @Override
    public int deduceIdealSplitWeight(IntervalList intervalList, int nCount) {
        int splitWidth = super.deduceIdealSplitWeight(intervalList, nCount);
        int widestIntervalLength = intervalList.getIntervals().stream().mapToInt(Interval::length).max().orElse(1);
        return Math.max(widestIntervalLength, splitWidth);
    }
}

