/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalCodec;
import htsjdk.samtools.util.IntervalCoordinateComparator;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.SortingCollection;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.readers.LineIterator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.IntervalsManipulationProgramGroup;

@CommandLineProgramProperties(summary="Converts an Picard IntervalList file to a BED file.", oneLineSummary="Converts an Picard IntervalList file to a BED file.", programGroup=IntervalsManipulationProgramGroup.class)
@DocumentedFeature
public class IntervalListToBed
extends CommandLineProgram {
    @Argument(shortName="I", doc="Input IntervalList file.")
    public File INPUT;
    @Argument(shortName="O", doc="Output BED file.")
    public File OUTPUT;
    @Argument(doc="The score, between 0-1000, to output for each interval in the BED file.")
    public int SCORE = 500;
    @Argument(doc="If true, sort the interval list prior to outputting as BED file.")
    public boolean SORT = true;

    /*
     * Exception decompiling
     */
    @Override
    protected int doWork() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CloseableIterator<Interval> getSortedIntervals(AbstractFeatureReader<Interval, LineIterator> intervalsReader) throws IOException {
        if (this.SORT) {
            SAMFileHeader header = (SAMFileHeader)intervalsReader.getHeader();
            SAMSequenceDictionary sequenceDictionary = header.getSequenceDictionary();
            IntervalCoordinateComparator comparator = new IntervalCoordinateComparator(header);
            SortingCollection sortedIntervals = SortingCollection.newInstance(Interval.class, (SortingCollection.Codec)new IntervalCodec(sequenceDictionary), (Comparator)comparator, (int)500000, (Path[])((Path[])this.TMP_DIR.stream().map(File::toPath).toArray(Path[]::new)));
            for (Interval i : intervalsReader.iterator()) {
                sortedIntervals.add((Object)i);
            }
            return sortedIntervals.iterator();
        }
        return intervalsReader.iterator();
    }

    private void generateOutput(Interval interval, BufferedWriter outputWriter) {
        try {
            String strand = interval.isNegativeStrand() ? "-" : "+";
            List fields = CollectionUtil.makeList((Object[])new Serializable[]{interval.getContig(), Integer.valueOf(interval.getStart() - 1), Integer.valueOf(interval.getEnd()), interval.getName(), Integer.valueOf(this.SCORE), strand});
            outputWriter.append(fields.stream().map(String::valueOf).collect(Collectors.joining("\t")));
            outputWriter.newLine();
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    private /* synthetic */ void lambda$doWork$0(BufferedWriter out, Interval i) {
        this.generateOutput(i, out);
    }
}

