/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.utils.ValidationUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.math3.random.RandomDataGenerator;
import picard.PicardException;

public final class MathUtil {
    public static final double MAX_PROB_BELOW_ONE = 0.9999999999999999;
    public static final double LOG_4_BASE_E = Math.log(4.0);
    public static final LogMath LOG_2_MATH = new LogMath(2.0);
    public static final LogMath NATURAL_LOG_MATH = new LogMath(Math.exp(1.0)){

        @Override
        public double getLogValue(double nonLogValue) {
            return Math.log(nonLogValue);
        }
    };
    public static final LogMath LOG_10_MATH = new LogMath(10.0){

        @Override
        public double getLogValue(double nonLogValue) {
            return Math.log10(nonLogValue);
        }
    };

    private MathUtil() {
    }

    public static double log10_1p(double x) {
        return Math.log1p(x) / LOG_10_MATH.log_of_base;
    }

    public static double mean(double[] in, int start, int stop) {
        double total = 0.0;
        for (int i = start; i < stop; ++i) {
            total += in[i];
        }
        return total / (double)(stop - start);
    }

    public static double mean(double[] in) {
        return MathUtil.mean(in, 0, in.length);
    }

    public static double stddev(double[] in, int start, int length) {
        return MathUtil.stddev(in, start, length, MathUtil.mean(in, start, length));
    }

    public static double stddev(double[] in, int start, int stop, double mean) {
        double total = 0.0;
        for (int i = start; i < stop; ++i) {
            total += in[i] * in[i];
        }
        return Math.sqrt(total / (double)(stop - start) - mean * mean);
    }

    public static double stddev(double[] in, double mean) {
        return MathUtil.stddev(in, 0, in.length, mean);
    }

    public static int compare(int v1, int v2) {
        return v1 < v2 ? -1 : (v1 == v2 ? 0 : 1);
    }

    public static double median(double ... in) {
        if (in.length == 0) {
            throw new IllegalArgumentException("Attempting to find the median of an empty array");
        }
        double[] data = Arrays.copyOf(in, in.length);
        Arrays.sort(data);
        int middle = data.length / 2;
        return data.length % 2 == 1 ? data[middle] : (data[middle - 1] + data[middle]) / 2.0;
    }

    public static Double percentageOrNull(Long numerator, Long denominator) {
        if (numerator != null && denominator != null && denominator != 0L) {
            return numerator.doubleValue() / denominator.doubleValue();
        }
        return null;
    }

    public static double round(double num, int precision) {
        BigDecimal bd = new BigDecimal(num);
        bd = bd.setScale(precision, 4);
        return bd.doubleValue();
    }

    public static double divide(double numerator, double denominator) {
        return Math.abs(0.0 - denominator) > 1.0E-6 ? numerator / denominator : 0.0;
    }

    public static double max(double[] nums) {
        return nums[MathUtil.indexOfMax(nums)];
    }

    public static double[] capFromBelow(double[] nums, double floor) {
        double[] floored = new double[nums.length];
        for (int i = 0; i < nums.length; ++i) {
            floored[i] = Math.max(nums[i], floor);
        }
        return floored;
    }

    public static int indexOfMax(double[] nums) {
        double max = nums[0];
        int index = 0;
        for (int i = 1; i < nums.length; ++i) {
            if (!(nums[i] > max)) continue;
            max = nums[i];
            index = i;
        }
        return index;
    }

    public static long max(long[] nums) {
        return nums[MathUtil.indexOfMax(nums)];
    }

    public static int indexOfMax(long[] nums) {
        long max = nums[0];
        int index = 0;
        for (int i = 1; i < nums.length; ++i) {
            if (nums[i] <= max) continue;
            max = nums[i];
            index = i;
        }
        return index;
    }

    public static double[] subtractMax(double[] logLikelihoods) {
        double max = MathUtil.max(logLikelihoods);
        return MathUtil.sum(logLikelihoods, -max);
    }

    public static double min(double[] nums) {
        return nums[MathUtil.indexOfMin(nums)];
    }

    public static int min(int[] nums) {
        return nums[MathUtil.indexOfMin(nums)];
    }

    public static short min(short[] nums) {
        short min = nums[0];
        for (int i = 1; i < nums.length; ++i) {
            if (nums[i] >= min) continue;
            min = nums[i];
        }
        return min;
    }

    public static byte min(byte[] nums) {
        byte min = nums[0];
        for (int i = 1; i < nums.length; ++i) {
            if (nums[i] >= min) continue;
            min = nums[i];
        }
        return min;
    }

    public static double[] capFromAbove(double[] nums, double top) {
        double[] capped = new double[nums.length];
        for (int i = 0; i < nums.length; ++i) {
            capped[i] = Math.min(nums[i], top);
        }
        return capped;
    }

    public static int indexOfMin(int[] nums) {
        long min = nums[0];
        int index = 0;
        for (int i = 1; i < nums.length; ++i) {
            if ((long)nums[i] >= min) continue;
            min = nums[i];
            index = i;
        }
        return index;
    }

    public static int indexOfMin(double[] nums) {
        double min = nums[0];
        int index = 0;
        for (int i = 1; i < nums.length; ++i) {
            if (!(nums[i] < min)) continue;
            min = nums[i];
            index = i;
        }
        return index;
    }

    public static double[] seq(double from, double to, double by) {
        if (from < to && by <= 0.0) {
            return new double[0];
        }
        if (from > to && by >= 0.0) {
            return new double[0];
        }
        int values = 1 + (int)Math.floor((to - from) / by);
        double[] results = new double[values];
        BigDecimal value = new BigDecimal(from);
        BigDecimal increment = new BigDecimal(by);
        for (int i = 0; i < values; ++i) {
            results[i] = value.doubleValue();
            value = value.add(increment);
        }
        return results;
    }

    public static double[] promote(int[] is) {
        double[] ds = new double[is.length];
        for (int i = 0; i < is.length; ++i) {
            ds[i] = is[i];
        }
        return ds;
    }

    @Deprecated
    public static double[] logLikelihoodsToProbs(double[] likelihoods) {
        return MathUtil.pNormalizeLogProbability(likelihoods);
    }

    public static double[] getProbabilityFromLog(double[] lLikelihood) {
        double maxLikelihood = MathUtil.max(lLikelihood);
        if (maxLikelihood < -300.0) {
            throw new PicardException(String.format("Underflow detected, needed to calculate pow(10,x) with x=%f.", maxLikelihood));
        }
        double[] tmp = new double[lLikelihood.length];
        for (int i = 0; i < lLikelihood.length; ++i) {
            tmp[i] = Math.pow(10.0, lLikelihood[i]);
        }
        return tmp;
    }

    public static double[] getLogFromProbability(double[] likelihood) {
        double[] tmp = new double[likelihood.length];
        for (int i = 0; i < likelihood.length; ++i) {
            tmp[i] = Math.log10(likelihood[i]);
        }
        return tmp;
    }

    public static double[] pNormalizeLogProbability(double[] lPosterior) {
        double[] tmp = new double[lPosterior.length];
        if (lPosterior.length == 0) {
            return tmp;
        }
        double maxLikelihood = MathUtil.max(lPosterior);
        double bump = 300.0 - maxLikelihood;
        double total = 0.0;
        for (int i = 0; i < lPosterior.length; ++i) {
            tmp[i] = Math.pow(10.0, lPosterior[i] + bump);
            total += tmp[i];
        }
        double maxP = 0.9999999999999999;
        double minP = (double)1.110223E-16f / (double)(tmp.length - 1);
        for (int i = 0; i < lPosterior.length; ++i) {
            int n = i;
            tmp[n] = tmp[n] / total;
            if (tmp[i] > 0.9999999999999999) {
                tmp[i] = 0.9999999999999999;
                continue;
            }
            if (!(tmp[i] < minP)) continue;
            tmp[i] = minP;
        }
        return tmp;
    }

    public static double[] divide(double[] numerators, double[] denominators) {
        if (numerators.length != denominators.length) {
            throw new IllegalArgumentException("Arrays must be of same length.");
        }
        int len = numerators.length;
        double[] result = new double[len];
        for (int i = 0; i < len; ++i) {
            result[i] = numerators[i] / denominators[i];
        }
        return result;
    }

    public static double[] pNormalizeVector(double[] pPosterior) {
        double[] tmp = new double[pPosterior.length];
        double total = MathUtil.sum(pPosterior);
        double maxP = 0.9999999999999999;
        double minP = (double)1.110223E-16f / (double)(tmp.length - 1);
        for (int i = 0; i < pPosterior.length; ++i) {
            tmp[i] = pPosterior[i] / total;
            if (tmp[i] > 0.9999999999999999) {
                tmp[i] = 0.9999999999999999;
                continue;
            }
            if (!(tmp[i] < minP)) continue;
            tmp[i] = minP;
        }
        return tmp;
    }

    public static double[] multiply(double[] lhs, double[] rhs) {
        if (lhs.length != rhs.length) {
            throw new IllegalArgumentException("Arrays must be of same length.");
        }
        int len = lhs.length;
        double[] result = new double[len];
        for (int i = 0; i < len; ++i) {
            result[i] = lhs[i] * rhs[i];
        }
        return result;
    }

    public static double[] sum(double[] lhs, double[] rhs) {
        if (lhs.length != rhs.length) {
            throw new IllegalArgumentException("Arrays must be of same length.");
        }
        int len = lhs.length;
        double[] result = new double[len];
        for (int i = 0; i < len; ++i) {
            result[i] = lhs[i] + rhs[i];
        }
        return result;
    }

    public static double[] sum(double[] lhs, double rhs) {
        int len = lhs.length;
        double[] result = new double[len];
        for (int i = 0; i < len; ++i) {
            result[i] = lhs[i] + rhs;
        }
        return result;
    }

    public static double sum(double[] arr) {
        double result = 0.0;
        for (double next : arr) {
            result += next;
        }
        return result;
    }

    public static long sum(long[] arr, int start, int stop) {
        long result = 0L;
        for (int i = start; i < stop; ++i) {
            result += arr[i];
        }
        return result;
    }

    public static long[] round(double ... input) {
        long[] out = new long[input.length];
        for (int i = 0; i < input.length; ++i) {
            out[i] = Math.round(input[i]);
        }
        return out;
    }

    public static double klDivergance(double[] measured, double[] distribution) {
        ValidationUtils.validateArg((measured.length == distribution.length ? 1 : 0) != 0, () -> "length of measuered and distribution differ. Found " + measured.length + " and " + distribution.length + ".");
        double[] normalizedMeasured = MathUtil.pNormalizeVector(measured);
        double[] normalizedDistribution = MathUtil.pNormalizeVector(distribution);
        return -MathUtil.sum(MathUtil.multiply(normalizedMeasured, NATURAL_LOG_MATH.getLogValue(MathUtil.divide(normalizedDistribution, normalizedMeasured))));
    }

    public static double[] permute(double[] array, RandomDataGenerator rdg) {
        int n = array.length;
        double[] retVal = new double[n];
        int[] randomPermutation = rdg.nextPermutation(n, n);
        for (int i = 0; i < n; ++i) {
            retVal[i] = array[randomPermutation[i]];
        }
        return retVal;
    }

    public static <T> List<T> randomSublist(List<T> list, int n, Random random) {
        int availableElements = list.size();
        if (availableElements <= n) {
            return list;
        }
        int stillNeeded = n;
        ArrayList<T> shortList = new ArrayList<T>(n);
        for (T aList : list) {
            if (random.nextDouble() < (double)stillNeeded / (double)availableElements) {
                shortList.add(aList);
                --stillNeeded;
            }
            if (stillNeeded == 0) break;
            --availableElements;
        }
        return shortList;
    }

    public static class LogMath {
        private final double base;
        private final double log_of_base;

        public double getLog_of_base() {
            return this.log_of_base;
        }

        private LogMath(double base) {
            this.base = base;
            this.log_of_base = Math.log(base);
        }

        public double getNonLogValue(double logValue) {
            return Math.pow(this.base, logValue);
        }

        public double getLogValue(double nonLogValue) {
            return Math.log(nonLogValue) / this.log_of_base;
        }

        public double[] getLogValue(double[] nonLogArray) {
            double[] logArray = new double[nonLogArray.length];
            for (int i = 0; i < nonLogArray.length; ++i) {
                logArray[i] = this.getLogValue(nonLogArray[i]);
            }
            return logArray;
        }

        public double mean(double ... logValues) {
            return this.sum(logValues) - this.getLogValue(logValues.length);
        }

        public double sum(double ... logValues) {
            double scalingFactor = MathUtil.max(logValues);
            double simpleAdditionResult = 0.0;
            for (double v : logValues) {
                simpleAdditionResult += this.getNonLogValue(v - scalingFactor);
            }
            return this.getLogValue(simpleAdditionResult) + scalingFactor;
        }

        public double product(double ... logValues) {
            return MathUtil.sum(logValues);
        }
    }
}

