/*
 * Decompiled with CFR 0.152.
 */
package picard.util.help;

import com.sun.javadoc.FieldDoc;
import htsjdk.samtools.metrics.MetricBase;
import java.util.ArrayList;
import java.util.HashMap;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DefaultDocWorkUnitHandler;
import org.broadinstitute.barclay.help.DocWorkUnit;
import org.broadinstitute.barclay.help.HelpDoclet;
import picard.cmdline.CommandLineProgram;

public class PicardHelpDocWorkUnitHandler
extends DefaultDocWorkUnitHandler {
    private static final String PICARD_JAVADOC_TAG_PREFIX = "picard";
    private static final String PICARD_FREEMARKER_TEMPLATE_NAME = "generic.template.html";
    private static final String PICARD_METRICS_TEMPLATE_NAME = "metrics.template.html";
    private static final String WORK_UNIT_SUMMARY_KEY = "summary";
    private static final String METRICS_MAP_ENTRY_KEY = "metrics";
    private static final String METRICS_MAP_NAME_KEY = "name";
    private static final String METRICS_MAP_SUMMARY_KEY = "summary";

    public PicardHelpDocWorkUnitHandler(HelpDoclet doclet) {
        super(doclet);
    }

    protected String getTagFilterPrefix() {
        return PICARD_JAVADOC_TAG_PREFIX;
    }

    public String getTemplateName(DocWorkUnit workUnit) {
        Class clazz = workUnit.getClazz();
        if (MetricBase.class.isAssignableFrom(clazz)) {
            return PICARD_METRICS_TEMPLATE_NAME;
        }
        return PICARD_FREEMARKER_TEMPLATE_NAME;
    }

    protected void addCustomBindings(DocWorkUnit currentWorkUnit) {
        super.addCustomBindings(currentWorkUnit);
        Class clazz = currentWorkUnit.getClazz();
        if (CommandLineProgram.class.isAssignableFrom(clazz)) {
            CommandLineProgramProperties clpProperties = currentWorkUnit.getCommandLineProperties();
            currentWorkUnit.setProperty("summary", (Object)clpProperties.summary());
        } else if (MetricBase.class.isAssignableFrom(clazz)) {
            FieldDoc[] fieldDocs;
            currentWorkUnit.setProperty("summary", (Object)currentWorkUnit.getSummary());
            ArrayList workUnitMetricsList = new ArrayList();
            currentWorkUnit.setProperty(METRICS_MAP_ENTRY_KEY, workUnitMetricsList);
            for (FieldDoc fd : fieldDocs = currentWorkUnit.getClassDoc().fields(false)) {
                if (!fd.isPublic()) continue;
                HashMap<String, String> metricsFields = new HashMap<String, String>();
                metricsFields.put(METRICS_MAP_NAME_KEY, fd.name());
                metricsFields.put("summary", fd.getRawCommentText());
                workUnitMetricsList.add(metricsFields);
            }
        }
    }
}

