/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.liftover.LiftOver;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFileWalker;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SortingCollection;
import htsjdk.samtools.util.StringUtil;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFRecordCodec;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.argumentcollections.ReferenceArgumentCollection;
import picard.cmdline.programgroups.VariantManipulationProgramGroup;
import picard.util.LiftoverUtils;

@CommandLineProgramProperties(summary="Lifts over a VCF file from one reference build to another.  <h3>Summary</h3>\nTool for \"lifting over\" a VCF from one genome build to another, producing a properly headered, sorted and indexed VCF in one go.\n\n<h3>Details</h3>\nThis tool adjusts the coordinates of variants within a VCF file to match a new reference. The output file will be sorted and indexed using the target reference build. To be clear, REFERENCE_SEQUENCE should be the <em>target</em> reference build (that is, the \"new\" one). The tool is based on the UCSC LiftOver tool (see http://genome.ucsc.edu/cgi-bin/hgLiftOver) and uses a UCSC chain file to guide its operation.\n\nFor each variant, the tool will look for the target coordinate, reverse-complement and left-align the variant if needed, and, in the case that the reference and alternate alleles of a SNP have been swapped in the new genome build, it will adjust the SNP, and correct AF-like INFO fields and the relevant genotypes.\n\n<h3>Example</h3>\njava -jar picard.jar LiftoverVcf \\\n    I=input.vcf \\\n    O=lifted_over.vcf \\\n    CHAIN=b37tohg38.chain \\\n    REJECT=rejected_variants.vcf \\\n    R=reference_sequence.fasta\n\n<h3>Caveats</h3>\n<h4>Rejected Records</h4>\nRecords may be rejected because they cannot be lifted over or because of sequence incompatibilities between the source and target reference genomes.  Rejected records will be emitted to the REJECT file using the source genome build coordinates. The reason for the rejection will be stated in the FILTER field, and more detail may be placed in the INFO field.\n<h4>Memory Use</h4>\nLiftOverVcf sorts the output using a \"SortingCollection\" which relies on MAX_RECORDS_IN_RAM to specify how many (vcf) records to hold in memory before \"spilling\" to disk. The default value is reasonable when sorting SAM files, but not for VCFs as there is no good default due to the dependence on the number of samples and amount of information in the INFO and FORMAT fields. Consider lowering to 100,000 or even less if you have many genotypes.\n", oneLineSummary="Lifts over a VCF file from one reference build to another.  ", programGroup=VariantManipulationProgramGroup.class)
@DocumentedFeature
public class LiftoverVcf
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Lifts over a VCF file from one reference build to another.  ";
    static final String USAGE_DETAILS = "<h3>Summary</h3>\nTool for \"lifting over\" a VCF from one genome build to another, producing a properly headered, sorted and indexed VCF in one go.\n\n<h3>Details</h3>\nThis tool adjusts the coordinates of variants within a VCF file to match a new reference. The output file will be sorted and indexed using the target reference build. To be clear, REFERENCE_SEQUENCE should be the <em>target</em> reference build (that is, the \"new\" one). The tool is based on the UCSC LiftOver tool (see http://genome.ucsc.edu/cgi-bin/hgLiftOver) and uses a UCSC chain file to guide its operation.\n\nFor each variant, the tool will look for the target coordinate, reverse-complement and left-align the variant if needed, and, in the case that the reference and alternate alleles of a SNP have been swapped in the new genome build, it will adjust the SNP, and correct AF-like INFO fields and the relevant genotypes.\n\n<h3>Example</h3>\njava -jar picard.jar LiftoverVcf \\\n    I=input.vcf \\\n    O=lifted_over.vcf \\\n    CHAIN=b37tohg38.chain \\\n    REJECT=rejected_variants.vcf \\\n    R=reference_sequence.fasta\n\n<h3>Caveats</h3>\n<h4>Rejected Records</h4>\nRecords may be rejected because they cannot be lifted over or because of sequence incompatibilities between the source and target reference genomes.  Rejected records will be emitted to the REJECT file using the source genome build coordinates. The reason for the rejection will be stated in the FILTER field, and more detail may be placed in the INFO field.\n<h4>Memory Use</h4>\nLiftOverVcf sorts the output using a \"SortingCollection\" which relies on MAX_RECORDS_IN_RAM to specify how many (vcf) records to hold in memory before \"spilling\" to disk. The default value is reasonable when sorting SAM files, but not for VCFs as there is no good default due to the dependence on the number of samples and amount of information in the INFO and FORMAT fields. Consider lowering to 100,000 or even less if you have many genotypes.\n";
    @Argument(shortName="I", doc="The input VCF/BCF file to be lifted over.")
    public File INPUT;
    @Argument(shortName="O", doc="The output location for the lifted over VCF/BCF.")
    public File OUTPUT;
    @Argument(shortName="C", doc="The liftover chain file. See https://genome.ucsc.edu/goldenPath/help/chain.html for a description of chain files.  See http://hgdownload.soe.ucsc.edu/downloads.html#terms for where to download chain files.")
    public File CHAIN;
    @Argument(doc="File to which to write rejected records.")
    public File REJECT;
    @Argument(shortName="WMC", doc="Warn on missing contig.", optional=true)
    public boolean WARN_ON_MISSING_CONTIG = false;
    @Argument(shortName="LFI", doc="If true, intervals failing due to match below LIFTOVER_MIN_MATCH will be logged as a warning to the console.", optional=true)
    public boolean LOG_FAILED_INTERVALS = true;
    @Argument(doc="Write the original contig/position for lifted variants to the INFO field.", optional=true)
    public boolean WRITE_ORIGINAL_POSITION = false;
    @Argument(doc="Write the original alleles for lifted variants to the INFO field.  If the alleles are identical, this attribute will be omitted.", optional=true)
    public boolean WRITE_ORIGINAL_ALLELES = false;
    @Argument(doc="The minimum percent match required for a variant to be lifted.", optional=true)
    public double LIFTOVER_MIN_MATCH = 1.0;
    @Argument(doc="Allow INFO and FORMAT in the records that are not found in the header", optional=true)
    public boolean ALLOW_MISSING_FIELDS_IN_HEADER = false;
    @Argument(doc="If the REF allele of the lifted site does not match the target genome, that variant is normally rejected. For bi-allelic SNPs, if this is set to true and the ALT allele equals the new REF allele, the REF and ALT alleles will be swapped.  This can rescue some variants; however, do this carefully as some annotations may become invalid, such as any that are alelle-specifc.  See also TAGS_TO_REVERSE and TAGS_TO_DROP.", optional=true)
    public boolean RECOVER_SWAPPED_REF_ALT = false;
    @Argument(doc="INFO field annotations that behave like an Allele Frequency and should be transformed with x->1-x when swapping reference with variant alleles.", optional=true)
    public Collection<String> TAGS_TO_REVERSE = new ArrayList<String>(LiftoverUtils.DEFAULT_TAGS_TO_REVERSE);
    @Argument(doc="INFO field annotations that should be deleted when swapping reference with variant alleles.", optional=true)
    public Collection<String> TAGS_TO_DROP = new ArrayList<String>(LiftoverUtils.DEFAULT_TAGS_TO_DROP);
    @Argument(doc="Output VCF file will be written on the fly but it won't be sorted and indexed.", optional=true)
    public boolean DISABLE_SORT = false;
    public static int EXIT_CODE_WHEN_CONTIG_NOT_IN_REFERENCE = 1;
    public static final String FILTER_CANNOT_LIFTOVER_REV_COMP = "CannotLiftOver";
    public static final String FILTER_NO_TARGET = "NoTarget";
    public static final String FILTER_MISMATCHING_REF_ALLELE = "MismatchedRefAllele";
    public static final String FILTER_INDEL_STRADDLES_TWO_INTERVALS = "IndelStraddlesMultipleIntevals";
    private static final List<VCFFilterHeaderLine> FILTERS = CollectionUtil.makeList((Object[])new VCFFilterHeaderLine[]{new VCFFilterHeaderLine("CannotLiftOver", "Liftover of a variant that needed reverse-complementing failed for unknown reasons."), new VCFFilterHeaderLine("NoTarget", "Variant could not be lifted between genome builds."), new VCFFilterHeaderLine("MismatchedRefAllele", "Reference allele does not match reference genome sequence after liftover."), new VCFFilterHeaderLine("IndelStraddlesMultipleIntevals", "Reference allele in Indel is straddling multiple intervals in the chain, and so the results are not well defined.")});
    public static final String ORIGINAL_CONTIG = "OriginalContig";
    public static final String ORIGINAL_START = "OriginalStart";
    public static final String ORIGINAL_ALLELES = "OriginalAlleles";
    public static final String ATTEMPTED_LOCUS = "AttemptedLocus";
    public static final String ATTEMPTED_ALLELES = "AttemptedAlleles";
    private static final List<VCFInfoHeaderLine> ATTRS = CollectionUtil.makeList((Object[])new VCFInfoHeaderLine[]{new VCFInfoHeaderLine("OriginalContig", 1, VCFHeaderLineType.String, "The name of the source contig/chromosome prior to liftover."), new VCFInfoHeaderLine("OriginalStart", 1, VCFHeaderLineType.String, "The position of the variant on the source contig prior to liftover."), new VCFInfoHeaderLine("OriginalAlleles", VCFHeaderLineCount.R, VCFHeaderLineType.String, "A list of the original alleles (including REF) of the variant prior to liftover.  If the alleles were not changed during liftover, this attribute will be omitted.")});
    private VariantContextWriter rejectedRecords;
    private VariantContextWriter acceptedRecords;
    private final Log log = Log.getInstance(LiftoverVcf.class);
    private SortingCollection<VariantContext> sorter;
    private long failedLiftover = 0L;
    private long failedAlleleCheck = 0L;
    private long totalTrackedAsSwapRefAlt = 0L;
    private final Map<String, Long> rejectsByContig = new TreeMap<String, Long>();
    private final Map<String, Long> liftedByDestContig = new TreeMap<String, Long>();
    private final Map<String, Long> liftedBySourceContig = new TreeMap<String, Long>();

    @Override
    protected ReferenceArgumentCollection makeReferenceArgumentCollection() {
        return new ReferenceArgumentCollection(){
            @Argument(shortName="R", common=false, doc="The reference sequence (fasta) for the TARGET genome build (i.e., the new one.  The fasta file must have an accompanying sequence dictionary (.dict file).")
            public File REFERENCE_SEQUENCE = Defaults.REFERENCE_FASTA;

            @Override
            public File getReferenceFile() {
                return this.REFERENCE_SEQUENCE;
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsReadable((File)this.REFERENCE_SEQUENCE);
        IOUtil.assertFileIsReadable((File)this.CHAIN);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        IOUtil.assertFileIsWritable((File)this.REJECT);
        if (this.CREATE_INDEX.booleanValue() && this.DISABLE_SORT) {
            this.log.error(new Object[]{"CREATE_INDEX=true and DISABLE_SORT=true are mutually exclusive."});
            return 1;
        }
        LiftOver liftOver = new LiftOver(this.CHAIN);
        liftOver.setShouldLogFailedIntervalsBelowThreshold(this.LOG_FAILED_INTERVALS);
        VCFFileReader in = new VCFFileReader(this.INPUT, false);
        this.log.info(new Object[]{"Loading up the target reference genome."});
        ReferenceSequenceFileWalker walker = new ReferenceSequenceFileWalker(this.REFERENCE_SEQUENCE);
        HashMap<String, ReferenceSequence> refSeqs = new HashMap<String, ReferenceSequence>();
        if (walker.getSequenceDictionary() == null) {
            this.log.error(new Object[]{"Reference " + this.REFERENCE_SEQUENCE.getAbsolutePath() + " must have an associated Dictionary .dict file in the same directory."});
            return 1;
        }
        for (SAMSequenceRecord rec : walker.getSequenceDictionary().getSequences()) {
            refSeqs.put(rec.getSequenceName(), walker.get(rec.getSequenceIndex()));
        }
        CloserUtil.close((Object)walker);
        VCFHeader inHeader = in.getFileHeader();
        VCFHeader outHeader = new VCFHeader((Set)inHeader.getMetaDataInInputOrder().stream().filter(M -> !M.getKey().equals("reference")).collect(Collectors.toCollection(LinkedHashSet::new)), (List)inHeader.getSampleNamesInOrder());
        outHeader.setSequenceDictionary(walker.getSequenceDictionary());
        if (this.WRITE_ORIGINAL_POSITION) {
            for (VCFInfoHeaderLine vCFInfoHeaderLine : ATTRS) {
                outHeader.addMetaDataLine((VCFHeaderLine)vCFInfoHeaderLine);
            }
        }
        outHeader.addMetaDataLine((VCFHeaderLine)new VCFInfoHeaderLine("SwappedAlleles", 0, VCFHeaderLineType.Flag, "The REF and the ALT alleles have been swapped in liftover due to changes in the reference. It is possible that not all INFO annotations reflect this swap, and in the genotypes, only the GT, PL, and AD fields have been modified. You should check the TAGS_TO_REVERSE parameter that was used during the LiftOver to be sure."));
        outHeader.addMetaDataLine((VCFHeaderLine)new VCFInfoHeaderLine("ReverseComplementedAlleles", 0, VCFHeaderLineType.Flag, "The REF and the ALT alleles have been reverse complemented in liftover since the mapping from the previous reference to the current one was on the negative strand."));
        outHeader.addMetaDataLine(new VCFHeaderLine("reference", this.REFERENCE_SEQUENCE.toURI().toString()));
        this.acceptedRecords = new VariantContextWriterBuilder().modifyOption(Options.ALLOW_MISSING_FIELDS_IN_HEADER, this.ALLOW_MISSING_FIELDS_IN_HEADER).modifyOption(Options.INDEX_ON_THE_FLY, !this.DISABLE_SORT).setOutputFile(this.OUTPUT).setReferenceDictionary(walker.getSequenceDictionary()).build();
        this.acceptedRecords.writeHeader(outHeader);
        this.rejectedRecords = new VariantContextWriterBuilder().setOutputFile(this.REJECT).unsetOption(Options.INDEX_ON_THE_FLY).modifyOption(Options.ALLOW_MISSING_FIELDS_IN_HEADER, this.ALLOW_MISSING_FIELDS_IN_HEADER).build();
        VCFHeader rejectHeader = new VCFHeader(in.getFileHeader());
        for (VCFFilterHeaderLine line : FILTERS) {
            rejectHeader.addMetaDataLine((VCFHeaderLine)line);
        }
        rejectHeader.addMetaDataLine((VCFHeaderLine)new VCFInfoHeaderLine(ATTEMPTED_LOCUS, 1, VCFHeaderLineType.String, "The locus of the variant in the TARGET prior to failing due to reference allele mismatching to the target reference."));
        rejectHeader.addMetaDataLine((VCFHeaderLine)new VCFInfoHeaderLine(ATTEMPTED_ALLELES, 1, VCFHeaderLineType.String, "The alleles of the variant in the TARGET prior to failing due to reference allele mismatching to the target reference."));
        this.rejectedRecords.writeHeader(rejectHeader);
        long l = 0L;
        if (this.DISABLE_SORT) {
            this.log.info(new Object[]{"Lifting variants over and writing the output file. Variants will not be sorted."});
            this.sorter = null;
        } else {
            this.log.info(new Object[]{"Lifting variants over and sorting (not yet writing the output file.)"});
            this.sorter = SortingCollection.newInstance(VariantContext.class, (SortingCollection.Codec)new VCFRecordCodec(outHeader, this.ALLOW_MISSING_FIELDS_IN_HEADER || this.VALIDATION_STRINGENCY != ValidationStringency.STRICT), (Comparator)outHeader.getVCFRecordComparator(), (int)this.MAX_RECORDS_IN_RAM, (Collection)this.TMP_DIR);
        }
        ProgressLogger progress = new ProgressLogger(this.log, 1000000, "read");
        for (VariantContext ctx : in) {
            ++l;
            Interval source = new Interval(ctx.getContig(), ctx.getStart(), ctx.getEnd(), false, ctx.getContig() + ":" + ctx.getStart() + "-" + ctx.getEnd());
            Interval target = liftOver.liftOver(source, this.LIFTOVER_MIN_MATCH);
            if (target == null) {
                this.rejectVariant(ctx, FILTER_NO_TARGET);
                continue;
            }
            if (ctx.getReference().length() != target.length()) {
                this.rejectVariant(ctx, FILTER_INDEL_STRADDLES_TWO_INTERVALS);
                continue;
            }
            if (!refSeqs.containsKey(target.getContig())) {
                this.rejectVariant(ctx, FILTER_NO_TARGET);
                String missingContigMessage = "Encountered a contig, " + target.getContig() + " that is not part of the target reference.";
                if (!this.WARN_ON_MISSING_CONTIG) {
                    this.log.error(new Object[]{missingContigMessage});
                    return EXIT_CODE_WHEN_CONTIG_NOT_IN_REFERENCE;
                }
                this.log.warn(new Object[]{missingContigMessage});
            } else {
                ReferenceSequence refSeq = (ReferenceSequence)refSeqs.get(target.getContig());
                VariantContext liftedVC = LiftoverUtils.liftVariant(ctx, target, refSeq, this.WRITE_ORIGINAL_POSITION, this.WRITE_ORIGINAL_ALLELES);
                if (liftedVC == null) {
                    this.rejectVariant(ctx, FILTER_CANNOT_LIFTOVER_REV_COMP);
                } else {
                    this.tryToAddVariant(liftedVC, refSeq, ctx);
                }
            }
            progress.record(ctx.getContig(), ctx.getStart());
        }
        DecimalFormat pfmt = new DecimalFormat("0.0000%");
        String pct = pfmt.format((double)(this.failedLiftover + this.failedAlleleCheck) / (double)l);
        this.log.info(new Object[]{"Processed ", l, " variants."});
        this.log.info(new Object[]{this.failedLiftover, " variants failed to liftover."});
        this.log.info(new Object[]{this.failedAlleleCheck, " variants lifted over but had mismatching reference alleles after lift over."});
        this.log.info(new Object[]{pct, " of variants were not successfully lifted over and written to the output."});
        TreeSet<String> contigUnion = new TreeSet<String>();
        contigUnion.addAll(this.liftedBySourceContig.keySet());
        contigUnion.addAll(this.rejectsByContig.keySet());
        this.log.info(new Object[]{"liftover success by source contig:"});
        for (String contig : contigUnion) {
            long success = this.liftedBySourceContig.getOrDefault(contig, 0L);
            long fail = this.rejectsByContig.getOrDefault(contig, 0L);
            String liftPct = pfmt.format((double)success / (double)(success + fail));
            this.log.info(new Object[]{contig, ": ", success, " / ", success + fail, " (", liftPct, ")"});
        }
        this.log.info(new Object[]{"lifted variants by target contig:"});
        for (String contig : this.liftedByDestContig.keySet()) {
            this.log.info(new Object[]{contig, ": ", this.liftedByDestContig.get(contig)});
        }
        if (this.liftedByDestContig.isEmpty()) {
            this.log.info(new Object[]{"no successfully lifted variants"});
        }
        if (this.RECOVER_SWAPPED_REF_ALT) {
            this.log.info(new Object[]{this.totalTrackedAsSwapRefAlt, " variants were lifted by swapping REF/ALT alleles."});
        } else {
            this.log.warn(new Object[]{this.totalTrackedAsSwapRefAlt, " variants with a swapped REF/ALT were identified, but were not recovered.  See RECOVER_SWAPPED_REF_ALT and associated caveats."});
        }
        this.rejectedRecords.close();
        in.close();
        if (!this.DISABLE_SORT) {
            this.sorter.doneAdding();
            progress = new ProgressLogger(this.log, 1000000, "written");
            this.log.info(new Object[]{"Writing out sorted records to final VCF."});
            for (VariantContext ctx : this.sorter) {
                this.acceptedRecords.add(ctx);
                progress.record(ctx.getContig(), ctx.getStart());
            }
            this.sorter.cleanup();
        }
        this.acceptedRecords.close();
        return 0;
    }

    private void rejectVariant(VariantContext ctx, String reason) {
        this.rejectedRecords.add(new VariantContextBuilder(ctx).filter(reason).make());
        ++this.failedLiftover;
        this.trackLiftedVariantContig(this.rejectsByContig, ctx.getContig());
    }

    private void trackLiftedVariantContig(Map<String, Long> map, String contig) {
        Long val = map.get(contig);
        if (val == null) {
            val = 0L;
        }
        val = val + 1L;
        map.put(contig, val);
    }

    private void addAndTrack(VariantContext toAdd, VariantContext source) {
        this.trackLiftedVariantContig(this.liftedBySourceContig, source.getContig());
        this.trackLiftedVariantContig(this.liftedByDestContig, toAdd.getContig());
        if (!this.DISABLE_SORT) {
            this.sorter.add((Object)toAdd);
        } else {
            this.acceptedRecords.add(toAdd);
        }
    }

    private void tryToAddVariant(VariantContext vc, ReferenceSequence refSeq, VariantContext source) {
        boolean mismatchesReference;
        if (!refSeq.getName().equals(vc.getContig())) {
            throw new IllegalStateException("The contig of the VariantContext, " + vc.getContig() + ", doesnt match the ReferenceSequence: " + refSeq.getName());
        }
        Allele allele = vc.getReference();
        byte[] ref = refSeq.getBases();
        String refString = StringUtil.bytesToString((byte[])ref, (int)(vc.getStart() - 1), (int)(vc.getEnd() - vc.getStart() + 1));
        if (!refString.equalsIgnoreCase(allele.getBaseString())) {
            if (vc.isBiallelic() && vc.isSNP() && refString.equalsIgnoreCase(vc.getAlternateAllele(0).getBaseString())) {
                ++this.totalTrackedAsSwapRefAlt;
                if (this.RECOVER_SWAPPED_REF_ALT) {
                    this.addAndTrack(LiftoverUtils.swapRefAlt(vc, this.TAGS_TO_REVERSE, this.TAGS_TO_DROP), source);
                    return;
                }
            }
            mismatchesReference = true;
        } else {
            mismatchesReference = false;
        }
        if (mismatchesReference) {
            this.rejectedRecords.add(new VariantContextBuilder(source).filter(FILTER_MISMATCHING_REF_ALLELE).attribute(ATTEMPTED_LOCUS, (Object)String.format("%s:%d-%d", vc.getContig(), vc.getStart(), vc.getEnd())).attribute(ATTEMPTED_ALLELES, (Object)(vc.getReference().toString() + "->" + String.join((CharSequence)",", vc.getAlternateAlleles().stream().map(Allele::toString).collect(Collectors.toList())))).make());
            ++this.failedAlleleCheck;
            this.trackLiftedVariantContig(this.rejectsByContig, source.getContig());
        } else {
            this.addAndTrack(vc, source);
        }
    }
}

