/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.util.HashSet;
import java.util.List;
import picard.util.IlluminaUtil;

public class AdapterUtility {
    private static final int ADAPTER_MATCH_LENGTH = 16;
    private static final int MAX_ADAPTER_ERRORS = 1;
    final byte[][] adapterKmers;
    public static List<String> DEFAULT_ADAPTER_SEQUENCE = CollectionUtil.makeList((Object[])new String[]{IlluminaUtil.IlluminaAdapterPair.SINGLE_END.get5PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.SINGLE_END.get3PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.PAIRED_END.get5PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.PAIRED_END.get3PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.INDEXED.get5PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.INDEXED.get3PrimeAdapter()});

    public AdapterUtility(List<String> list) {
        this.adapterKmers = AdapterUtility.prepareAdapterSequences(list);
    }

    private static byte[][] prepareAdapterSequences(List<String> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : list) {
            for (int i = 0; i <= string.length() - 16; ++i) {
                String string2 = string.substring(i, i + 16).toUpperCase();
                int n = 0;
                for (char c : string2.toCharArray()) {
                    if (c != 'N') continue;
                    ++n;
                }
                if (n > true) continue;
                hashSet.add(string2);
                hashSet.add(SequenceUtil.reverseComplement((String)string2));
            }
        }
        Object object = new byte[hashSet.size()][];
        int n = 0;
        for (String string2 : hashSet) {
            object[n++] = StringUtil.stringToBytes((String)string2);
        }
        return object;
    }

    public boolean isAdapterSequence(byte[] byArray) {
        if (byArray.length < 16) {
            return false;
        }
        for (byte[] byArray2 : this.adapterKmers) {
            int n = 0;
            for (int i = 0; i < byArray2.length && (byArray[i] == byArray2[i] || ++n <= 1); ++i) {
            }
            if (n > true) continue;
            return true;
        }
        return false;
    }
}

