/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import picard.analysis.AdapterUtility;
import picard.analysis.AlignmentSummaryMetricsCollector;
import picard.analysis.ChimeraUtil;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;

@CommandLineProgramProperties(usage="<b>Produces a summary of alignment metrics from a SAM or BAM file.</b>  This tool takes a SAM/BAM file input and produces metrics detailing the quality of the read alignments as well as the proportion of the reads that passed machine signal-to-noise threshold quality filters. Note that these quality filters are specific to Illumina data; for additional information, please see the corresponding <a href='https://www.broadinstitute.org/gatk/guide/article?id=6329'>GATK Dictionary entry</a>. </p><h4>Usage example:</h4><pre>    java -jar picard.jar CollectAlignmentSummaryMetrics \\<br />          R=reference_sequence.fasta \\<br />          I=input.bam \\<br />          O=output.txt</pre><p>Please see the CollectAlignmentSummaryMetrics <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#AlignmentSummaryMetrics'>definitions</a> for a complete description of the metrics produced by this tool.</p><hr />", usageShort="<b>Produces a summary of alignment metrics from a SAM or BAM file.</b>  ", programGroup=Metrics.class)
public class CollectAlignmentSummaryMetrics
extends SinglePassSamProgram {
    static final String USAGE_SUMMARY = "<b>Produces a summary of alignment metrics from a SAM or BAM file.</b>  ";
    static final String USAGE_DETAILS = "This tool takes a SAM/BAM file input and produces metrics detailing the quality of the read alignments as well as the proportion of the reads that passed machine signal-to-noise threshold quality filters. Note that these quality filters are specific to Illumina data; for additional information, please see the corresponding <a href='https://www.broadinstitute.org/gatk/guide/article?id=6329'>GATK Dictionary entry</a>. </p><h4>Usage example:</h4><pre>    java -jar picard.jar CollectAlignmentSummaryMetrics \\<br />          R=reference_sequence.fasta \\<br />          I=input.bam \\<br />          O=output.txt</pre><p>Please see the CollectAlignmentSummaryMetrics <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#AlignmentSummaryMetrics'>definitions</a> for a complete description of the metrics produced by this tool.</p><hr />";
    private static final Log log = Log.getInstance(CollectAlignmentSummaryMetrics.class);
    @Option(doc="Paired-end reads above this insert size will be considered chimeric along with inter-chromosomal pairs.")
    public int MAX_INSERT_SIZE = ChimeraUtil.DEFAULT_INSERT_SIZE_LIMIT;
    @Option(doc="Paired-end reads that do not have this expected orientation will be considered chimeric.")
    public Set<SamPairUtil.PairOrientation> EXPECTED_PAIR_ORIENTATIONS = EnumSet.copyOf(ChimeraUtil.DEFAULT_EXPECTED_ORIENTATIONS);
    @Option(doc="List of adapter sequences to use when processing the alignment metrics.")
    public List<String> ADAPTER_SEQUENCE = AdapterUtility.DEFAULT_ADAPTER_SEQUENCE;
    @Option(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.")
    public Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet((Object[])new MetricAccumulationLevel[]{MetricAccumulationLevel.ALL_READS});
    @Option(shortName="BS", doc="Whether the SAM or BAM file consists of bisulfite sequenced reads.")
    public boolean IS_BISULFITE_SEQUENCED = false;
    @Option(shortName="R", doc="Reference sequence file. Note that while this argument isn't required, without it only a small subset of the metrics will be calculated. Note also that if a reference sequence is provided, it must be accompanied by a sequence dictionary.", optional=true, overridable=true)
    public File REFERENCE_SEQUENCE = Defaults.REFERENCE_FASTA;
    private AlignmentSummaryMetricsCollector collector;

    public static void main(String[] stringArray) {
        new CollectAlignmentSummaryMetrics().instanceMainWithExit(stringArray);
    }

    protected final int testDoWork() {
        return this.doWork();
    }

    @Override
    protected void setup(SAMFileHeader sAMFileHeader, File file) {
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        if (sAMFileHeader.getSequenceDictionary().isEmpty()) {
            log.warn(new Object[]{this.INPUT.getAbsoluteFile() + " has no sequence dictionary.  If any reads " + "in the file are aligned, then alignment summary metrics collection will fail."});
        }
        boolean bl = this.REFERENCE_SEQUENCE != null;
        this.collector = new AlignmentSummaryMetricsCollector(this.METRIC_ACCUMULATION_LEVEL, sAMFileHeader.getReadGroups(), bl, this.ADAPTER_SEQUENCE, this.MAX_INSERT_SIZE, this.EXPECTED_PAIR_ORIENTATIONS, this.IS_BISULFITE_SEQUENCED);
    }

    @Override
    protected void acceptRead(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
        this.collector.acceptRecord(sAMRecord, referenceSequence);
    }

    @Override
    protected void finish() {
        this.collector.finish();
        MetricsFile metricsFile = this.getMetricsFile();
        this.collector.addAllLevelsToFile(metricsFile);
        metricsFile.write(this.OUTPUT);
    }
}

