/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.text.NumberFormat;
import java.util.List;
import java.util.Set;
import picard.analysis.GcBiasDetailMetrics;
import picard.analysis.GcBiasMetricsCollector;
import picard.analysis.GcBiasUtils;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.metrics.GcBiasMetrics;
import picard.util.RExecutor;

@CommandLineProgramProperties(usage="Collect metrics regarding GC bias. This tool collects information about the relative proportions of guanine (G) and cytosine (C) nucleotides in a sample.  Regions of high and low G + C content have been shown to interfere with mapping/aligning, ultimately leading to fragmented genome assemblies and poor coverage in a phenomenon known as \"GC bias\".  Detailed information on the effects of GC bias on the collection and analysis of sequencing data can be found at DOI: 10.1371/journal.pone.0062856/.<br /><br />The GC bias statistics are always output in a detailed long-form version, but a summary can also be produced. Both the detailed metrics and the summary metrics are output as tables (\".txt\" files) and an accompanying chart that plots the data (\".pdf\" file). <br /><br /> <h4>Detailed metrics</h4>The table of detailed metrics includes GC percentages for each bin (GC), the percentage of WINDOWS corresponding to each GC bin of the reference sequence, the numbers of reads that start within a particular %GC content bin (READ_STARTS), and the mean base quality of the reads that correspond to a specific GC content distribution window (MEAN_BASE_QUALITY).  NORMALIZED_COVERAGE is a relative measure of sequence coverage by the reads at a particular GC content.For each run, the corresponding reference sequence is divided into bins or windows based on the percentage of G + C content ranging from 0 - 100%.  The percentages of G + C are determined from a defined length of sequence; the default value is set at 100 bases. The mean of the distribution will vary among organisms; human DNA has a mean GC content of 40%, suggesting a slight preponderance of AT-rich regions.  <br /><br /><h4>Summary metrics</h4>The table of summary metrics captures run-specific bias information including WINDOW_SIZE, ALIGNED_READS, TOTAL_CLUSTERS, AT_DROPOUT, and GC_DROPOUT.  While WINDOW_SIZE refers to the numbers of bases used for the distribution (see above), the ALIGNED_READS and TOTAL_CLUSTERS are the total number of aligned reads and the total number of reads (after filtering) produced in a run. In addition, the tool produces both AT_DROPOUT and GC_DROPOUT metrics, which indicate the percentage of misaligned reads that correlate with low (%-GC is &lt; 50%) or high (%-GC is &gt; 50%) GC content respectively.  <br /><br />The percentage of \"coverage\" or depth in a GC bin is calculated by dividing the number of reads of a particular GC content by the mean number of reads of all GC bins.  A number of 1 represents mean coverage, a number less than 1 represents lower than mean coverage (e.g. 0.5 means half as much coverage as average) while a number greater than 1 represents higher than mean coverage (e.g. 3.1 means this GC bin has 3.1 times more reads per window than average).  This tool also tracks mean base-quality scores of the reads within each GC content bin, enabling the user to determine how base quality scores vary with GC content.  <br /> <br />The chart output associated with this data table plots the NORMALIZED_COVERAGE, the distribution of WINDOWs corresponding to GC percentages, and base qualities corresponding to each %GC bin.<h4>Usage Example:</h4><pre>java -jar picard.jar CollectGcBiasMetrics \\<br />      I=input.bam \\<br />      O=gc_bias_metrics.txt \\<br />      CHART=gc_bias_metrics.pdf \\<br />      S=summary_metrics.txt \\<br />      R=reference_sequence.fasta</pre>Please see <a href='https://broadinstitute.github.io/picard/picard-metric-definitions.html#GcBiasMetrics'>the GcBiasMetrics documentation</a> for further explanations of each metric.<hr />", usageShort="Collect metrics regarding GC bias. ", programGroup=Metrics.class)
public class CollectGcBiasMetrics
extends SinglePassSamProgram {
    static final String USAGE_SUMMARY = "Collect metrics regarding GC bias. ";
    static final String USAGE_DETAILS = "This tool collects information about the relative proportions of guanine (G) and cytosine (C) nucleotides in a sample.  Regions of high and low G + C content have been shown to interfere with mapping/aligning, ultimately leading to fragmented genome assemblies and poor coverage in a phenomenon known as \"GC bias\".  Detailed information on the effects of GC bias on the collection and analysis of sequencing data can be found at DOI: 10.1371/journal.pone.0062856/.<br /><br />The GC bias statistics are always output in a detailed long-form version, but a summary can also be produced. Both the detailed metrics and the summary metrics are output as tables (\".txt\" files) and an accompanying chart that plots the data (\".pdf\" file). <br /><br /> <h4>Detailed metrics</h4>The table of detailed metrics includes GC percentages for each bin (GC), the percentage of WINDOWS corresponding to each GC bin of the reference sequence, the numbers of reads that start within a particular %GC content bin (READ_STARTS), and the mean base quality of the reads that correspond to a specific GC content distribution window (MEAN_BASE_QUALITY).  NORMALIZED_COVERAGE is a relative measure of sequence coverage by the reads at a particular GC content.For each run, the corresponding reference sequence is divided into bins or windows based on the percentage of G + C content ranging from 0 - 100%.  The percentages of G + C are determined from a defined length of sequence; the default value is set at 100 bases. The mean of the distribution will vary among organisms; human DNA has a mean GC content of 40%, suggesting a slight preponderance of AT-rich regions.  <br /><br /><h4>Summary metrics</h4>The table of summary metrics captures run-specific bias information including WINDOW_SIZE, ALIGNED_READS, TOTAL_CLUSTERS, AT_DROPOUT, and GC_DROPOUT.  While WINDOW_SIZE refers to the numbers of bases used for the distribution (see above), the ALIGNED_READS and TOTAL_CLUSTERS are the total number of aligned reads and the total number of reads (after filtering) produced in a run. In addition, the tool produces both AT_DROPOUT and GC_DROPOUT metrics, which indicate the percentage of misaligned reads that correlate with low (%-GC is &lt; 50%) or high (%-GC is &gt; 50%) GC content respectively.  <br /><br />The percentage of \"coverage\" or depth in a GC bin is calculated by dividing the number of reads of a particular GC content by the mean number of reads of all GC bins.  A number of 1 represents mean coverage, a number less than 1 represents lower than mean coverage (e.g. 0.5 means half as much coverage as average) while a number greater than 1 represents higher than mean coverage (e.g. 3.1 means this GC bin has 3.1 times more reads per window than average).  This tool also tracks mean base-quality scores of the reads within each GC content bin, enabling the user to determine how base quality scores vary with GC content.  <br /> <br />The chart output associated with this data table plots the NORMALIZED_COVERAGE, the distribution of WINDOWs corresponding to GC percentages, and base qualities corresponding to each %GC bin.<h4>Usage Example:</h4><pre>java -jar picard.jar CollectGcBiasMetrics \\<br />      I=input.bam \\<br />      O=gc_bias_metrics.txt \\<br />      CHART=gc_bias_metrics.pdf \\<br />      S=summary_metrics.txt \\<br />      R=reference_sequence.fasta</pre>Please see <a href='https://broadinstitute.github.io/picard/picard-metric-definitions.html#GcBiasMetrics'>the GcBiasMetrics documentation</a> for further explanations of each metric.<hr />";
    private static final String R_SCRIPT = "picard/analysis/gcBias.R";
    @Option(shortName="CHART", doc="The PDF file to render the chart to.")
    public File CHART_OUTPUT;
    @Option(shortName="S", doc="The text file to write summary metrics to.")
    public File SUMMARY_OUTPUT;
    @Option(shortName="WINDOW_SIZE", doc="The size of the scanning windows on the reference genome that are used to bin reads.")
    public int SCAN_WINDOW_SIZE = 100;
    @Option(shortName="MGF", doc="For summary metrics, exclude GC windows that include less than this fraction of the genome.")
    public double MINIMUM_GENOME_FRACTION = 1.0E-5;
    @Option(shortName="BS", doc="Whether the SAM or BAM file consists of bisulfite sequenced reads.")
    public boolean IS_BISULFITE_SEQUENCED = false;
    @Option(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.")
    public Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet((Object[])new MetricAccumulationLevel[]{MetricAccumulationLevel.ALL_READS});
    private GcBiasMetricsCollector multiCollector;
    private static final int BINS = 101;

    public static void main(String[] stringArray) {
        System.exit(new CollectGcBiasMetrics().instanceMain(stringArray));
    }

    @Override
    protected void setup(SAMFileHeader sAMFileHeader, File file) {
        IOUtil.assertFileIsWritable((File)this.CHART_OUTPUT);
        IOUtil.assertFileIsWritable((File)this.SUMMARY_OUTPUT);
        IOUtil.assertFileIsReadable((File)this.REFERENCE_SEQUENCE);
        int[] nArray = GcBiasUtils.calculateRefWindowsByGc(101, this.REFERENCE_SEQUENCE, this.SCAN_WINDOW_SIZE);
        this.multiCollector = new GcBiasMetricsCollector(this.METRIC_ACCUMULATION_LEVEL, nArray, sAMFileHeader.getReadGroups(), this.SCAN_WINDOW_SIZE, this.IS_BISULFITE_SEQUENCED);
    }

    @Override
    protected void acceptRead(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
        this.multiCollector.acceptRecord(sAMRecord, referenceSequence);
    }

    @Override
    protected void finish() {
        this.multiCollector.finish();
        MetricsFile metricsFile = this.getMetricsFile();
        MetricsFile metricsFile2 = this.getMetricsFile();
        MetricsFile metricsFile3 = this.getMetricsFile();
        this.multiCollector.addAllLevelsToFile(metricsFile);
        List list = metricsFile.getMetrics();
        for (GcBiasMetrics gcBiasMetrics : list) {
            List list2 = gcBiasMetrics.DETAILS.getMetrics();
            for (GcBiasDetailMetrics gcBiasDetailMetrics : list2) {
                metricsFile2.addMetric((MetricBase)gcBiasDetailMetrics);
            }
            metricsFile3.addMetric((MetricBase)gcBiasMetrics.SUMMARY);
        }
        metricsFile2.write(this.OUTPUT);
        metricsFile3.write(this.SUMMARY_OUTPUT);
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(true);
        RExecutor.executeFromClasspath(R_SCRIPT, this.OUTPUT.getAbsolutePath(), this.SUMMARY_OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath(), String.valueOf(this.SCAN_WINDOW_SIZE));
    }
}

