/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.Set;
import picard.PicardException;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.SinglePassSamProgram;
import picard.analysis.directed.InsertSizeMetricsCollector;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.util.RExecutor;

@CommandLineProgramProperties(usage="This tool provides useful metrics for validating library construction including the insert size distribution and read orientation of paired-end libraries. <br /><br />The expected proportions of these metrics vary depending on the type of library preparation used, resulting from technical differences between pair-end libraries and mate-pair libraries. For a brief primer on paired-end sequencing and mate-pair reads, see <a href='http://gatkforums.broadinstitute.org/discussion/6327/paired-end-mate-pair'>the GATK Dictionary</a><br /><br />The CollectInsertSizeMetrics tool outputs the percentages of read pairs in each of the three orientations (FR, RF, and TANDEM) as a histogram. In addition, the insert size distribution is output as both a histogram (.insert_size_Histogram.pdf) and as a data table (.insert_size_metrics.txt).<h4>Usage example:</h4><pre>java -jar picard.jar CollectInsertSizeMetrics \\<br />      I=input.bam \\<br />      O=insert_size_metrics.txt \\<br />      H=insert_size_histogram.pdf \\<br />      M=0.5</pre>Note: If processing a small file, set the minimum percentage option (M) to 0.5, otherwise an error may occur. <br /><br />Please see <a href='https://broadinstitute.github.io/picard/picard-metric-definitions.html#InsertSizeMetrics'>the InsertSizeMetrics documentation</a> for further explanations of each metric.<hr />Collect metrics about the insert size distribution of a paired-end library.", usageShort="Collect metrics about the insert size distribution of a paired-end library.", programGroup=Metrics.class)
public class CollectInsertSizeMetrics
extends SinglePassSamProgram {
    static final String USAGE_BRIEF = "Collect metrics about the insert size distribution of a paired-end library.";
    static final String USAGE_SUMMARY = "This tool provides useful metrics for validating library construction including the insert size distribution and read orientation of paired-end libraries. <br /><br />The expected proportions of these metrics vary depending on the type of library preparation used, resulting from technical differences between pair-end libraries and mate-pair libraries. For a brief primer on paired-end sequencing and mate-pair reads, see <a href='http://gatkforums.broadinstitute.org/discussion/6327/paired-end-mate-pair'>the GATK Dictionary</a><br /><br />The CollectInsertSizeMetrics tool outputs the percentages of read pairs in each of the three orientations (FR, RF, and TANDEM) as a histogram. In addition, the insert size distribution is output as both a histogram (.insert_size_Histogram.pdf) and as a data table (.insert_size_metrics.txt).<h4>Usage example:</h4><pre>java -jar picard.jar CollectInsertSizeMetrics \\<br />      I=input.bam \\<br />      O=insert_size_metrics.txt \\<br />      H=insert_size_histogram.pdf \\<br />      M=0.5</pre>Note: If processing a small file, set the minimum percentage option (M) to 0.5, otherwise an error may occur. <br /><br />Please see <a href='https://broadinstitute.github.io/picard/picard-metric-definitions.html#InsertSizeMetrics'>the InsertSizeMetrics documentation</a> for further explanations of each metric.<hr />";
    private static final Log log = Log.getInstance(CollectInsertSizeMetrics.class);
    protected static final String Histogram_R_SCRIPT = "picard/analysis/insertSizeHistogram.R";
    @Option(shortName="H", doc="File to write insert size Histogram chart to.")
    public File Histogram_FILE;
    @Option(doc="Generate mean, sd and plots by trimming the data down to MEDIAN + DEVIATIONS*MEDIAN_ABSOLUTE_DEVIATION. This is done because insert size data typically includes enough anomalous values from chimeras and other artifacts to make the mean and sd grossly misleading regarding the real distribution.")
    public double DEVIATIONS = 10.0;
    @Option(shortName="W", doc="Explicitly sets the Histogram width, overriding automatic truncation of Histogram tail. Also, when calculating mean and standard deviation, only bins <= Histogram_WIDTH will be included.", optional=true)
    public Integer HISTOGRAM_WIDTH = null;
    @Option(shortName="M", doc="When generating the Histogram, discard any data categories (out of FR, TANDEM, RF) that have fewer than this percentage of overall reads. (Range: 0 to 1).")
    public float MINIMUM_PCT = 0.05f;
    @Option(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.  ")
    public Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet((Object[])new MetricAccumulationLevel[]{MetricAccumulationLevel.ALL_READS});
    @Option(doc="If true, also include reads marked as duplicates in the insert size histogram.")
    public boolean INCLUDE_DUPLICATES = false;
    private InsertSizeMetricsCollector multiCollector;

    public static void main(String[] stringArray) {
        new CollectInsertSizeMetrics().instanceMainWithExit(stringArray);
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.MINIMUM_PCT < 0.0f || (double)this.MINIMUM_PCT > 0.5) {
            return new String[]{"MINIMUM_PCT was set to " + this.MINIMUM_PCT + ". It must be between 0 and 0.5 so all data categories don't get discarded."};
        }
        return super.customCommandLineValidation();
    }

    @Override
    protected boolean usesNoRefReads() {
        return false;
    }

    @Override
    protected void setup(SAMFileHeader sAMFileHeader, File file) {
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        IOUtil.assertFileIsWritable((File)this.Histogram_FILE);
        this.multiCollector = new InsertSizeMetricsCollector(this.METRIC_ACCUMULATION_LEVEL, sAMFileHeader.getReadGroups(), this.MINIMUM_PCT, this.HISTOGRAM_WIDTH, this.DEVIATIONS, this.INCLUDE_DUPLICATES);
    }

    @Override
    protected void acceptRead(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
        this.multiCollector.acceptRecord(sAMRecord, referenceSequence);
    }

    @Override
    protected void finish() {
        this.multiCollector.finish();
        MetricsFile metricsFile = this.getMetricsFile();
        this.multiCollector.addAllLevelsToFile(metricsFile);
        if (metricsFile.getNumHistograms() == 0) {
            log.warn(new Object[]{"All data categories were discarded because they contained < " + this.MINIMUM_PCT + " of the total aligned paired data."});
            InsertSizeMetricsCollector.PerUnitInsertSizeMetricsCollector perUnitInsertSizeMetricsCollector = (InsertSizeMetricsCollector.PerUnitInsertSizeMetricsCollector)this.multiCollector.getAllReadsCollector();
            log.warn(new Object[]{"Total mapped pairs in all categories: " + (perUnitInsertSizeMetricsCollector == null ? perUnitInsertSizeMetricsCollector : Double.valueOf(perUnitInsertSizeMetricsCollector.getTotalInserts()))});
        } else {
            metricsFile.write(this.OUTPUT);
            int n = this.HISTOGRAM_WIDTH == null ? RExecutor.executeFromClasspath(Histogram_R_SCRIPT, this.OUTPUT.getAbsolutePath(), this.Histogram_FILE.getAbsolutePath(), this.INPUT.getName()) : RExecutor.executeFromClasspath(Histogram_R_SCRIPT, this.OUTPUT.getAbsolutePath(), this.Histogram_FILE.getAbsolutePath(), this.INPUT.getName(), String.valueOf(this.HISTOGRAM_WIDTH));
            if (n != 0) {
                throw new PicardException("R script picard/analysis/insertSizeHistogram.R failed with return code " + n);
            }
        }
    }
}

