/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import picard.PicardException;
import picard.analysis.CollectAlignmentSummaryMetrics;
import picard.analysis.CollectBaseDistributionByCycle;
import picard.analysis.CollectGcBiasMetrics;
import picard.analysis.CollectInsertSizeMetrics;
import picard.analysis.CollectQualityYieldMetrics;
import picard.analysis.CollectRnaSeqMetrics;
import picard.analysis.MeanQualityByCycle;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.QualityScoreDistribution;
import picard.analysis.SinglePassSamProgram;
import picard.analysis.artifacts.CollectSequencingArtifactMetrics;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;

@CommandLineProgramProperties(usage="Collect multiple classes of metrics.  This \"meta-metrics\" tool runs one or more of the metrics collection modules at the same time to cut down on the time spent reading in data from input files. Available modules include CollectAlignmentSummaryMetrics, CollectInsertSizeMetrics, QualityScoreDistribution,  MeanQualityByCycle, and CollectBaseDistributionByCycle.  The tool produces outputs of \".pdf\" and \".txt\" files for each module, except for the CollectAlignmentSummaryMetrics module, which outputs only a \".txt\" file. Output files are named by specifying a base name (without any file extensions).<br /><br />Currently all programs are run with default options and fixed output extensions, but this may become more flexible in future. Specifying a reference sequence file is required.<br /><h4>Usage example (all modules on by default):</h4><pre>java -jar picard.jar CollectMultipleMetrics \\<br />      I=input.bam \\<br />      O=multiple_metrics \\<br />      R=reference_sequence.fasta <br /></pre><h4>Usage example (two modules only):</h4>java -jar picard.jar CollectMultipleMetrics \\<br />      I=input.bam \\<br />      O=multiple_metrics \\<br />      R=reference_sequence.fasta \\<br />      PROGRAM=null \\<br />      PROGRAM=QualityScoreDistribution \\<br />      PROGRAM=MeanQualityByCycle </pre><hr />", usageShort="Collect multiple classes of metrics.  ", programGroup=Metrics.class)
public class CollectMultipleMetrics
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Collect multiple classes of metrics.  ";
    static final String USAGE_DETAILS = "This \"meta-metrics\" tool runs one or more of the metrics collection modules at the same time to cut down on the time spent reading in data from input files. Available modules include CollectAlignmentSummaryMetrics, CollectInsertSizeMetrics, QualityScoreDistribution,  MeanQualityByCycle, and CollectBaseDistributionByCycle.  The tool produces outputs of \".pdf\" and \".txt\" files for each module, except for the CollectAlignmentSummaryMetrics module, which outputs only a \".txt\" file. Output files are named by specifying a base name (without any file extensions).<br /><br />Currently all programs are run with default options and fixed output extensions, but this may become more flexible in future. Specifying a reference sequence file is required.<br /><h4>Usage example (all modules on by default):</h4><pre>java -jar picard.jar CollectMultipleMetrics \\<br />      I=input.bam \\<br />      O=multiple_metrics \\<br />      R=reference_sequence.fasta <br /></pre><h4>Usage example (two modules only):</h4>java -jar picard.jar CollectMultipleMetrics \\<br />      I=input.bam \\<br />      O=multiple_metrics \\<br />      R=reference_sequence.fasta \\<br />      PROGRAM=null \\<br />      PROGRAM=QualityScoreDistribution \\<br />      PROGRAM=MeanQualityByCycle </pre><hr />";
    @Option(shortName="I", doc="Input SAM or BAM file.")
    public File INPUT;
    @Option(doc="If true (default), then the sort order in the header file will be ignored.", shortName="AS")
    public boolean ASSUME_SORTED = true;
    @Option(doc="Stop after processing N reads, mainly for debugging.")
    public int STOP_AFTER = 0;
    @Option(shortName="O", doc="Base name of output files.")
    public String OUTPUT;
    private final Set<MetricAccumulationLevel> accumLevelDefault = CollectionUtil.makeSet((Object[])new MetricAccumulationLevel[]{MetricAccumulationLevel.ALL_READS});
    @Option(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.")
    public Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = new HashSet<MetricAccumulationLevel>(this.accumLevelDefault);
    @Option(shortName="EXT", doc="Append the given file extension to all metric file names (ex. OUTPUT.insert_size_metrics.EXT). None if null", optional=true)
    public String FILE_EXTENSION = null;
    @Option(doc="Set of metrics programs to apply during the pass through the SAM file.")
    public Set<Program> PROGRAM = new LinkedHashSet<Program>(Arrays.asList(Program.CollectAlignmentSummaryMetrics, Program.CollectBaseDistributionByCycle, Program.CollectInsertSizeMetrics, Program.MeanQualityByCycle, Program.QualityScoreDistribution));
    @Option(doc="An optional list of intervals to restrict analysis to. Only pertains to some of the PROGRAMs. Programs whose stand-alone CLP does not have an INTERVALS argument will silently ignore this argument.", optional=true)
    public File INTERVALS;
    @Option(doc="VCF format dbSNP file, used to exclude regions around known polymorphisms from analysis by some PROGRAMs, PROGRAMS whose CLP doesn't allow for this argument will quetly ignore it.", optional=true)
    public File DB_SNP;
    private Set<ProgramInterface> programsToRun;
    private static final Log log = Log.getInstance(CollectMultipleMetrics.class);

    public static void main(String[] stringArray) {
        new CollectMultipleMetrics().instanceMainWithExit(stringArray);
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.PROGRAM.isEmpty()) {
            return new String[]{"No programs specified with PROGRAM"};
        }
        this.programsToRun = new LinkedHashSet<Program>(this.PROGRAM);
        return super.customCommandLineValidation();
    }

    public void setProgramsToRun(Collection<ProgramInterface> collection) {
        this.programsToRun.clear();
        this.programsToRun.addAll(collection);
    }

    @Override
    public int doWork() {
        if (this.OUTPUT.endsWith(".")) {
            this.OUTPUT = this.OUTPUT.substring(0, this.OUTPUT.length() - 1);
        }
        ArrayList<SinglePassSamProgram> arrayList = new ArrayList<SinglePassSamProgram>();
        for (ProgramInterface programInterface : this.programsToRun) {
            if (programInterface.needsReferenceSequence() && this.REFERENCE_SEQUENCE == null) {
                throw new PicardException("The " + programInterface.toString() + " program needs a Reference Sequence, please set REFERENCE_SEQUENCE in the command line");
            }
            if (!this.accumLevelDefault.equals(this.METRIC_ACCUMULATION_LEVEL) && !programInterface.supportsMetricAccumulationLevel()) {
                log.warn(new Object[]{"The " + programInterface.toString() + " program does not support a metric accumulation level, but METRIC_ACCUMULATION_LEVEL" + " was overridden in the command line. " + programInterface.toString() + " will be run against the entire input."});
            }
            String string = null != this.FILE_EXTENSION ? this.FILE_EXTENSION : "";
            SinglePassSamProgram singlePassSamProgram = programInterface.makeInstance(this.OUTPUT, string, this.INPUT, this.REFERENCE_SEQUENCE, this.METRIC_ACCUMULATION_LEVEL, this.DB_SNP, this.INTERVALS);
            singlePassSamProgram.INPUT = this.INPUT;
            singlePassSamProgram.REFERENCE_SEQUENCE = this.REFERENCE_SEQUENCE;
            singlePassSamProgram.setDefaultHeaders(this.getDefaultHeaders());
            arrayList.add(singlePassSamProgram);
        }
        SinglePassSamProgram.makeItSo(this.INPUT, this.REFERENCE_SEQUENCE, this.ASSUME_SORTED, this.STOP_AFTER, arrayList);
        return 0;
    }

    public static enum Program implements ProgramInterface
    {
        CollectAlignmentSummaryMetrics{

            @Override
            public boolean needsReferenceSequence() {
                return false;
            }

            @Override
            public boolean supportsMetricAccumulationLevel() {
                return true;
            }

            @Override
            public SinglePassSamProgram makeInstance(String string, String string2, File file, File file2, Set<MetricAccumulationLevel> set, File file3, File file4) {
                CollectAlignmentSummaryMetrics collectAlignmentSummaryMetrics = new CollectAlignmentSummaryMetrics();
                collectAlignmentSummaryMetrics.OUTPUT = new File(string + ".alignment_summary_metrics" + string2);
                collectAlignmentSummaryMetrics.METRIC_ACCUMULATION_LEVEL = set;
                collectAlignmentSummaryMetrics.INPUT = file;
                collectAlignmentSummaryMetrics.REFERENCE_SEQUENCE = file2;
                return collectAlignmentSummaryMetrics;
            }
        }
        ,
        CollectInsertSizeMetrics{

            @Override
            public boolean needsReferenceSequence() {
                return false;
            }

            @Override
            public boolean supportsMetricAccumulationLevel() {
                return true;
            }

            @Override
            public SinglePassSamProgram makeInstance(String string, String string2, File file, File file2, Set<MetricAccumulationLevel> set, File file3, File file4) {
                CollectInsertSizeMetrics collectInsertSizeMetrics = new CollectInsertSizeMetrics();
                collectInsertSizeMetrics.OUTPUT = new File(string + ".insert_size_metrics" + string2);
                collectInsertSizeMetrics.Histogram_FILE = new File(string + ".insert_size_histogram.pdf");
                collectInsertSizeMetrics.METRIC_ACCUMULATION_LEVEL = set;
                collectInsertSizeMetrics.INPUT = file;
                collectInsertSizeMetrics.REFERENCE_SEQUENCE = file2;
                return collectInsertSizeMetrics;
            }
        }
        ,
        QualityScoreDistribution{

            @Override
            public boolean needsReferenceSequence() {
                return false;
            }

            @Override
            public boolean supportsMetricAccumulationLevel() {
                return false;
            }

            @Override
            public SinglePassSamProgram makeInstance(String string, String string2, File file, File file2, Set<MetricAccumulationLevel> set, File file3, File file4) {
                QualityScoreDistribution qualityScoreDistribution = new QualityScoreDistribution();
                qualityScoreDistribution.OUTPUT = new File(string + ".quality_distribution_metrics" + string2);
                qualityScoreDistribution.CHART_OUTPUT = new File(string + ".quality_distribution.pdf");
                qualityScoreDistribution.INPUT = file;
                qualityScoreDistribution.REFERENCE_SEQUENCE = file2;
                return qualityScoreDistribution;
            }
        }
        ,
        MeanQualityByCycle{

            @Override
            public boolean needsReferenceSequence() {
                return false;
            }

            @Override
            public boolean supportsMetricAccumulationLevel() {
                return false;
            }

            @Override
            public SinglePassSamProgram makeInstance(String string, String string2, File file, File file2, Set<MetricAccumulationLevel> set, File file3, File file4) {
                MeanQualityByCycle meanQualityByCycle = new MeanQualityByCycle();
                meanQualityByCycle.OUTPUT = new File(string + ".quality_by_cycle_metrics" + string2);
                meanQualityByCycle.CHART_OUTPUT = new File(string + ".quality_by_cycle.pdf");
                meanQualityByCycle.INPUT = file;
                meanQualityByCycle.REFERENCE_SEQUENCE = file2;
                return meanQualityByCycle;
            }
        }
        ,
        CollectBaseDistributionByCycle{

            @Override
            public boolean needsReferenceSequence() {
                return false;
            }

            @Override
            public boolean supportsMetricAccumulationLevel() {
                return false;
            }

            @Override
            public SinglePassSamProgram makeInstance(String string, String string2, File file, File file2, Set<MetricAccumulationLevel> set, File file3, File file4) {
                CollectBaseDistributionByCycle collectBaseDistributionByCycle = new CollectBaseDistributionByCycle();
                collectBaseDistributionByCycle.OUTPUT = new File(string + ".base_distribution_by_cycle_metrics" + string2);
                collectBaseDistributionByCycle.CHART_OUTPUT = new File(string + ".base_distribution_by_cycle.pdf");
                collectBaseDistributionByCycle.INPUT = file;
                collectBaseDistributionByCycle.REFERENCE_SEQUENCE = file2;
                return collectBaseDistributionByCycle;
            }
        }
        ,
        CollectGcBiasMetrics{

            @Override
            public boolean needsReferenceSequence() {
                return true;
            }

            @Override
            public boolean supportsMetricAccumulationLevel() {
                return true;
            }

            @Override
            public SinglePassSamProgram makeInstance(String string, String string2, File file, File file2, Set<MetricAccumulationLevel> set, File file3, File file4) {
                CollectGcBiasMetrics collectGcBiasMetrics = new CollectGcBiasMetrics();
                collectGcBiasMetrics.OUTPUT = new File(string + ".gc_bias.detail_metrics" + string2);
                collectGcBiasMetrics.SUMMARY_OUTPUT = new File(string + ".gc_bias.summary_metrics" + string2);
                collectGcBiasMetrics.CHART_OUTPUT = new File(string + ".gc_bias.pdf");
                collectGcBiasMetrics.INPUT = file;
                collectGcBiasMetrics.METRIC_ACCUMULATION_LEVEL = set;
                collectGcBiasMetrics.SCAN_WINDOW_SIZE = 100;
                collectGcBiasMetrics.MINIMUM_GENOME_FRACTION = 1.0E-5;
                collectGcBiasMetrics.IS_BISULFITE_SEQUENCED = false;
                collectGcBiasMetrics.ASSUME_SORTED = false;
                collectGcBiasMetrics.REFERENCE_SEQUENCE = file2;
                return collectGcBiasMetrics;
            }
        }
        ,
        RnaSeqMetrics{

            @Override
            public boolean needsReferenceSequence() {
                return true;
            }

            @Override
            public boolean supportsMetricAccumulationLevel() {
                return true;
            }

            @Override
            public SinglePassSamProgram makeInstance(String string, String string2, File file, File file2, Set<MetricAccumulationLevel> set, File file3, File file4) {
                CollectRnaSeqMetrics collectRnaSeqMetrics = new CollectRnaSeqMetrics();
                collectRnaSeqMetrics.OUTPUT = new File(string + ".rna_metrics" + string2);
                collectRnaSeqMetrics.CHART_OUTPUT = new File(string + ".rna_coverage.pdf");
                collectRnaSeqMetrics.METRIC_ACCUMULATION_LEVEL = set;
                collectRnaSeqMetrics.INPUT = file;
                collectRnaSeqMetrics.REFERENCE_SEQUENCE = file2;
                return collectRnaSeqMetrics;
            }
        }
        ,
        CollectSequencingArtifactMetrics{

            @Override
            public boolean needsReferenceSequence() {
                return true;
            }

            @Override
            public boolean supportsMetricAccumulationLevel() {
                return false;
            }

            @Override
            public SinglePassSamProgram makeInstance(String string, String string2, File file, File file2, Set<MetricAccumulationLevel> set, File file3, File file4) {
                CollectSequencingArtifactMetrics collectSequencingArtifactMetrics = new CollectSequencingArtifactMetrics();
                collectSequencingArtifactMetrics.OUTPUT = new File(string);
                collectSequencingArtifactMetrics.FILE_EXTENSION = string2;
                collectSequencingArtifactMetrics.DB_SNP = file3;
                collectSequencingArtifactMetrics.INTERVALS = file4;
                collectSequencingArtifactMetrics.INPUT = file;
                collectSequencingArtifactMetrics.REFERENCE_SEQUENCE = file2;
                return collectSequencingArtifactMetrics;
            }
        }
        ,
        CollectQualityYieldMetrics{

            @Override
            public boolean needsReferenceSequence() {
                return false;
            }

            @Override
            public boolean supportsMetricAccumulationLevel() {
                return false;
            }

            @Override
            public SinglePassSamProgram makeInstance(String string, String string2, File file, File file2, Set<MetricAccumulationLevel> set, File file3, File file4) {
                CollectQualityYieldMetrics collectQualityYieldMetrics = new CollectQualityYieldMetrics();
                collectQualityYieldMetrics.OUTPUT = new File(string + ".quality_yield_metrics" + string2);
                collectQualityYieldMetrics.INPUT = file;
                collectQualityYieldMetrics.REFERENCE_SEQUENCE = file2;
                return collectQualityYieldMetrics;
            }
        };

    }

    public static interface ProgramInterface {
        public SinglePassSamProgram makeInstance(String var1, String var2, File var3, File var4, Set<MetricAccumulationLevel> var5, File var6, File var7);

        public boolean needsReferenceSequence();

        public boolean supportsMetricAccumulationLevel();
    }
}

