/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.filter.SecondaryAlignmentFilter;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFileWalker;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.QualityUtil;
import htsjdk.samtools.util.SamLocusIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.stream.IntStream;
import picard.analysis.TheoreticalSensitivity;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.filter.CountingDuplicateFilter;
import picard.filter.CountingFilter;
import picard.filter.CountingMapQFilter;
import picard.filter.CountingPairedFilter;
import picard.util.MathUtil;

@CommandLineProgramProperties(usage="Collect metrics about coverage and performance of whole genome sequencing (WGS) experiments.This tool collects metrics about the percentages of reads that pass base- and mapping- quality filters as well as coverage (read-depth) levels. Both minimum base- and mapping-quality values as well as the maximum read depths (coverage cap) are user defined.<h4>Usage Example:</h4><pre>java -jar picard.jar CollectWgsMetrics \\<br />       I=input.bam \\<br />       O=collect_wgs_metrics.txt \\<br />       R=reference_sequence.fasta </pre>Please see <a href='https://broadinstitute.github.io/picard/picard-metric-definitions.html#CollectWgsMetrics.WgsMetrics'>the WgsMetrics documentation</a> for detailed explanations of the output metrics.<hr />", usageShort="Collect metrics about coverage and performance of whole genome sequencing (WGS) experiments.", programGroup=Metrics.class)
public class CollectWgsMetrics
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Collect metrics about coverage and performance of whole genome sequencing (WGS) experiments.";
    static final String USAGE_DETAILS = "This tool collects metrics about the percentages of reads that pass base- and mapping- quality filters as well as coverage (read-depth) levels. Both minimum base- and mapping-quality values as well as the maximum read depths (coverage cap) are user defined.<h4>Usage Example:</h4><pre>java -jar picard.jar CollectWgsMetrics \\<br />       I=input.bam \\<br />       O=collect_wgs_metrics.txt \\<br />       R=reference_sequence.fasta </pre>Please see <a href='https://broadinstitute.github.io/picard/picard-metric-definitions.html#CollectWgsMetrics.WgsMetrics'>the WgsMetrics documentation</a> for detailed explanations of the output metrics.<hr />";
    @Option(shortName="I", doc="Input SAM or BAM file.")
    public File INPUT;
    @Option(shortName="O", doc="Output metrics file.")
    public File OUTPUT;
    @Option(shortName="R", doc="The reference sequence fasta aligned to.")
    public File REFERENCE_SEQUENCE;
    @Option(shortName="MQ", doc="Minimum mapping quality for a read to contribute coverage.", overridable=true)
    public int MINIMUM_MAPPING_QUALITY = 20;
    @Option(shortName="Q", doc="Minimum base quality for a base to contribute coverage.", overridable=true)
    public int MINIMUM_BASE_QUALITY = 20;
    @Option(shortName="CAP", doc="Treat positions with coverage exceeding this value as if they had coverage at this value (but calculate the difference for PCT_EXC_CAPPED).", overridable=true)
    public int COVERAGE_CAP = 250;
    @Option(doc="At positions with coverage exceeding this value, completely ignore reads that accumulate beyond this value (so that they will not be considered for PCT_EXC_CAPPED).  Used to keep memory consumption in check, but could create bias if set too low", overridable=true)
    public int LOCUS_ACCUMULATION_CAP = 100000;
    @Option(doc="For debugging purposes, stop after processing this many genomic bases.")
    public long STOP_AFTER = -1L;
    @Option(doc="Determines whether to include the base quality histogram in the metrics file.")
    public boolean INCLUDE_BQ_HISTOGRAM = false;
    @Option(doc="If true, count unpaired reads, and paired reads with one end unmapped")
    public boolean COUNT_UNPAIRED = false;
    @Option(doc="Sample Size used for Theoretical Het Sensitivity sampling. Default is 10000.", optional=true)
    public int SAMPLE_SIZE = 10000;
    @Option(doc="An interval list file that contains the positions to restrict the assessment. Please note that all bases of reads that overlap these intervals will be considered, even if some of those bases extend beyond the boundaries of the interval. The ideal use case for this argument is to use it to restrict the calculation to a subset of (whole) contigs. To restrict the calculation just to individual positions without overlap, please see CollectWgsMetricsFromSampledSites.", optional=true, overridable=true)
    public File INTERVALS = null;
    private SAMFileHeader header = null;
    private final Log log = Log.getInstance(CollectWgsMetrics.class);
    private static final double LOG_ODDS_THRESHOLD = 3.0;

    public static void main(String[] stringArray) {
        new CollectWgsMetrics().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        MetricsFile metricsFile;
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        IOUtil.assertFileIsReadable((File)this.REFERENCE_SEQUENCE);
        if (this.INTERVALS != null) {
            IOUtil.assertFileIsReadable((File)this.INTERVALS);
        }
        if (this.LOCUS_ACCUMULATION_CAP < this.COVERAGE_CAP) {
            this.log.warn(new Object[]{"Setting the LOCUS_ACCUMULATION_CAP to be equal to the COVERAGE_CAP (" + this.COVERAGE_CAP + ") because it should not be lower"});
            this.LOCUS_ACCUMULATION_CAP = this.COVERAGE_CAP;
        }
        ProgressLogger progressLogger = new ProgressLogger(this.log, 10000000, "Processed", "loci");
        ReferenceSequenceFileWalker referenceSequenceFileWalker = new ReferenceSequenceFileWalker(this.REFERENCE_SEQUENCE);
        SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.INPUT);
        SamLocusIterator samLocusIterator = this.getLocusIterator(samReader);
        this.header = samReader.getFileHeader();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        CountingDuplicateFilter countingDuplicateFilter = new CountingDuplicateFilter();
        CountingMapQFilter countingMapQFilter = new CountingMapQFilter(this.MINIMUM_MAPPING_QUALITY);
        CountingPairedFilter countingPairedFilter = new CountingPairedFilter();
        arrayList.add(new SecondaryAlignmentFilter());
        arrayList.add(countingMapQFilter);
        arrayList.add(countingDuplicateFilter);
        if (!this.COUNT_UNPAIRED) {
            arrayList.add(countingPairedFilter);
        }
        samLocusIterator.setSamFilters(arrayList);
        samLocusIterator.setEmitUncoveredLoci(true);
        samLocusIterator.setMappingQualityScoreCutoff(0);
        samLocusIterator.setQualityScoreCutoff(0);
        samLocusIterator.setIncludeNonPfReads(false);
        samLocusIterator.setMaxReadsToAccumulatePerLocus(this.LOCUS_ACCUMULATION_CAP);
        WgsMetricsCollector wgsMetricsCollector = this.getCollector(this.COVERAGE_CAP);
        boolean bl = this.STOP_AFTER > 0L;
        long l = this.STOP_AFTER - 1L;
        long l2 = 0L;
        while (samLocusIterator.hasNext()) {
            metricsFile = samLocusIterator.next();
            ReferenceSequence referenceSequence = referenceSequenceFileWalker.get(metricsFile.getSequenceIndex());
            byte by = referenceSequence.getBases()[metricsFile.getPosition() - 1];
            if (by == 78) continue;
            wgsMetricsCollector.addInfo((SamLocusIterator.LocusInfo)metricsFile, referenceSequence);
            progressLogger.record(metricsFile.getSequenceName(), metricsFile.getPosition());
            if (!bl || ++l2 <= l) continue;
            break;
        }
        metricsFile = this.getMetricsFile();
        wgsMetricsCollector.addToMetricsFile(metricsFile, this.INCLUDE_BQ_HISTOGRAM, countingDuplicateFilter, countingMapQFilter, countingPairedFilter);
        metricsFile.write(this.OUTPUT);
        return 0;
    }

    protected SAMFileHeader getSamFileHeader() {
        return this.header;
    }

    protected WgsMetrics generateWgsMetrics() {
        return new WgsMetrics();
    }

    protected long getBasesExcludedBy(CountingFilter countingFilter) {
        return countingFilter.getFilteredBases();
    }

    protected SamLocusIterator getLocusIterator(SamReader samReader) {
        return this.INTERVALS != null ? new SamLocusIterator(samReader, IntervalList.fromFile((File)this.INTERVALS)) : new SamLocusIterator(samReader);
    }

    protected WgsMetricsCollector getCollector(int n) {
        return new WgsMetricsCollector(n);
    }

    protected class WgsMetricsCollector {
        protected final long[] histogramArray;
        private final long[] baseQHistogramArray;
        private final long[] baseQHetSensHistogram;
        private long basesExcludedByBaseq = 0L;
        private long basesExcludedByOverlap = 0L;
        private long basesExcludedByCapping = 0L;
        protected final int coverageCap;

        public WgsMetricsCollector(int n) {
            this.histogramArray = new long[n + 1];
            this.baseQHistogramArray = new long[127];
            this.baseQHetSensHistogram = new long[127];
            this.coverageCap = n;
        }

        public void addInfo(SamLocusIterator.LocusInfo locusInfo, ReferenceSequence referenceSequence) {
            HashSet<String> hashSet = new HashSet<String>(locusInfo.getRecordAndPositions().size());
            int n = 0;
            int n2 = 0;
            for (SamLocusIterator.RecordAndOffset recordAndOffset : locusInfo.getRecordAndPositions()) {
                if (++n2 <= this.coverageCap) {
                    byte by = recordAndOffset.getRecord().getBaseQualities()[recordAndOffset.getOffset()];
                    this.baseQHetSensHistogram[by] = this.baseQHetSensHistogram[by] + 1L;
                }
                if (recordAndOffset.getBaseQuality() < CollectWgsMetrics.this.MINIMUM_BASE_QUALITY) {
                    ++this.basesExcludedByBaseq;
                    continue;
                }
                if (!hashSet.add(recordAndOffset.getRecord().getReadName())) {
                    ++this.basesExcludedByOverlap;
                    continue;
                }
                if (++n > this.coverageCap) continue;
                byte by = recordAndOffset.getRecord().getBaseQualities()[recordAndOffset.getOffset()];
                this.baseQHistogramArray[by] = this.baseQHistogramArray[by] + 1L;
            }
            int n3 = Math.min(hashSet.size(), this.coverageCap);
            if (n3 < hashSet.size()) {
                this.basesExcludedByCapping += (long)(hashSet.size() - this.coverageCap);
            }
            int n4 = n3;
            this.histogramArray[n4] = this.histogramArray[n4] + 1L;
        }

        public void addToMetricsFile(MetricsFile<WgsMetrics, Integer> metricsFile, boolean bl, CountingFilter countingFilter, CountingFilter countingFilter2, CountingPairedFilter countingPairedFilter) {
            this.addMetricsToFile(metricsFile, countingFilter, countingFilter2, countingPairedFilter);
            if (bl) {
                this.addBaseQHistogram(metricsFile);
            }
        }

        protected void addBaseQHistogram(MetricsFile<WgsMetrics, Integer> metricsFile) {
            Histogram histogram = new Histogram("value", "baseq_count");
            for (int i = 0; i < this.baseQHistogramArray.length; ++i) {
                histogram.increment((Comparable)Integer.valueOf(i), (double)this.baseQHistogramArray[i]);
            }
            if (CollectWgsMetrics.this.INCLUDE_BQ_HISTOGRAM) {
                metricsFile.addHistogram(histogram);
            }
        }

        protected void addMetricsToFile(MetricsFile<WgsMetrics, Integer> metricsFile, CountingFilter countingFilter, CountingFilter countingFilter2, CountingPairedFilter countingPairedFilter) {
            Histogram<Integer> histogram = this.getDepthHistogram();
            WgsMetrics wgsMetrics = this.getMetrics(histogram, countingFilter, countingFilter2, countingPairedFilter);
            metricsFile.addMetric((MetricBase)wgsMetrics);
            metricsFile.addHistogram(histogram);
        }

        protected Histogram<Integer> getDepthHistogram() {
            Histogram histogram = new Histogram("coverage", "count");
            for (int i = 0; i < this.histogramArray.length; ++i) {
                histogram.increment((Comparable)Integer.valueOf(i), (double)this.histogramArray[i]);
            }
            return histogram;
        }

        protected WgsMetrics getMetrics(Histogram<Integer> histogram, CountingFilter countingFilter, CountingFilter countingFilter2, CountingPairedFilter countingPairedFilter) {
            Histogram histogram2 = new Histogram("value", "baseq_count");
            Comparable[] comparableArray = new Integer[50];
            IntStream.range(0, 50).forEach(arg_0 -> WgsMetricsCollector.lambda$getMetrics$0((Integer[])comparableArray, arg_0));
            histogram2.prefillBins(comparableArray);
            for (int i = 0; i < this.baseQHetSensHistogram.length; ++i) {
                histogram2.increment((Comparable)Integer.valueOf(i < 17 ? 0 : i), (double)this.baseQHetSensHistogram[i]);
            }
            WgsMetrics wgsMetrics = CollectWgsMetrics.this.generateWgsMetrics();
            wgsMetrics.GENOME_TERRITORY = (long)histogram.getSumOfValues();
            wgsMetrics.MEAN_COVERAGE = histogram.getMean();
            wgsMetrics.SD_COVERAGE = histogram.getStandardDeviation();
            wgsMetrics.MEDIAN_COVERAGE = histogram.getMedian();
            wgsMetrics.MAD_COVERAGE = histogram.getMedianAbsoluteDeviation();
            long l = CollectWgsMetrics.this.getBasesExcludedBy(countingFilter);
            long l2 = CollectWgsMetrics.this.getBasesExcludedBy(countingFilter2);
            long l3 = CollectWgsMetrics.this.getBasesExcludedBy(countingPairedFilter);
            double d = histogram.getSum();
            double d2 = d + (double)l + (double)l2 + (double)l3 + (double)this.basesExcludedByBaseq + (double)this.basesExcludedByOverlap + (double)this.basesExcludedByCapping;
            wgsMetrics.PCT_EXC_DUPE = (double)l / d2;
            wgsMetrics.PCT_EXC_MAPQ = (double)l2 / d2;
            wgsMetrics.PCT_EXC_UNPAIRED = (double)l3 / d2;
            wgsMetrics.PCT_EXC_BASEQ = (double)this.basesExcludedByBaseq / d2;
            wgsMetrics.PCT_EXC_OVERLAP = (double)this.basesExcludedByOverlap / d2;
            wgsMetrics.PCT_EXC_CAPPED = (double)this.basesExcludedByCapping / d2;
            wgsMetrics.PCT_EXC_TOTAL = (d2 - d) / d2;
            wgsMetrics.PCT_1X = (double)MathUtil.sum(this.histogramArray, 1, this.histogramArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
            wgsMetrics.PCT_5X = (double)MathUtil.sum(this.histogramArray, 5, this.histogramArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
            wgsMetrics.PCT_10X = (double)MathUtil.sum(this.histogramArray, 10, this.histogramArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
            wgsMetrics.PCT_15X = (double)MathUtil.sum(this.histogramArray, 15, this.histogramArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
            wgsMetrics.PCT_20X = (double)MathUtil.sum(this.histogramArray, 20, this.histogramArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
            wgsMetrics.PCT_25X = (double)MathUtil.sum(this.histogramArray, 25, this.histogramArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
            wgsMetrics.PCT_30X = (double)MathUtil.sum(this.histogramArray, 30, this.histogramArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
            wgsMetrics.PCT_40X = (double)MathUtil.sum(this.histogramArray, 40, this.histogramArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
            wgsMetrics.PCT_50X = (double)MathUtil.sum(this.histogramArray, 50, this.histogramArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
            wgsMetrics.PCT_60X = (double)MathUtil.sum(this.histogramArray, 60, this.histogramArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
            wgsMetrics.PCT_70X = (double)MathUtil.sum(this.histogramArray, 70, this.histogramArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
            wgsMetrics.PCT_80X = (double)MathUtil.sum(this.histogramArray, 80, this.histogramArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
            wgsMetrics.PCT_90X = (double)MathUtil.sum(this.histogramArray, 90, this.histogramArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
            wgsMetrics.PCT_100X = (double)MathUtil.sum(this.histogramArray, 100, this.histogramArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
            double[] dArray = TheoreticalSensitivity.normalizeHistogram(histogram);
            double[] dArray2 = TheoreticalSensitivity.normalizeHistogram((Histogram<Integer>)histogram2);
            wgsMetrics.HET_SNP_SENSITIVITY = TheoreticalSensitivity.hetSNPSensitivity(dArray, dArray2, CollectWgsMetrics.this.SAMPLE_SIZE, 3.0);
            wgsMetrics.HET_SNP_Q = QualityUtil.getPhredScoreFromErrorProbability((double)(1.0 - wgsMetrics.HET_SNP_SENSITIVITY));
            return wgsMetrics;
        }

        private static /* synthetic */ void lambda$getMetrics$0(Integer[] integerArray, int n) {
            integerArray[n] = n;
        }
    }

    public static class WgsMetrics
    extends MetricBase {
        public long GENOME_TERRITORY;
        public double MEAN_COVERAGE;
        public double SD_COVERAGE;
        public double MEDIAN_COVERAGE;
        public double MAD_COVERAGE;
        public double PCT_EXC_MAPQ;
        public double PCT_EXC_DUPE;
        public double PCT_EXC_UNPAIRED;
        public double PCT_EXC_BASEQ;
        public double PCT_EXC_OVERLAP;
        public double PCT_EXC_CAPPED;
        public double PCT_EXC_TOTAL;
        public double PCT_1X;
        public double PCT_5X;
        public double PCT_10X;
        public double PCT_15X;
        public double PCT_20X;
        public double PCT_25X;
        public double PCT_30X;
        public double PCT_40X;
        public double PCT_50X;
        public double PCT_60X;
        public double PCT_70X;
        public double PCT_80X;
        public double PCT_90X;
        public double PCT_100X;
        public double HET_SNP_SENSITIVITY;
        public double HET_SNP_Q;
    }
}

