/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.PositionalArguments;
import picard.cmdline.programgroups.Metrics;

@CommandLineProgramProperties(usage="Compare two metrics files.This tool compares the metrics and histograms generated from metric tools to determine if the generated results are identical.  This tool is useful to test and compare outputs when code changes are implemented. It is not meant for use by end-users of this toolkit.<br /><br />  The tool's output simply indicates whether two metrics files are equal or not equal. <br /> <h4>Usage example:</h4><pre>java -jar picard.jar CompareMetrics \\<br />      metricfile1.txt \\<br />      metricfile2.txt</pre><hr />", usageShort="Compare two metrics files.", programGroup=Metrics.class)
public class CompareMetrics
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Compare two metrics files.";
    static final String USAGE_DETAIL = "This tool compares the metrics and histograms generated from metric tools to determine if the generated results are identical.  This tool is useful to test and compare outputs when code changes are implemented. It is not meant for use by end-users of this toolkit.<br /><br />  The tool's output simply indicates whether two metrics files are equal or not equal. <br /> <h4>Usage example:</h4><pre>java -jar picard.jar CompareMetrics \\<br />      metricfile1.txt \\<br />      metricfile2.txt</pre><hr />";
    @PositionalArguments(minElements=2, maxElements=2)
    public List<File> metricsFiles;
    private static final Log log = Log.getInstance(CompareMetrics.class);

    @Override
    protected int doWork() {
        IOUtil.assertFilesAreReadable(this.metricsFiles);
        MetricsFile metricsFile = new MetricsFile();
        MetricsFile metricsFile2 = new MetricsFile();
        try {
            metricsFile.read((Reader)new FileReader(this.metricsFiles.get(0)));
            metricsFile2.read((Reader)new FileReader(this.metricsFiles.get(1)));
            boolean bl = metricsFile.areMetricsEqual(metricsFile2) && metricsFile.areHistogramsEqual(metricsFile2);
            String string = bl ? "EQUAL" : "NOT EQUAL";
            log.info(new Object[]{"Files " + this.metricsFiles.get(0) + " and " + this.metricsFiles.get(1) + "are " + string});
        }
        catch (Exception exception) {
            throw new PicardException(exception.getMessage());
        }
        return 0;
    }

    public static void main(String[] stringArray) {
        new CompareMetrics().instanceMainWithExit(stringArray);
    }
}

