/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.QualityUtil;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.analysis.GcBiasCollectorArgs;
import picard.analysis.GcBiasDetailMetrics;
import picard.analysis.GcBiasSummaryMetrics;
import picard.analysis.GcBiasUtils;
import picard.analysis.MetricAccumulationLevel;
import picard.metrics.GcBiasMetrics;
import picard.metrics.MultiLevelCollector;
import picard.metrics.PerUnitMetricCollector;

public class GcBiasMetricsCollector
extends MultiLevelCollector<GcBiasMetrics, Integer, GcBiasCollectorArgs> {
    private final int scanWindowSize;
    private final boolean bisulfite;
    private int[] windowsByGc = new int[101];
    private static final int BINS = 101;
    private byte[] gc = null;
    private int referenceIndex = -1;
    private byte[] refBases = null;

    public GcBiasMetricsCollector(Set<MetricAccumulationLevel> set, int[] nArray, List<SAMReadGroupRecord> list, int n, boolean bl) {
        this.scanWindowSize = n;
        this.bisulfite = bl;
        this.windowsByGc = nArray;
        this.setup(set, list);
    }

    @Override
    protected GcBiasCollectorArgs makeArg(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
        return new GcBiasCollectorArgs(sAMRecord, referenceSequence);
    }

    @Override
    protected PerUnitMetricCollector<GcBiasMetrics, Integer, GcBiasCollectorArgs> makeChildCollector(String string, String string2, String string3) {
        return new PerUnitGcBiasMetricsCollector(string, string2, string3);
    }

    @Override
    public void acceptRecord(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
        super.acceptRecord(sAMRecord, referenceSequence);
    }

    private double calculateGcNormCoverage(double d, int[] nArray, int n, int n2) {
        int n3 = 0;
        double d2 = 0.0;
        for (int i = n; i <= n2; ++i) {
            if (this.windowsByGc[i] == 0) continue;
            d2 += (double)nArray[i];
            n3 += this.windowsByGc[i];
        }
        if (n3 == 0) {
            return 0.0;
        }
        return d2 / ((double)n3 * d);
    }

    private void calculateDropoutMetrics(Collection<GcBiasDetailMetrics> collection, GcBiasSummaryMetrics gcBiasSummaryMetrics) {
        double d = 0.0;
        double d2 = 0.0;
        for (GcBiasDetailMetrics gcBiasDetailMetrics : collection) {
            d += (double)gcBiasDetailMetrics.READ_STARTS;
            d2 += (double)gcBiasDetailMetrics.WINDOWS;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        for (GcBiasDetailMetrics gcBiasDetailMetrics : collection) {
            double d5 = (double)gcBiasDetailMetrics.WINDOWS / d2;
            double d6 = (double)gcBiasDetailMetrics.READ_STARTS / d;
            double d7 = (d5 - d6) * 100.0;
            if (!(d7 > 0.0)) continue;
            if (gcBiasDetailMetrics.GC <= 50) {
                d3 += d7;
                continue;
            }
            d4 += d7;
        }
        gcBiasSummaryMetrics.AT_DROPOUT = d3;
        gcBiasSummaryMetrics.GC_DROPOUT = d4;
    }

    private void addRead(GcObject gcObject, SAMRecord sAMRecord, String string, byte[] byArray, byte[] byArray2) {
        byte by;
        if (!sAMRecord.getReadPairedFlag() || sAMRecord.getFirstOfPairFlag()) {
            ++gcObject.totalClusters;
        }
        int n = sAMRecord.getReadNegativeStrandFlag() ? sAMRecord.getAlignmentEnd() - this.scanWindowSize : sAMRecord.getAlignmentStart();
        ++gcObject.totalAlignedReads;
        if (n > 0 && (by = byArray[n]) >= 0) {
            byte by2 = by;
            gcObject.readsByGc[by2] = gcObject.readsByGc[by2] + 1;
            byte by3 = by;
            gcObject.basesByGc[by3] = gcObject.basesByGc[by3] + (long)sAMRecord.getReadLength();
            byte by4 = by;
            gcObject.errorsByGc[by4] = gcObject.errorsByGc[by4] + (long)(SequenceUtil.countMismatches((SAMRecord)sAMRecord, (byte[])byArray2, (boolean)this.bisulfite) + SequenceUtil.countInsertedBases((SAMRecord)sAMRecord) + SequenceUtil.countDeletedBases((SAMRecord)sAMRecord));
        }
        if (gcObject.group == null) {
            gcObject.group = string;
        }
    }

    static /* synthetic */ byte[] access$202(GcBiasMetricsCollector gcBiasMetricsCollector, byte[] byArray) {
        gcBiasMetricsCollector.refBases = byArray;
        return byArray;
    }

    static /* synthetic */ byte[] access$102(GcBiasMetricsCollector gcBiasMetricsCollector, byte[] byArray) {
        gcBiasMetricsCollector.gc = byArray;
        return byArray;
    }

    class GcObject {
        int totalClusters = 0;
        long totalAlignedReads = 0L;
        int[] readsByGc = new int[101];
        long[] basesByGc = new long[101];
        long[] errorsByGc = new long[101];
        String group = null;

        GcObject() {
        }
    }

    public class PerUnitGcBiasMetricsCollector
    implements PerUnitMetricCollector<GcBiasMetrics, Integer, GcBiasCollectorArgs> {
        Map<String, GcObject> gcData = new HashMap<String, GcObject>();
        private final String sample;
        private final String library;
        private final String readGroup;
        private static final String allReads = "All_Reads";

        public PerUnitGcBiasMetricsCollector(String string, String string2, String string3) {
            this.sample = string;
            this.library = string2;
            this.readGroup = string3;
            if (this.readGroup != null) {
                String string4 = this.readGroup;
                this.gcData.put(string4, new GcObject());
            } else if (this.library != null) {
                String string5 = this.library;
                this.gcData.put(string5, new GcObject());
            } else if (this.sample != null) {
                String string6 = this.sample;
                this.gcData.put(string6, new GcObject());
            } else {
                String string7 = allReads;
                this.gcData.put(string7, new GcObject());
            }
        }

        @Override
        public void acceptRecord(GcBiasCollectorArgs gcBiasCollectorArgs) {
            SAMRecord sAMRecord = gcBiasCollectorArgs.getRec();
            if (!sAMRecord.getReadUnmappedFlag()) {
                Object object;
                if (GcBiasMetricsCollector.this.referenceIndex != sAMRecord.getReferenceIndex() || GcBiasMetricsCollector.this.gc == null) {
                    object = gcBiasCollectorArgs.getRef();
                    GcBiasMetricsCollector.access$202(GcBiasMetricsCollector.this, object.getBases());
                    StringUtil.toUpperCase((byte[])GcBiasMetricsCollector.this.refBases);
                    int n = GcBiasMetricsCollector.this.refBases.length;
                    int n2 = n - GcBiasMetricsCollector.this.scanWindowSize;
                    GcBiasMetricsCollector.access$102(GcBiasMetricsCollector.this, GcBiasUtils.calculateAllGcs(GcBiasMetricsCollector.this.refBases, n2, GcBiasMetricsCollector.this.scanWindowSize));
                    GcBiasMetricsCollector.this.referenceIndex = sAMRecord.getReferenceIndex();
                }
                if (this.readGroup != null) {
                    String string = this.readGroup;
                    object = "Read Group";
                    GcBiasMetricsCollector.this.addRead(this.gcData.get(string), sAMRecord, (String)object, GcBiasMetricsCollector.this.gc, GcBiasMetricsCollector.this.refBases);
                } else if (this.library != null) {
                    String string = this.library;
                    object = "Library";
                    GcBiasMetricsCollector.this.addRead(this.gcData.get(string), sAMRecord, (String)object, GcBiasMetricsCollector.this.gc, GcBiasMetricsCollector.this.refBases);
                } else if (this.sample != null) {
                    String string = this.sample;
                    object = "Sample";
                    GcBiasMetricsCollector.this.addRead(this.gcData.get(string), sAMRecord, (String)object, GcBiasMetricsCollector.this.gc, GcBiasMetricsCollector.this.refBases);
                } else {
                    String string = allReads;
                    object = "All Reads";
                    GcBiasMetricsCollector.this.addRead(this.gcData.get(string), sAMRecord, (String)object, GcBiasMetricsCollector.this.gc, GcBiasMetricsCollector.this.refBases);
                }
            } else {
                for (Map.Entry<String, GcObject> entry : this.gcData.entrySet()) {
                    GcObject gcObject = entry.getValue();
                    if (sAMRecord.getReadPairedFlag() && !sAMRecord.getFirstOfPairFlag()) continue;
                    ++gcObject.totalClusters;
                }
            }
        }

        @Override
        public void finish() {
        }

        private double sum(int[] nArray) {
            int n = nArray.length;
            double d = 0.0;
            for (int i = 0; i < n; ++i) {
                d += (double)nArray[i];
            }
            return d;
        }

        @Override
        public void addMetricsToFile(MetricsFile<GcBiasMetrics, Integer> metricsFile) {
            for (Map.Entry<String, GcObject> entry : this.gcData.entrySet()) {
                GcObject gcObject = entry.getValue();
                String string = entry.getKey();
                int[] nArray = gcObject.readsByGc;
                long[] lArray = gcObject.errorsByGc;
                long[] lArray2 = gcObject.basesByGc;
                int n = gcObject.totalClusters;
                long l = gcObject.totalAlignedReads;
                String string2 = gcObject.group;
                GcBiasMetrics gcBiasMetrics = new GcBiasMetrics();
                double d = this.sum(GcBiasMetricsCollector.this.windowsByGc);
                double d2 = this.sum(nArray);
                double d3 = d2 / d;
                if (l <= 0L) continue;
                for (int i = 0; i < GcBiasMetricsCollector.this.windowsByGc.length; ++i) {
                    GcBiasDetailMetrics gcBiasDetailMetrics = new GcBiasDetailMetrics();
                    gcBiasDetailMetrics.GC = i;
                    gcBiasDetailMetrics.WINDOWS = GcBiasMetricsCollector.this.windowsByGc[i];
                    gcBiasDetailMetrics.READ_STARTS = nArray[i];
                    if (lArray[i] > 0L) {
                        gcBiasDetailMetrics.MEAN_BASE_QUALITY = QualityUtil.getPhredScoreFromObsAndErrors((double)lArray2[i], (double)lArray[i]);
                    }
                    if (GcBiasMetricsCollector.this.windowsByGc[i] != 0) {
                        gcBiasDetailMetrics.NORMALIZED_COVERAGE = (double)gcBiasDetailMetrics.READ_STARTS / (double)gcBiasDetailMetrics.WINDOWS / d3;
                        gcBiasDetailMetrics.ERROR_BAR_WIDTH = Math.sqrt(gcBiasDetailMetrics.READ_STARTS) / (double)gcBiasDetailMetrics.WINDOWS / d3;
                    } else {
                        gcBiasDetailMetrics.NORMALIZED_COVERAGE = 0.0;
                        gcBiasDetailMetrics.ERROR_BAR_WIDTH = 0.0;
                    }
                    gcBiasDetailMetrics.ACCUMULATION_LEVEL = string2;
                    if (string2.equals("Read Group")) {
                        gcBiasDetailMetrics.READ_GROUP = string;
                    } else if (string2.equals("Sample")) {
                        gcBiasDetailMetrics.SAMPLE = string;
                    } else if (string2.equals("Library")) {
                        gcBiasDetailMetrics.LIBRARY = string;
                    }
                    gcBiasMetrics.DETAILS.addMetric((MetricBase)gcBiasDetailMetrics);
                }
                GcBiasSummaryMetrics gcBiasSummaryMetrics = new GcBiasSummaryMetrics();
                if (string2.equals("Read Group")) {
                    gcBiasSummaryMetrics.READ_GROUP = string;
                } else if (string2.equals("Sample")) {
                    gcBiasSummaryMetrics.SAMPLE = string;
                } else if (string2.equals("Library")) {
                    gcBiasSummaryMetrics.LIBRARY = string;
                }
                gcBiasSummaryMetrics.ACCUMULATION_LEVEL = string2;
                gcBiasSummaryMetrics.WINDOW_SIZE = GcBiasMetricsCollector.this.scanWindowSize;
                gcBiasSummaryMetrics.TOTAL_CLUSTERS = n;
                gcBiasSummaryMetrics.ALIGNED_READS = l;
                gcBiasSummaryMetrics.GC_NC_0_19 = GcBiasMetricsCollector.this.calculateGcNormCoverage(d3, nArray, 0, 19);
                gcBiasSummaryMetrics.GC_NC_20_39 = GcBiasMetricsCollector.this.calculateGcNormCoverage(d3, nArray, 20, 39);
                gcBiasSummaryMetrics.GC_NC_40_59 = GcBiasMetricsCollector.this.calculateGcNormCoverage(d3, nArray, 40, 59);
                gcBiasSummaryMetrics.GC_NC_60_79 = GcBiasMetricsCollector.this.calculateGcNormCoverage(d3, nArray, 60, 79);
                gcBiasSummaryMetrics.GC_NC_80_100 = GcBiasMetricsCollector.this.calculateGcNormCoverage(d3, nArray, 80, 100);
                GcBiasMetricsCollector.this.calculateDropoutMetrics(gcBiasMetrics.DETAILS.getMetrics(), gcBiasSummaryMetrics);
                gcBiasMetrics.SUMMARY = gcBiasSummaryMetrics;
                metricsFile.addMetric((MetricBase)gcBiasMetrics);
            }
        }
    }
}

