/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.io.File;

public class GcBiasUtils {
    public static int calculateGc(byte[] byArray, int n, int n2, CalculateGcState calculateGcState) {
        if (calculateGcState.init) {
            calculateGcState.init = false;
            calculateGcState.gcCount = 0;
            calculateGcState.nCount = 0;
            for (int i = n; i < n2; ++i) {
                byte by = byArray[i];
                if (SequenceUtil.basesEqual((byte)by, (byte)71) || SequenceUtil.basesEqual((byte)by, (byte)67)) {
                    ++calculateGcState.gcCount;
                    continue;
                }
                if (!SequenceUtil.basesEqual((byte)by, (byte)78)) continue;
                ++calculateGcState.nCount;
            }
        } else {
            byte by = byArray[n2 - 1];
            if (SequenceUtil.basesEqual((byte)by, (byte)71) || SequenceUtil.basesEqual((byte)by, (byte)67)) {
                ++calculateGcState.gcCount;
            } else if (by == 78) {
                ++calculateGcState.nCount;
            }
            if (SequenceUtil.basesEqual((byte)calculateGcState.priorBase, (byte)71) || SequenceUtil.basesEqual((byte)calculateGcState.priorBase, (byte)67)) {
                --calculateGcState.gcCount;
            } else if (SequenceUtil.basesEqual((byte)calculateGcState.priorBase, (byte)78)) {
                --calculateGcState.nCount;
            }
        }
        calculateGcState.priorBase = byArray[n];
        if (calculateGcState.nCount > 4) {
            return -1;
        }
        return calculateGcState.gcCount * 100 / (n2 - n);
    }

    public static int[] calculateRefWindowsByGc(int n, File file, int n2) {
        ReferenceSequence referenceSequence;
        ReferenceSequenceFile referenceSequenceFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)file);
        int[] nArray = new int[n];
        while ((referenceSequence = referenceSequenceFile.nextSequence()) != null) {
            byte[] byArray = referenceSequence.getBases();
            StringUtil.toUpperCase((byte[])byArray);
            int n3 = byArray.length;
            int n4 = n3 - n2;
            CalculateGcState calculateGcState = new GcBiasUtils().new CalculateGcState();
            for (int i = 1; i < n4; ++i) {
                int n5 = i + n2;
                int n6 = GcBiasUtils.calculateGc(byArray, i, n5, calculateGcState);
                if (n6 == -1) continue;
                int n7 = n6;
                nArray[n7] = nArray[n7] + 1;
            }
        }
        return nArray;
    }

    public static byte[] calculateAllGcs(byte[] byArray, int n, int n2) {
        CalculateGcState calculateGcState = new GcBiasUtils().new CalculateGcState();
        int n3 = byArray.length;
        byte[] byArray2 = new byte[n3 + 1];
        for (int i = 1; i < n; ++i) {
            int n4 = i + n2;
            int n5 = GcBiasUtils.calculateGc(byArray, i, n4, calculateGcState);
            byArray2[i] = (byte)n5;
        }
        return byArray2;
    }

    class CalculateGcState {
        boolean init = true;
        int nCount;
        int gcCount;
        byte priorBase;

        CalculateGcState() {
        }
    }
}

