/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import picard.PicardException;
import picard.util.MathUtil;

public class TheoreticalSensitivity {
    private static final Log log = Log.getInstance(TheoreticalSensitivity.class);
    private static final int SAMPLING_MAX = 600;
    private static final int MAX_CONSIDERED_DEPTH = 1000;

    public static double hetSNPSensitivity(double[] dArray, double[] dArray2, int n, double d) {
        return TheoreticalSensitivity.hetSNPSensitivity(dArray, dArray2, n, d, true);
    }

    public static double hetSNPSensitivity(double[] dArray, double[] dArray2, int n, double d, boolean bl) {
        int n2 = Math.min(dArray.length, 1001);
        if (bl) {
            log.info(new Object[]{"Creating Roulette Wheel"});
        }
        RouletteWheel rouletteWheel = new RouletteWheel(dArray2);
        if (bl) {
            log.info(new Object[]{"Calculating quality sums from quality sampler"});
        }
        List<ArrayList<Integer>> list = rouletteWheel.sampleCumulativeSums(n2, n, bl);
        ArrayList<Double> arrayList = new ArrayList<Double>(n2);
        double d2 = Math.log10(2.0);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(10.0 * ((double)i * d2 + d));
        }
        if (bl) {
            log.info(new Object[]{"Calculating theoretical het sensitivity"});
        }
        List<ArrayList<Double>> list2 = TheoreticalSensitivity.proportionsAboveThresholds(list, arrayList);
        List<ArrayList<Double>> list3 = TheoreticalSensitivity.hetAltDepthDistribution(n2);
        double d3 = 0.0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j <= i; ++j) {
                d3 += dArray[i] * list3.get(i).get(j) * list2.get(j).get(i);
            }
        }
        return d3;
    }

    public static List<ArrayList<Double>> proportionsAboveThresholds(List<ArrayList<Integer>> list, List<Double> list2) {
        ArrayList<ArrayList<Double>> arrayList = new ArrayList<ArrayList<Double>>();
        for (ArrayList<Integer> arrayList2 : list) {
            ArrayList<Double> arrayList3 = new ArrayList<Double>(Collections.nCopies(list2.size(), 0.0));
            Collections.sort(arrayList2);
            int n = 0;
            int n2 = 0;
            while (n < list2.size() && n2 < arrayList2.size()) {
                if (list2.get(n) > (double)arrayList2.get(n2).intValue()) {
                    ++n2;
                    continue;
                }
                arrayList3.set(n++, (double)(arrayList2.size() - n2) / (double)arrayList2.size());
            }
            arrayList.add(arrayList3);
        }
        return arrayList;
    }

    public static List<ArrayList<Double>> hetAltDepthDistribution(int n) {
        ArrayList<ArrayList<Double>> arrayList = new ArrayList<ArrayList<Double>>();
        for (int i = 0; i < n; ++i) {
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            arrayList2.add(Math.pow(0.5, i));
            for (int j = 1; j < i; ++j) {
                arrayList2.add((double)i * 0.5 / (double)j * (Double)((ArrayList)arrayList.get(i - 1)).get(j - 1));
            }
            if (i > 0) {
                arrayList2.add((Double)arrayList2.get(0));
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public static double[] normalizeHistogram(Histogram<Integer> histogram) {
        if (histogram == null) {
            throw new PicardException("Histogram is null and cannot be normalized");
        }
        double d = histogram.getSumOfValues();
        double[] dArray = new double[histogram.size()];
        for (int i = 0; i < histogram.size(); ++i) {
            dArray[i] = ((Histogram.Bin)histogram.get((Object)i)).getValue() / d;
        }
        return dArray;
    }

    public static class RouletteWheel {
        private final List<Double> probabilities;
        private final int N;
        private int count = 0;

        RouletteWheel(double[] dArray) {
            this.N = dArray.length;
            this.probabilities = new ArrayList<Double>();
            double d = MathUtil.max(dArray);
            if (d == 0.0) {
                throw new PicardException("Quality score distribution is empty.");
            }
            for (double d2 : dArray) {
                this.probabilities.add(d2 / d);
            }
        }

        public int draw() {
            do {
                int n = (int)((double)this.N * Math.random());
                ++this.count;
                if (!(Math.random() < this.probabilities.get(n))) continue;
                this.count = 0;
                return n;
            } while (this.count < 600);
            this.count = 0;
            return 0;
        }

        public List<ArrayList<Integer>> sampleCumulativeSums(int n, int n2, boolean bl) {
            int n3;
            ArrayList<ArrayList<Integer>> arrayList = new ArrayList<ArrayList<Integer>>();
            for (n3 = 0; n3 < n; ++n3) {
                arrayList.add(new ArrayList());
            }
            for (n3 = 0; n3 < n2; ++n3) {
                int n4 = 0;
                for (int i = 0; i < n; ++i) {
                    ((ArrayList)arrayList.get(i)).add(n4);
                    n4 += this.draw();
                }
                if (!bl || n3 % 1000 != 0) continue;
                log.info(new Object[]{n3 + " sampling iterations completed"});
            }
            return arrayList;
        }
    }
}

