/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.artifacts;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.ListMap;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.PicardException;
import picard.analysis.artifacts.ContextAccumulator;
import picard.analysis.artifacts.SequencingArtifactMetrics;
import picard.analysis.artifacts.Transition;

class ArtifactCounter {
    private final String sampleAlias;
    private final String library;
    private final Map<String, RefContext> contextMap = new HashMap<String, RefContext>();
    private final ContextAccumulator fullContextAccumulator;
    private final ContextAccumulator halfContextAccumulator;
    private final ContextAccumulator zeroContextAccumulator;
    private final List<SequencingArtifactMetrics.PreAdapterSummaryMetrics> preAdapterSummaryMetricsList;
    private final List<SequencingArtifactMetrics.PreAdapterDetailMetrics> preAdapterDetailMetricsList;
    private final List<SequencingArtifactMetrics.BaitBiasSummaryMetrics> baitBiasSummaryMetricsList;
    private final List<SequencingArtifactMetrics.BaitBiasDetailMetrics> baitBiasDetailMetricsList;
    private final Set<String> leadingContexts = new HashSet<String>();
    private final Set<String> trailingContexts = new HashSet<String>();

    public ArtifactCounter(String string, String string2, int n, boolean bl) {
        Object object2;
        this.sampleAlias = string;
        this.library = string2;
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object2 : SequenceUtil.generateAllKmers((int)(2 * n + 1))) {
            hashSet.add(StringUtil.bytesToString((byte[])object2));
        }
        HashSet hashSet2 = new HashSet();
        object2 = StringUtil.repeatCharNTimes((char)'N', (int)n);
        for (String string3 : hashSet) {
            char c = string3.charAt(n);
            String string4 = string3.substring(0, n) + c + (String)object2;
            String string5 = (String)object2 + c + string3.substring(n + 1, string3.length());
            String string6 = (String)object2 + c + (String)object2;
            this.contextMap.put(string3, new RefContext(string3, string4, string5, string6));
            this.leadingContexts.add(string4);
            this.trailingContexts.add(string5);
            hashSet2.add(string6);
        }
        HashSet<String> hashSet3 = new HashSet<String>(this.leadingContexts);
        hashSet3.addAll(this.trailingContexts);
        this.fullContextAccumulator = new ContextAccumulator(hashSet, bl);
        this.halfContextAccumulator = new ContextAccumulator((Set<String>)hashSet3, bl);
        this.zeroContextAccumulator = new ContextAccumulator(hashSet2, bl);
        this.preAdapterSummaryMetricsList = new ArrayList<SequencingArtifactMetrics.PreAdapterSummaryMetrics>();
        this.preAdapterDetailMetricsList = new ArrayList<SequencingArtifactMetrics.PreAdapterDetailMetrics>();
        this.baitBiasSummaryMetricsList = new ArrayList<SequencingArtifactMetrics.BaitBiasSummaryMetrics>();
        this.baitBiasDetailMetricsList = new ArrayList<SequencingArtifactMetrics.BaitBiasDetailMetrics>();
    }

    public void countRecord(String string, char c, SAMRecord sAMRecord) {
        if (this.contextMap.containsKey(string)) {
            RefContext refContext = this.contextMap.get(string);
            this.fullContextAccumulator.countRecord(refContext.ref, c, sAMRecord);
            this.halfContextAccumulator.countRecord(refContext.leading, c, sAMRecord);
            this.halfContextAccumulator.countRecord(refContext.trailing, c, sAMRecord);
            this.zeroContextAccumulator.countRecord(refContext.zero, c, sAMRecord);
        }
    }

    public void finish() {
        ListMap<Transition, SequencingArtifactMetrics.DetailPair> listMap = this.getDetailMetrics();
        Map<Transition, SequencingArtifactMetrics.SummaryPair> map = this.getSummaryMetrics();
        for (Transition transition : Transition.altValues()) {
            SequencingArtifactMetrics.SummaryPair summaryPair = map.get((Object)transition);
            List list = (List)listMap.get((Object)transition);
            this.preAdapterSummaryMetricsList.add(summaryPair.preAdapterMetrics);
            this.baitBiasSummaryMetricsList.add(summaryPair.baitBiasMetrics);
            for (SequencingArtifactMetrics.DetailPair detailPair : list) {
                this.preAdapterDetailMetricsList.add(detailPair.preAdapterMetrics);
                this.baitBiasDetailMetricsList.add(detailPair.baitBiasMetrics);
            }
        }
    }

    public List<SequencingArtifactMetrics.PreAdapterSummaryMetrics> getPreAdapterSummaryMetrics() {
        return this.preAdapterSummaryMetricsList;
    }

    public List<SequencingArtifactMetrics.PreAdapterDetailMetrics> getPreAdapterDetailMetrics() {
        return this.preAdapterDetailMetricsList;
    }

    public List<SequencingArtifactMetrics.BaitBiasSummaryMetrics> getBaitBiasSummaryMetrics() {
        return this.baitBiasSummaryMetricsList;
    }

    public List<SequencingArtifactMetrics.BaitBiasDetailMetrics> getBaitBiasDetailMetrics() {
        return this.baitBiasDetailMetricsList;
    }

    private Map<Transition, SequencingArtifactMetrics.SummaryPair> getSummaryMetrics() {
        HashMap<Transition, SequencingArtifactMetrics.SummaryPair> hashMap = new HashMap<Transition, SequencingArtifactMetrics.SummaryPair>();
        ListMap<Transition, SequencingArtifactMetrics.DetailPair> listMap = this.fullContextAccumulator.calculateMetrics(this.sampleAlias, this.library);
        ListMap<Transition, SequencingArtifactMetrics.DetailPair> listMap2 = this.halfContextAccumulator.calculateMetrics(this.sampleAlias, this.library);
        ListMap<Transition, SequencingArtifactMetrics.DetailPair> listMap3 = this.zeroContextAccumulator.calculateMetrics(this.sampleAlias, this.library);
        for (Transition transition : Transition.altValues()) {
            SequencingArtifactMetrics.DetailPair detailPair2;
            List list = (List)listMap.get((Object)transition);
            List list2 = (List)listMap3.get((Object)transition);
            if (list2.size() != 1) {
                throw new PicardException("Should have exactly one context-free metric pair for transition: " + (Object)((Object)transition));
            }
            ArrayList<SequencingArtifactMetrics.DetailPair> arrayList = new ArrayList<SequencingArtifactMetrics.DetailPair>();
            ArrayList<SequencingArtifactMetrics.DetailPair> arrayList2 = new ArrayList<SequencingArtifactMetrics.DetailPair>();
            for (SequencingArtifactMetrics.DetailPair detailPair2 : (List)listMap2.get((Object)transition)) {
                if (!detailPair2.preAdapterMetrics.CONTEXT.equals(detailPair2.baitBiasMetrics.CONTEXT)) {
                    throw new PicardException("Input detail metrics are not matched up properly - contexts differ.");
                }
                boolean bl = this.leadingContexts.contains(detailPair2.preAdapterMetrics.CONTEXT);
                boolean bl2 = this.trailingContexts.contains(detailPair2.preAdapterMetrics.CONTEXT);
                if (bl) {
                    arrayList.add(detailPair2);
                }
                if (!bl2) continue;
                arrayList2.add(detailPair2);
            }
            SequencingArtifactMetrics.DetailPair detailPair3 = (SequencingArtifactMetrics.DetailPair)list2.get(0);
            detailPair2 = this.getWorstMetrics(list);
            SequencingArtifactMetrics.DetailPair detailPair4 = this.getWorstMetrics(arrayList);
            SequencingArtifactMetrics.DetailPair detailPair5 = this.getWorstMetrics(arrayList2);
            SequencingArtifactMetrics.PreAdapterSummaryMetrics preAdapterSummaryMetrics = new SequencingArtifactMetrics.PreAdapterSummaryMetrics();
            SequencingArtifactMetrics.BaitBiasSummaryMetrics baitBiasSummaryMetrics = new SequencingArtifactMetrics.BaitBiasSummaryMetrics();
            preAdapterSummaryMetrics.SAMPLE_ALIAS = this.sampleAlias;
            preAdapterSummaryMetrics.LIBRARY = this.library;
            preAdapterSummaryMetrics.REF_BASE = transition.ref();
            preAdapterSummaryMetrics.ALT_BASE = transition.call();
            preAdapterSummaryMetrics.TOTAL_QSCORE = detailPair3.preAdapterMetrics.QSCORE;
            preAdapterSummaryMetrics.WORST_CXT = detailPair2.preAdapterMetrics.CONTEXT;
            preAdapterSummaryMetrics.WORST_CXT_QSCORE = detailPair2.preAdapterMetrics.QSCORE;
            preAdapterSummaryMetrics.WORST_PRE_CXT = detailPair4.preAdapterMetrics.CONTEXT;
            preAdapterSummaryMetrics.WORST_PRE_CXT_QSCORE = detailPair4.preAdapterMetrics.QSCORE;
            preAdapterSummaryMetrics.WORST_POST_CXT = detailPair5.preAdapterMetrics.CONTEXT;
            preAdapterSummaryMetrics.WORST_POST_CXT_QSCORE = detailPair5.preAdapterMetrics.QSCORE;
            preAdapterSummaryMetrics.inferArtifactName();
            baitBiasSummaryMetrics.SAMPLE_ALIAS = this.sampleAlias;
            baitBiasSummaryMetrics.LIBRARY = this.library;
            baitBiasSummaryMetrics.REF_BASE = transition.ref();
            baitBiasSummaryMetrics.ALT_BASE = transition.call();
            baitBiasSummaryMetrics.TOTAL_QSCORE = detailPair3.baitBiasMetrics.QSCORE;
            baitBiasSummaryMetrics.WORST_CXT = detailPair2.baitBiasMetrics.CONTEXT;
            baitBiasSummaryMetrics.WORST_CXT_QSCORE = detailPair2.baitBiasMetrics.QSCORE;
            baitBiasSummaryMetrics.WORST_PRE_CXT = detailPair4.baitBiasMetrics.CONTEXT;
            baitBiasSummaryMetrics.WORST_PRE_CXT_QSCORE = detailPair4.baitBiasMetrics.QSCORE;
            baitBiasSummaryMetrics.WORST_POST_CXT = detailPair5.baitBiasMetrics.CONTEXT;
            baitBiasSummaryMetrics.WORST_POST_CXT_QSCORE = detailPair5.baitBiasMetrics.QSCORE;
            baitBiasSummaryMetrics.inferArtifactName();
            hashMap.put(transition, new SequencingArtifactMetrics.SummaryPair(preAdapterSummaryMetrics, baitBiasSummaryMetrics));
        }
        return hashMap;
    }

    private ListMap<Transition, SequencingArtifactMetrics.DetailPair> getDetailMetrics() {
        return this.fullContextAccumulator.calculateMetrics(this.sampleAlias, this.library);
    }

    private SequencingArtifactMetrics.DetailPair getWorstMetrics(List<SequencingArtifactMetrics.DetailPair> list) {
        SequencingArtifactMetrics.PreAdapterDetailMetrics preAdapterDetailMetrics = null;
        SequencingArtifactMetrics.BaitBiasDetailMetrics baitBiasDetailMetrics = null;
        for (SequencingArtifactMetrics.DetailPair detailPair : list) {
            if (preAdapterDetailMetrics == null || detailPair.preAdapterMetrics.compareTo(preAdapterDetailMetrics) < 0) {
                preAdapterDetailMetrics = detailPair.preAdapterMetrics;
            }
            if (baitBiasDetailMetrics != null && detailPair.baitBiasMetrics.compareTo(baitBiasDetailMetrics) >= 0) continue;
            baitBiasDetailMetrics = detailPair.baitBiasMetrics;
        }
        return new SequencingArtifactMetrics.DetailPair(preAdapterDetailMetrics, baitBiasDetailMetrics);
    }

    protected final class RefContext {
        final String ref;
        final String leading;
        final String trailing;
        final String zero;

        public RefContext(String string, String string2, String string3, String string4) {
            this.ref = string;
            this.leading = string2;
            this.trailing = string3;
            this.zero = string4;
        }
    }
}

