/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.artifacts;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.filter.AggregateFilter;
import htsjdk.samtools.filter.AlignedFilter;
import htsjdk.samtools.filter.DuplicateReadFilter;
import htsjdk.samtools.filter.FailsVendorReadQualityFilter;
import htsjdk.samtools.filter.InsertSizeFilter;
import htsjdk.samtools.filter.MappingQualityFilter;
import htsjdk.samtools.filter.NotPrimaryAlignmentFilter;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.CodeUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.IntervalListReferenceSequenceMask;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.PicardException;
import picard.analysis.SinglePassSamProgram;
import picard.analysis.artifacts.ArtifactCounter;
import picard.analysis.artifacts.SequencingArtifactMetrics;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.util.DbSnpBitSetUtil;

@CommandLineProgramProperties(usage="Collect metrics to quantify single-base sequencing artifacts.This tool examines two sources of sequencing errors resulting from hybrid selection protocols: <a href='https://www.broadinstitute.org/gatk/guide/article?id=6333'>bait-bias</a> and <a href='https://www.broadinstitute.org/gatk/guide/article?id=6332'>pre-adapter artifacts</a>. For a brief primer on these types of artifacts, see the corresponding GATK Dictionary entries.<br /><br />This tool produces four files; summary and detail metrics files for both pre-adapter and bait-bias artifacts. The detailed metrics show the error rates for each type of base substitution within every possible triplet base configuration.  Error rates associated with these substitutions are Phred-scaled and provided as quality scores, the lower the value, the more likely it is that an alternate base call is due to an artifact. The summary metrics provide likelihood information on the \"worst-case\" errors. <br /><h4>Usage example:</h4><pre>java -jar picard.jar CollectSequencingArtifactMetrics \\<br />     I=input.bam \\<br />     O=artifact_metrics.txt \\<br />     R=reference_sequence.fasta</pre>For additional information, please see <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#SequencingArtifactMetrics.PreAdapterDetailMetrics'>the PreAdapterDetailMetrics documentation</a>, the <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#SequencingArtifactMetrics.PreAdapterSummaryMetrics'>the PreAdapterSummaryMetrics documentation</a>, the <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#SequencingArtifactMetrics.BaitBiasDetailMetrics'>the BaitBiasDetailMetrics documentation</a>, and the <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#SequencingArtifactMetrics.BaitBiasSummaryMetrics'>the BaitBiasSummaryMetrics documentation</a>. <hr />", usageShort="Collect metrics to quantify single-base sequencing artifacts.", programGroup=Metrics.class)
public class CollectSequencingArtifactMetrics
extends SinglePassSamProgram {
    static final String USAGE_SUMMARY = "Collect metrics to quantify single-base sequencing artifacts.";
    static final String USAGE_DETAILS = "This tool examines two sources of sequencing errors resulting from hybrid selection protocols: <a href='https://www.broadinstitute.org/gatk/guide/article?id=6333'>bait-bias</a> and <a href='https://www.broadinstitute.org/gatk/guide/article?id=6332'>pre-adapter artifacts</a>. For a brief primer on these types of artifacts, see the corresponding GATK Dictionary entries.<br /><br />This tool produces four files; summary and detail metrics files for both pre-adapter and bait-bias artifacts. The detailed metrics show the error rates for each type of base substitution within every possible triplet base configuration.  Error rates associated with these substitutions are Phred-scaled and provided as quality scores, the lower the value, the more likely it is that an alternate base call is due to an artifact. The summary metrics provide likelihood information on the \"worst-case\" errors. <br /><h4>Usage example:</h4><pre>java -jar picard.jar CollectSequencingArtifactMetrics \\<br />     I=input.bam \\<br />     O=artifact_metrics.txt \\<br />     R=reference_sequence.fasta</pre>For additional information, please see <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#SequencingArtifactMetrics.PreAdapterDetailMetrics'>the PreAdapterDetailMetrics documentation</a>, the <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#SequencingArtifactMetrics.PreAdapterSummaryMetrics'>the PreAdapterSummaryMetrics documentation</a>, the <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#SequencingArtifactMetrics.BaitBiasDetailMetrics'>the BaitBiasDetailMetrics documentation</a>, and the <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#SequencingArtifactMetrics.BaitBiasSummaryMetrics'>the BaitBiasSummaryMetrics documentation</a>. <hr />";
    @Option(doc="An optional list of intervals to restrict analysis to.", optional=true)
    public File INTERVALS;
    @Option(doc="VCF format dbSNP file, used to exclude regions around known polymorphisms from analysis.", optional=true)
    public File DB_SNP;
    @Option(shortName="Q", doc="The minimum base quality score for a base to be included in analysis.")
    public int MINIMUM_QUALITY_SCORE = 20;
    @Option(shortName="MQ", doc="The minimum mapping quality score for a base to be included in analysis.")
    public int MINIMUM_MAPPING_QUALITY = 30;
    @Option(shortName="MIN_INS", doc="The minimum insert size for a read to be included in analysis.")
    public int MINIMUM_INSERT_SIZE = 60;
    @Option(shortName="MAX_INS", doc="The maximum insert size for a read to be included in analysis. Set to 0 to have no maximum.")
    public int MAXIMUM_INSERT_SIZE = 600;
    @Option(shortName="UNPAIRED", doc="Include unpaired reads. If set to true then all paired reads will be included as well - MINIMUM_INSERT_SIZE and MAXIMUM_INSERT_SIZE will be ignored.")
    public boolean INCLUDE_UNPAIRED = false;
    @Option(shortName="TANDEM", doc="Set to true if mate pairs are being sequenced from the same strand, i.e. they're expected to face the same direction.")
    public boolean TANDEM_READS = false;
    @Option(doc="When available, use original quality scores for filtering.")
    public boolean USE_OQ = true;
    @Option(doc="The number of context bases to include on each side of the assayed base.")
    public int CONTEXT_SIZE = 1;
    @Option(doc="If specified, only print results for these contexts in the detail metrics output. However, the summary metrics output will still take all contexts into consideration.")
    public Set<String> CONTEXTS_TO_PRINT = new HashSet<String>();
    @Option(shortName="EXT", doc="Append the given file extension to all metric file names (ex. OUTPUT.pre_adapter_summary_metrics.EXT). None if null", optional=true)
    public String FILE_EXTENSION = null;
    private static final String UNKNOWN_LIBRARY = "UnknownLibrary";
    private static final String UNKNOWN_SAMPLE = "UnknownSample";
    private File preAdapterSummaryOut;
    private File preAdapterDetailsOut;
    private File baitBiasSummaryOut;
    private File baitBiasDetailsOut;
    private IntervalListReferenceSequenceMask intervalMask;
    private DbSnpBitSetUtil dbSnpMask;
    private SamRecordFilter recordFilter;
    private String currentRefString = null;
    private int currentRefIndex = -1;
    private final Set<String> samples = new HashSet<String>();
    private final Set<String> libraries = new HashSet<String>();
    private final Map<String, ArtifactCounter> artifactCounters = new HashMap<String, ArtifactCounter>();

    public static void main(String[] stringArray) {
        new CollectSequencingArtifactMetrics().instanceMainWithExit(stringArray);
    }

    @Override
    protected String[] customCommandLineValidation() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 2 * this.CONTEXT_SIZE + 1;
        if (this.CONTEXT_SIZE < 0) {
            arrayList.add("CONTEXT_SIZE cannot be negative");
        }
        for (String string : this.CONTEXTS_TO_PRINT) {
            if (string.length() == n) continue;
            arrayList.add("Context " + string + " is not the length implied by CONTEXT_SIZE: " + n);
        }
        if (this.MINIMUM_INSERT_SIZE < 0) {
            arrayList.add("MINIMUM_INSERT_SIZE cannot be negative");
        }
        if (this.MAXIMUM_INSERT_SIZE < 0) {
            arrayList.add("MAXIMUM_INSERT_SIZE cannot be negative");
        }
        if (this.MAXIMUM_INSERT_SIZE > 0 && this.MAXIMUM_INSERT_SIZE < this.MINIMUM_INSERT_SIZE) {
            arrayList.add("MAXIMUM_INSERT_SIZE cannot be less than MINIMUM_INSERT_SIZE unless set to 0");
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    protected void setup(SAMFileHeader sAMFileHeader, File file) {
        String string = null != this.FILE_EXTENSION ? this.FILE_EXTENSION : "";
        this.preAdapterSummaryOut = new File(this.OUTPUT + ".pre_adapter_summary_metrics" + string);
        this.preAdapterDetailsOut = new File(this.OUTPUT + ".pre_adapter_detail_metrics" + string);
        this.baitBiasSummaryOut = new File(this.OUTPUT + ".bait_bias_summary_metrics" + string);
        this.baitBiasDetailsOut = new File(this.OUTPUT + ".bait_bias_detail_metrics" + string);
        IOUtil.assertFileIsWritable((File)this.preAdapterSummaryOut);
        IOUtil.assertFileIsWritable((File)this.preAdapterDetailsOut);
        IOUtil.assertFileIsWritable((File)this.baitBiasSummaryOut);
        IOUtil.assertFileIsWritable((File)this.baitBiasDetailsOut);
        for (SAMReadGroupRecord sAMReadGroupRecord : sAMFileHeader.getReadGroups()) {
            this.samples.add((String)CodeUtil.getOrElse((Object)sAMReadGroupRecord.getSample(), (Object)UNKNOWN_SAMPLE));
            this.libraries.add((String)CodeUtil.getOrElse((Object)sAMReadGroupRecord.getLibrary(), (Object)UNKNOWN_LIBRARY));
        }
        if (this.INTERVALS != null) {
            IOUtil.assertFileIsReadable((File)this.INTERVALS);
            this.intervalMask = new IntervalListReferenceSequenceMask(IntervalList.fromFile((File)this.INTERVALS).uniqued());
        }
        if (this.DB_SNP != null) {
            IOUtil.assertFileIsReadable((File)this.DB_SNP);
            this.dbSnpMask = new DbSnpBitSetUtil(this.DB_SNP, sAMFileHeader.getSequenceDictionary());
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(new FailsVendorReadQualityFilter());
        arrayList.add(new NotPrimaryAlignmentFilter());
        arrayList.add(new DuplicateReadFilter());
        arrayList.add(new AlignedFilter(true));
        arrayList.add(new MappingQualityFilter(this.MINIMUM_MAPPING_QUALITY));
        if (!this.INCLUDE_UNPAIRED) {
            int n = this.MAXIMUM_INSERT_SIZE == 0 ? Integer.MAX_VALUE : this.MAXIMUM_INSERT_SIZE;
            arrayList.add(new InsertSizeFilter(this.MINIMUM_INSERT_SIZE, n));
        }
        this.recordFilter = new AggregateFilter((List)arrayList);
        String string2 = StringUtil.join((String)",", new ArrayList<String>(this.samples));
        for (String string3 : this.libraries) {
            this.artifactCounters.put(string3, new ArtifactCounter(string2, string3, this.CONTEXT_SIZE, this.TANDEM_READS));
        }
    }

    @Override
    protected void acceptRead(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
        Object object;
        String string;
        if (this.recordFilter.filterOut(sAMRecord)) {
            return;
        }
        String string2 = string = sAMRecord.getReadGroup() == null ? UNKNOWN_LIBRARY : (String)CodeUtil.getOrElse((Object)sAMRecord.getReadGroup().getLibrary(), (Object)UNKNOWN_LIBRARY);
        if (!this.libraries.contains(string)) {
            throw new PicardException("Record contains library that is missing from header: " + string);
        }
        int n = 2 * this.CONTEXT_SIZE + 1;
        ArtifactCounter artifactCounter = this.artifactCounters.get(string);
        byte[] byArray = sAMRecord.getReadBases();
        Object object2 = this.USE_OQ ? (Object)((object = sAMRecord.getOriginalBaseQualities()) == null ? sAMRecord.getBaseQualities() : object) : sAMRecord.getBaseQualities();
        object = sAMRecord.getAlignmentBlocks().iterator();
        while (object.hasNext()) {
            AlignmentBlock alignmentBlock = (AlignmentBlock)object.next();
            for (int i = 0; i < alignmentBlock.getLength(); ++i) {
                String string3;
                int n2;
                char c;
                int n3 = alignmentBlock.getReadStart() + i;
                int n4 = alignmentBlock.getReferenceStart() + i;
                byte by = object2[n3 - 1];
                if (by < this.MINIMUM_QUALITY_SCORE || (c = Character.toUpperCase((char)byArray[n3 - 1])) == 'N' || this.intervalMask != null && !this.intervalMask.get(referenceSequence.getContigIndex(), n4) || this.dbSnpMask != null && this.dbSnpMask.isDbSnpSite(referenceSequence.getName(), n4) || (n2 = n4 - this.CONTEXT_SIZE - 1) < 0 || n2 + n > referenceSequence.length() || (string3 = this.getRefContext(referenceSequence, n2, n)).contains("N")) continue;
                artifactCounter.countRecord(string3, c, sAMRecord);
            }
        }
    }

    private String getRefContext(ReferenceSequence referenceSequence, int n, int n2) {
        if (this.currentRefIndex != referenceSequence.getContigIndex()) {
            this.currentRefString = new String(referenceSequence.getBases()).toUpperCase();
            this.currentRefIndex = referenceSequence.getContigIndex();
        }
        return this.currentRefString.substring(n, n + n2);
    }

    @Override
    protected void finish() {
        MetricsFile metricsFile = this.getMetricsFile();
        MetricsFile metricsFile2 = this.getMetricsFile();
        MetricsFile metricsFile3 = this.getMetricsFile();
        MetricsFile metricsFile4 = this.getMetricsFile();
        for (ArtifactCounter artifactCounter : this.artifactCounters.values()) {
            artifactCounter.finish();
            metricsFile.addAllMetrics(artifactCounter.getPreAdapterSummaryMetrics());
            metricsFile3.addAllMetrics(artifactCounter.getBaitBiasSummaryMetrics());
            for (SequencingArtifactMetrics.PreAdapterDetailMetrics preAdapterDetailMetrics : artifactCounter.getPreAdapterDetailMetrics()) {
                if (!this.CONTEXTS_TO_PRINT.isEmpty() && !this.CONTEXTS_TO_PRINT.contains(preAdapterDetailMetrics.CONTEXT)) continue;
                metricsFile2.addMetric((MetricBase)preAdapterDetailMetrics);
            }
            for (SequencingArtifactMetrics.BaitBiasDetailMetrics baitBiasDetailMetrics : artifactCounter.getBaitBiasDetailMetrics()) {
                if (!this.CONTEXTS_TO_PRINT.isEmpty() && !this.CONTEXTS_TO_PRINT.contains(baitBiasDetailMetrics.CONTEXT)) continue;
                metricsFile4.addMetric((MetricBase)baitBiasDetailMetrics);
            }
        }
        metricsFile2.write(this.preAdapterDetailsOut);
        metricsFile.write(this.preAdapterSummaryOut);
        metricsFile4.write(this.baitBiasDetailsOut);
        metricsFile3.write(this.baitBiasSummaryOut);
    }

    @Override
    protected boolean usesNoRefReads() {
        return false;
    }
}

