/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.artifacts;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.util.QualityUtil;

public class SequencingArtifactMetrics {
    public static final String PRE_ADAPTER_SUMMARY_EXT = ".pre_adapter_summary_metrics";
    public static final String PRE_ADAPTER_DETAILS_EXT = ".pre_adapter_detail_metrics";
    public static final String BAIT_BIAS_SUMMARY_EXT = ".bait_bias_summary_metrics";
    public static final String BAIT_BIAS_DETAILS_EXT = ".bait_bias_detail_metrics";
    private static final double MIN_ERROR = 1.0E-10;

    static class SummaryPair {
        final PreAdapterSummaryMetrics preAdapterMetrics;
        final BaitBiasSummaryMetrics baitBiasMetrics;

        SummaryPair(PreAdapterSummaryMetrics preAdapterSummaryMetrics, BaitBiasSummaryMetrics baitBiasSummaryMetrics) {
            this.preAdapterMetrics = preAdapterSummaryMetrics;
            this.baitBiasMetrics = baitBiasSummaryMetrics;
        }
    }

    static class DetailPair {
        final PreAdapterDetailMetrics preAdapterMetrics;
        final BaitBiasDetailMetrics baitBiasMetrics;

        DetailPair(PreAdapterDetailMetrics preAdapterDetailMetrics, BaitBiasDetailMetrics baitBiasDetailMetrics) {
            this.preAdapterMetrics = preAdapterDetailMetrics;
            this.baitBiasMetrics = baitBiasDetailMetrics;
        }
    }

    public static class BaitBiasDetailMetrics
    extends MetricBase {
        public String SAMPLE_ALIAS;
        public String LIBRARY;
        public char REF_BASE;
        public char ALT_BASE;
        public String CONTEXT;
        public long FWD_CXT_REF_BASES;
        public long FWD_CXT_ALT_BASES;
        public long REV_CXT_REF_BASES;
        public long REV_CXT_ALT_BASES;
        public double FWD_ERROR_RATE;
        public double REV_ERROR_RATE;
        public double ERROR_RATE;
        public double QSCORE;

        public void calculateDerivedStatistics() {
            this.FWD_ERROR_RATE = 1.0E-10;
            long l = this.FWD_CXT_REF_BASES + this.FWD_CXT_ALT_BASES;
            if (l > 0L) {
                double d = (double)this.FWD_CXT_ALT_BASES / (double)l;
                this.FWD_ERROR_RATE = Math.max(1.0E-10, d);
            }
            this.REV_ERROR_RATE = 1.0E-10;
            long l2 = this.REV_CXT_REF_BASES + this.REV_CXT_ALT_BASES;
            if (l2 > 0L) {
                double d = (double)this.REV_CXT_ALT_BASES / (double)l2;
                this.REV_ERROR_RATE = Math.max(1.0E-10, d);
            }
            this.ERROR_RATE = Math.max(1.0E-10, this.FWD_ERROR_RATE - this.REV_ERROR_RATE);
            this.QSCORE = QualityUtil.getPhredScoreFromErrorProbability((double)this.ERROR_RATE);
        }

        public int compareTo(BaitBiasDetailMetrics baitBiasDetailMetrics) {
            int n = Double.compare(this.QSCORE, baitBiasDetailMetrics.QSCORE);
            if (n != 0) {
                return n;
            }
            n = this.REF_BASE - baitBiasDetailMetrics.REF_BASE;
            if (n != 0) {
                return n;
            }
            n = this.ALT_BASE - baitBiasDetailMetrics.ALT_BASE;
            if (n != 0) {
                return n;
            }
            n = this.CONTEXT.compareTo(baitBiasDetailMetrics.CONTEXT);
            return n;
        }
    }

    public static class PreAdapterDetailMetrics
    extends MetricBase {
        public String SAMPLE_ALIAS;
        public String LIBRARY;
        public char REF_BASE;
        public char ALT_BASE;
        public String CONTEXT;
        public long PRO_REF_BASES;
        public long PRO_ALT_BASES;
        public long CON_REF_BASES;
        public long CON_ALT_BASES;
        public double ERROR_RATE;
        public double QSCORE;

        public void calculateDerivedStatistics() {
            this.ERROR_RATE = 1.0E-10;
            long l = this.PRO_REF_BASES + this.PRO_ALT_BASES + this.CON_REF_BASES + this.CON_ALT_BASES;
            if (l > 0L) {
                double d = (double)(this.PRO_ALT_BASES - this.CON_ALT_BASES) / (double)l;
                this.ERROR_RATE = Math.max(1.0E-10, d);
            }
            this.QSCORE = QualityUtil.getPhredScoreFromErrorProbability((double)this.ERROR_RATE);
        }

        public int compareTo(PreAdapterDetailMetrics preAdapterDetailMetrics) {
            int n = Double.compare(this.QSCORE, preAdapterDetailMetrics.QSCORE);
            if (n != 0) {
                return n;
            }
            n = this.REF_BASE - preAdapterDetailMetrics.REF_BASE;
            if (n != 0) {
                return n;
            }
            n = this.ALT_BASE - preAdapterDetailMetrics.ALT_BASE;
            if (n != 0) {
                return n;
            }
            n = this.CONTEXT.compareTo(preAdapterDetailMetrics.CONTEXT);
            return n;
        }
    }

    public static class BaitBiasSummaryMetrics
    extends MetricBase {
        public String SAMPLE_ALIAS;
        public String LIBRARY;
        public char REF_BASE;
        public char ALT_BASE;
        public double TOTAL_QSCORE;
        public String WORST_CXT;
        public double WORST_CXT_QSCORE;
        public String WORST_PRE_CXT;
        public double WORST_PRE_CXT_QSCORE;
        public String WORST_POST_CXT;
        public double WORST_POST_CXT_QSCORE;
        public String ARTIFACT_NAME;

        public void inferArtifactName() {
            this.ARTIFACT_NAME = this.REF_BASE == 'G' && this.ALT_BASE == 'T' ? "Gref" : (this.REF_BASE == 'C' && this.ALT_BASE == 'A' ? "Cref" : "NA");
        }
    }

    public static class PreAdapterSummaryMetrics
    extends MetricBase {
        public String SAMPLE_ALIAS;
        public String LIBRARY;
        public char REF_BASE;
        public char ALT_BASE;
        public double TOTAL_QSCORE;
        public String WORST_CXT;
        public double WORST_CXT_QSCORE;
        public String WORST_PRE_CXT;
        public double WORST_PRE_CXT_QSCORE;
        public String WORST_POST_CXT;
        public double WORST_POST_CXT_QSCORE;
        public String ARTIFACT_NAME;

        public void inferArtifactName() {
            this.ARTIFACT_NAME = this.REF_BASE == 'G' && this.ALT_BASE == 'T' ? "OxoG" : (this.REF_BASE == 'C' && this.ALT_BASE == 'T' ? "Deamination" : "NA");
        }
    }
}

