/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.artifacts;

import htsjdk.samtools.util.SequenceUtil;
import java.util.Arrays;

enum Transition {
    AtoA('A', 'A'),
    AtoC('A', 'C'),
    AtoG('A', 'G'),
    AtoT('A', 'T'),
    CtoA('C', 'A'),
    CtoC('C', 'C'),
    CtoG('C', 'G'),
    CtoT('C', 'T'),
    GtoA('G', 'A'),
    GtoC('G', 'C'),
    GtoG('G', 'G'),
    GtoT('G', 'T'),
    TtoA('T', 'A'),
    TtoC('T', 'C'),
    TtoG('T', 'G'),
    TtoT('T', 'T');

    private static final Transition[] ALT_VALUES;
    private final char ref;
    private final char call;
    protected static final int[] baseIndexMap;
    private static final Transition[][] transitionIndexMap;

    private Transition(char c, char c2) {
        this.ref = c;
        this.call = c2;
    }

    public static Transition transitionOf(char c, char c2) {
        return transitionIndexMap[baseIndexMap[c]][baseIndexMap[c2]];
    }

    public static Transition[] altValues() {
        return ALT_VALUES;
    }

    public Transition complement() {
        return Transition.transitionOf((char)SequenceUtil.complement((byte)((byte)this.ref)), (char)SequenceUtil.complement((byte)((byte)this.call)));
    }

    public char ref() {
        return this.ref;
    }

    public char call() {
        return this.call;
    }

    public String toString() {
        return this.ref + ">" + this.call;
    }

    static {
        ALT_VALUES = new Transition[]{AtoC, AtoG, AtoT, CtoA, CtoG, CtoT, GtoA, GtoC, GtoT, TtoA, TtoC, TtoG};
        baseIndexMap = new int[256];
        Arrays.fill(baseIndexMap, -1);
        for (Base base : Base.values()) {
            Transition.baseIndexMap[base.base] = base.ordinal();
        }
        transitionIndexMap = new Transition[Base.values().length][Base.values().length];
        for (Base base : Base.values()) {
            for (Base base2 : Base.values()) {
                Transition.transitionIndexMap[base.ordinal()][base2.ordinal()] = Transition.valueOf(base.toString() + "to" + base2.toString());
            }
        }
    }

    protected static enum Base {
        A('A'),
        C('C'),
        G('G'),
        T('T');

        public byte base;

        private Base(char c) {
            this.base = (byte)c;
        }
    }
}

