/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.directed;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.directed.CalculateHsMetrics;
import picard.analysis.directed.CollectTargetedMetrics;
import picard.analysis.directed.HsMetricCollector;
import picard.analysis.directed.HsMetrics;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;

@CommandLineProgramProperties(usage="<b>Collects hybrid-selection (HS) metrics for a SAM or BAM file.</b>  This tool takes a SAM/BAM file input and collects metrics that are specific for sequence datasets generated through hybrid-selection. Hybrid-selection (HS) is the most commonly used technique to capture exon-specific sequences for targeted sequencing experiments such as exome sequencing; for more information, please see the corresponding <a href='http://www.broadinstitute.org/gatk/guide/article?id=6331'>GATK Dictionary entry</a>. </p> <p>This tool requires an aligned SAM or BAM file as well as bait and target interval files in Picard interval_list format. You should use the bait and interval files that correspond to the capture kit that was used to generate the capture libraries for sequencing, which can generally be obtained from the manufacturer of the kit. If the baits and target intervals are provided in BED format, you can convert them to the Picard interval_list format using Picard's <a href='http://broadinstitute.github.io/picard/command-line-overview.html#BedToIntervalList'>BedToInterval</a> tool. </p><p>If a reference sequence is provided, this program will calculate both AT_DROPOUT and GC_DROPOUT metrics. Dropout metrics are an attempt to measure the reduced representation of reads, in regions that deviate from 50% G/C content. This reduction in the number of aligned reads is due to the increased numbers of errors associated with sequencing regions with excessive or deficient numbers of G/C bases, ultimately leading to poor mapping efficiencies and lowcoverage in the affected regions. </p><p>If you are interested in getting G/C content and mean sequence depth information for every target interval, use the PER_TARGET_COVERAGE option. </p><p>Note that coverage measurements are capped at ~32K to constrain memory usage.</p><h4>Usage Example:</h4><pre>java -jar picard.jar CollectHsMetrics \\<br />      I=input.bam \\<br />      O=hs_metrics.txt \\<br />      R=reference_sequence.fasta \\<br />      BAIT_INTERVALS=bait.interval_list \\<br />      TARGET_INTERVALS=target.interval_list</pre> <p>Please see the CollectHsMetrics <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#HsMetrics'>definitions</a> for a complete description of the metrics produced by this tool.</p> <hr />", usageShort="<b>Collects hybrid-selection (HS) metrics for a SAM or BAM file.</b>  ", programGroup=Metrics.class)
public class CollectHsMetrics
extends CollectTargetedMetrics<HsMetrics, HsMetricCollector> {
    static final String USAGE_SUMMARY = "<b>Collects hybrid-selection (HS) metrics for a SAM or BAM file.</b>  ";
    static final String USAGE_DETAILS = "This tool takes a SAM/BAM file input and collects metrics that are specific for sequence datasets generated through hybrid-selection. Hybrid-selection (HS) is the most commonly used technique to capture exon-specific sequences for targeted sequencing experiments such as exome sequencing; for more information, please see the corresponding <a href='http://www.broadinstitute.org/gatk/guide/article?id=6331'>GATK Dictionary entry</a>. </p> <p>This tool requires an aligned SAM or BAM file as well as bait and target interval files in Picard interval_list format. You should use the bait and interval files that correspond to the capture kit that was used to generate the capture libraries for sequencing, which can generally be obtained from the manufacturer of the kit. If the baits and target intervals are provided in BED format, you can convert them to the Picard interval_list format using Picard's <a href='http://broadinstitute.github.io/picard/command-line-overview.html#BedToIntervalList'>BedToInterval</a> tool. </p><p>If a reference sequence is provided, this program will calculate both AT_DROPOUT and GC_DROPOUT metrics. Dropout metrics are an attempt to measure the reduced representation of reads, in regions that deviate from 50% G/C content. This reduction in the number of aligned reads is due to the increased numbers of errors associated with sequencing regions with excessive or deficient numbers of G/C bases, ultimately leading to poor mapping efficiencies and lowcoverage in the affected regions. </p><p>If you are interested in getting G/C content and mean sequence depth information for every target interval, use the PER_TARGET_COVERAGE option. </p><p>Note that coverage measurements are capped at ~32K to constrain memory usage.</p><h4>Usage Example:</h4><pre>java -jar picard.jar CollectHsMetrics \\<br />      I=input.bam \\<br />      O=hs_metrics.txt \\<br />      R=reference_sequence.fasta \\<br />      BAIT_INTERVALS=bait.interval_list \\<br />      TARGET_INTERVALS=target.interval_list</pre> <p>Please see the CollectHsMetrics <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#HsMetrics'>definitions</a> for a complete description of the metrics produced by this tool.</p> <hr />";
    @Option(shortName="BI", doc="An interval list file that contains the locations of the baits used.", minElements=1)
    public List<File> BAIT_INTERVALS;
    @Option(shortName="N", doc="Bait set name. If not provided it is inferred from the filename of the bait intervals.", optional=true)
    public String BAIT_SET_NAME;
    @Option(shortName="MQ", doc="Minimum mapping quality for a read to contribute coverage.", overridable=true)
    public int MINIMUM_MAPPING_QUALITY = 20;
    @Option(shortName="Q", doc="Minimum base quality for a base to contribute coverage.", overridable=true)
    public int MINIMUM_BASE_QUALITY = 20;
    @Option(doc="True if we are to clip overlapping reads, false otherwise.", optional=true, overridable=true)
    public boolean CLIP_OVERLAPPING_READS = true;

    @Override
    protected IntervalList getProbeIntervals() {
        for (File file : this.BAIT_INTERVALS) {
            IOUtil.assertFileIsReadable((File)file);
        }
        return IntervalList.fromFiles(this.BAIT_INTERVALS);
    }

    @Override
    protected String getProbeSetName() {
        if (this.BAIT_SET_NAME != null) {
            return this.BAIT_SET_NAME;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (File file : this.BAIT_INTERVALS) {
            treeSet.add(CollectTargetedMetrics.renderProbeNameFromFile(file));
        }
        return StringUtil.join((String)".", treeSet);
    }

    public static void main(String[] stringArray) {
        System.exit(new CalculateHsMetrics().instanceMain(stringArray));
    }

    @Override
    protected HsMetricCollector makeCollector(Set<MetricAccumulationLevel> set, List<SAMReadGroupRecord> list, ReferenceSequenceFile referenceSequenceFile, File file, File file2, IntervalList intervalList, IntervalList intervalList2, String string, int n) {
        return new HsMetricCollector(set, list, referenceSequenceFile, file, file2, intervalList, intervalList2, string, n, this.MINIMUM_MAPPING_QUALITY, this.MINIMUM_BASE_QUALITY, this.CLIP_OVERLAPPING_READS, true, this.COVERAGE_CAP, this.SAMPLE_SIZE);
    }
}

