/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.directed;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.samtools.util.SequenceUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.PicardException;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.RnaSeqMetrics;
import picard.annotation.Gene;
import picard.annotation.LocusFunction;
import picard.metrics.PerUnitMetricCollector;
import picard.metrics.SAMRecordMultiLevelCollector;
import picard.util.MathUtil;

public class RnaSeqMetricsCollector
extends SAMRecordMultiLevelCollector<RnaSeqMetrics, Integer> {
    private final int minimumLength;
    private final StrandSpecificity strandSpecificity;
    private final double rrnaFragmentPercentage;
    private final Long ribosomalInitialValue;
    private final Set<Integer> ignoredSequenceIndices;
    private final OverlapDetector<Gene> geneOverlapDetector;
    private final OverlapDetector<Interval> ribosomalSequenceOverlapDetector;
    private final boolean collectCoverageStatistics;

    public RnaSeqMetricsCollector(Set<MetricAccumulationLevel> set, List<SAMReadGroupRecord> list, Long l, OverlapDetector<Gene> overlapDetector, OverlapDetector<Interval> overlapDetector2, HashSet<Integer> hashSet, int n, StrandSpecificity strandSpecificity, double d, boolean bl) {
        this.ribosomalInitialValue = l;
        this.ignoredSequenceIndices = hashSet;
        this.geneOverlapDetector = overlapDetector;
        this.ribosomalSequenceOverlapDetector = overlapDetector2;
        this.minimumLength = n;
        this.strandSpecificity = strandSpecificity;
        this.rrnaFragmentPercentage = d;
        this.collectCoverageStatistics = bl;
        this.setup(set, list);
    }

    @Override
    protected PerUnitMetricCollector<RnaSeqMetrics, Integer, SAMRecord> makeChildCollector(String string, String string2, String string3) {
        return new PerUnitRnaSeqMetricsCollector(string, string2, string3, this.ribosomalInitialValue);
    }

    public static OverlapDetector<Interval> makeOverlapDetector(File file, SAMFileHeader sAMFileHeader, File file2) {
        OverlapDetector overlapDetector = new OverlapDetector(0, 0);
        if (file2 != null) {
            IntervalList intervalList = IntervalList.fromFile((File)file2);
            try {
                SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)sAMFileHeader.getSequenceDictionary(), (SAMSequenceDictionary)intervalList.getHeader().getSequenceDictionary());
            }
            catch (SequenceUtil.SequenceListsDifferException sequenceListsDifferException) {
                throw new PicardException("Sequence dictionaries differ in " + file.getAbsolutePath() + " and " + file2.getAbsolutePath(), sequenceListsDifferException);
            }
            IntervalList intervalList2 = intervalList.uniqued();
            List list = intervalList2.getIntervals();
            overlapDetector.addAll(list, list);
        }
        return overlapDetector;
    }

    public static HashSet<Integer> makeIgnoredSequenceIndicesSet(SAMFileHeader sAMFileHeader, Set<String> set) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (String string : set) {
            SAMSequenceRecord sAMSequenceRecord = sAMFileHeader.getSequence(string);
            if (sAMSequenceRecord == null) {
                throw new PicardException("Unrecognized sequence " + string + " passed as argument to IGNORE_SEQUENCE");
            }
            hashSet.add(sAMSequenceRecord.getSequenceIndex());
        }
        return hashSet;
    }

    private class PerUnitRnaSeqMetricsCollector
    implements PerUnitMetricCollector<RnaSeqMetrics, Integer, SAMRecord> {
        final RnaSeqMetrics metrics = new RnaSeqMetrics();
        private final Map<Gene.Transcript, int[]> coverageByTranscript = new HashMap<Gene.Transcript, int[]>();

        public PerUnitRnaSeqMetricsCollector(String string, String string2, String string3, Long l) {
            this.metrics.SAMPLE = string;
            this.metrics.LIBRARY = string2;
            this.metrics.READ_GROUP = string3;
            this.metrics.RIBOSOMAL_BASES = l;
        }

        @Override
        public void acceptRecord(SAMRecord sAMRecord) {
            int n;
            Interval interval;
            if (sAMRecord.getReadFailsVendorQualityCheckFlag()) {
                return;
            }
            if (!sAMRecord.getNotPrimaryAlignmentFlag()) {
                this.metrics.PF_BASES += (long)sAMRecord.getReadLength();
            }
            if (!sAMRecord.getReadUnmappedFlag() && !sAMRecord.getNotPrimaryAlignmentFlag() && RnaSeqMetricsCollector.this.ignoredSequenceIndices.contains(sAMRecord.getReferenceIndex())) {
                ++this.metrics.IGNORED_READS;
                return;
            }
            if (sAMRecord.getNotPrimaryAlignmentFlag() || sAMRecord.getReadUnmappedFlag()) {
                return;
            }
            Interval interval2 = new Interval(sAMRecord.getReferenceName(), sAMRecord.getAlignmentStart(), sAMRecord.getAlignmentEnd());
            if (!sAMRecord.getReadPairedFlag()) {
                interval = interval2;
            } else if (sAMRecord.getMateUnmappedFlag() || sAMRecord.getReferenceIndex() != sAMRecord.getMateReferenceIndex()) {
                interval = null;
            } else {
                int n2 = Math.min(sAMRecord.getAlignmentStart(), sAMRecord.getMateAlignmentStart());
                n = CoordMath.getEnd((int)n2, (int)Math.abs(sAMRecord.getInferredInsertSize()));
                interval = new Interval(sAMRecord.getReferenceName(), n2, n);
            }
            if (interval != null) {
                Collection collection = RnaSeqMetricsCollector.this.ribosomalSequenceOverlapDetector.getOverlaps(interval);
                n = 0;
                for (Object object : collection) {
                    int n3 = object.getIntersectionLength(interval);
                    n = Math.max(n, n3);
                }
                if ((double)n / (double)interval.length() >= RnaSeqMetricsCollector.this.rrnaFragmentPercentage) {
                    Object object = this.metrics;
                    ((RnaSeqMetrics)((Object)object)).RIBOSOMAL_BASES = ((RnaSeqMetrics)((Object)object)).RIBOSOMAL_BASES + (long)sAMRecord.getReadLength();
                    int n4 = 0;
                    for (AlignmentBlock alignmentBlock : sAMRecord.getAlignmentBlocks()) {
                        n4 += alignmentBlock.getLength();
                    }
                    this.metrics.PF_ALIGNED_BASES += (long)n4;
                    return;
                }
            }
            Collection collection = RnaSeqMetricsCollector.this.geneOverlapDetector.getOverlaps(interval2);
            List list = sAMRecord.getAlignmentBlocks();
            boolean bl = false;
            for (AlignmentBlock alignmentBlock : list) {
                Object object;
                LocusFunction[] locusFunctionArray = new LocusFunction[alignmentBlock.getLength()];
                Arrays.fill((Object[])locusFunctionArray, 0, locusFunctionArray.length, (Object)LocusFunction.INTERGENIC);
                for (Gene gene : collection) {
                    for (Gene.Transcript transcript : gene) {
                        transcript.assignLocusFunctionForRange(alignmentBlock.getReferenceStart(), locusFunctionArray);
                        if (!RnaSeqMetricsCollector.this.collectCoverageStatistics) continue;
                        object = this.coverageByTranscript.get(transcript);
                        if (object == null) {
                            object = new int[transcript.length()];
                            this.coverageByTranscript.put(transcript, (int[])object);
                        }
                        transcript.addCoverageCounts(alignmentBlock.getReferenceStart(), CoordMath.getEnd((int)alignmentBlock.getReferenceStart(), (int)alignmentBlock.getLength()), (int[])object);
                    }
                }
                block12: for (LocusFunction locusFunction : locusFunctionArray) {
                    ++this.metrics.PF_ALIGNED_BASES;
                    switch (locusFunction) {
                        case INTERGENIC: {
                            ++this.metrics.INTERGENIC_BASES;
                            continue block12;
                        }
                        case INTRONIC: {
                            ++this.metrics.INTRONIC_BASES;
                            continue block12;
                        }
                        case UTR: {
                            ++this.metrics.UTR_BASES;
                            bl = true;
                            continue block12;
                        }
                        case CODING: {
                            ++this.metrics.CODING_BASES;
                            bl = true;
                            continue block12;
                        }
                        case RIBOSOMAL: {
                            object = (Object)this.metrics;
                            Long.valueOf(object.RIBOSOMAL_BASES + 1L);
                            object.RIBOSOMAL_BASES = object.RIBOSOMAL_BASES;
                        }
                    }
                }
            }
            if (!sAMRecord.getNotPrimaryAlignmentFlag() && bl && RnaSeqMetricsCollector.this.strandSpecificity != StrandSpecificity.NONE && collection.size() == 1) {
                int n5;
                boolean bl2 = ((Gene)collection.iterator().next()).isNegativeStrand();
                boolean bl3 = sAMRecord.getReadNegativeStrandFlag();
                int n6 = bl3 == bl2 ? 1 : 0;
                int n7 = !sAMRecord.getReadPairedFlag() || sAMRecord.getFirstOfPairFlag() ? 1 : 0;
                int n8 = RnaSeqMetricsCollector.this.strandSpecificity == StrandSpecificity.FIRST_READ_TRANSCRIPTION_STRAND ? 1 : 0;
                int n2 = n5 = n7 == n8 ? 1 : 0;
                if (n6 == n5) {
                    ++this.metrics.CORRECT_STRAND_READS;
                } else {
                    ++this.metrics.INCORRECT_STRAND_READS;
                }
            }
        }

        @Override
        public void finish() {
            if (this.metrics.PF_ALIGNED_BASES > 0L) {
                if (this.metrics.RIBOSOMAL_BASES != null) {
                    this.metrics.PCT_RIBOSOMAL_BASES = (double)this.metrics.RIBOSOMAL_BASES.longValue() / (double)this.metrics.PF_ALIGNED_BASES;
                }
                this.metrics.PCT_CODING_BASES = (double)this.metrics.CODING_BASES / (double)this.metrics.PF_ALIGNED_BASES;
                this.metrics.PCT_UTR_BASES = (double)this.metrics.UTR_BASES / (double)this.metrics.PF_ALIGNED_BASES;
                this.metrics.PCT_INTRONIC_BASES = (double)this.metrics.INTRONIC_BASES / (double)this.metrics.PF_ALIGNED_BASES;
                this.metrics.PCT_INTERGENIC_BASES = (double)this.metrics.INTERGENIC_BASES / (double)this.metrics.PF_ALIGNED_BASES;
                this.metrics.PCT_MRNA_BASES = this.metrics.PCT_CODING_BASES + this.metrics.PCT_UTR_BASES;
                this.metrics.PCT_USABLE_BASES = (double)(this.metrics.CODING_BASES + this.metrics.UTR_BASES) / (double)this.metrics.PF_BASES;
            }
            if (this.metrics.CORRECT_STRAND_READS > 0L || this.metrics.INCORRECT_STRAND_READS > 0L) {
                this.metrics.PCT_CORRECT_STRAND_READS = (double)this.metrics.CORRECT_STRAND_READS / (double)(this.metrics.CORRECT_STRAND_READS + this.metrics.INCORRECT_STRAND_READS);
            }
        }

        @Override
        public void addMetricsToFile(MetricsFile<RnaSeqMetrics, Integer> metricsFile) {
            Histogram<Integer> histogram = this.computeCoverageMetrics();
            metricsFile.addMetric((MetricBase)this.metrics);
            metricsFile.addHistogram(histogram);
        }

        private Histogram<Integer> computeCoverageMetrics() {
            Histogram histogram = new Histogram();
            Histogram histogram2 = new Histogram();
            Histogram histogram3 = new Histogram();
            Histogram histogram4 = new Histogram();
            Histogram histogram5 = new Histogram();
            String string = null;
            string = this.metrics.READ_GROUP != null ? this.metrics.READ_GROUP + "." : (this.metrics.LIBRARY != null ? this.metrics.LIBRARY + "." : (this.metrics.SAMPLE != null ? this.metrics.SAMPLE + "." : "All_Reads."));
            Histogram histogram6 = new Histogram("normalized_position", string + "normalized_coverage");
            Map<Gene.Transcript, int[]> map = this.pickTranscripts(this.coverageByTranscript);
            double d = map.size();
            for (Map.Entry<Gene.Transcript, int[]> entry : map.entrySet()) {
                Gene.Transcript transcript = entry.getKey();
                double[] dArray = MathUtil.promote(entry.getValue());
                double[] dArray2 = transcript.getGene().isPositiveStrand() ? dArray : this.copyAndReverse(dArray);
                double d2 = MathUtil.mean(dArray2, 0, dArray2.length);
                double d3 = MathUtil.stddev(dArray2, 0, dArray2.length, d2);
                double d4 = d3 / d2;
                histogram.increment((Comparable)Double.valueOf(d4));
                double d5 = MathUtil.mean(dArray2, 0, 100);
                double d6 = MathUtil.mean(dArray2, dArray2.length - 100, dArray2.length);
                histogram2.increment((Comparable)Double.valueOf(d5 / d2));
                histogram3.increment((Comparable)Double.valueOf(d6 / d2));
                histogram5.increment((Comparable)Double.valueOf(d5 / d6));
                int n = dArray2.length - 1;
                for (int i = 0; i <= 100; ++i) {
                    double d7 = (double)i / 100.0;
                    int n2 = (int)Math.max(0.0, (double)n * (d7 - 0.005));
                    int n3 = (int)Math.min((double)n, (double)n * (d7 + 0.005));
                    int n4 = n3 - n2 + 1;
                    double d8 = 0.0;
                    for (int j = n2; j <= n3; ++j) {
                        d8 += dArray2[j];
                    }
                    double d9 = d8 / (double)n4 / d2;
                    histogram6.increment((Comparable)Integer.valueOf(i), d9 / d);
                }
            }
            this.metrics.MEDIAN_CV_COVERAGE = histogram.getMedian();
            this.metrics.MEDIAN_5PRIME_BIAS = histogram2.getMedian();
            this.metrics.MEDIAN_3PRIME_BIAS = histogram3.getMedian();
            this.metrics.MEDIAN_5PRIME_TO_3PRIME_BIAS = histogram5.getMedian();
            return histogram6;
        }

        private double[] copyAndReverse(double[] dArray) {
            double[] dArray2 = new double[dArray.length];
            int n = 0;
            int n2 = dArray.length - 1;
            while (n < dArray.length) {
                dArray2[n2] = dArray[n];
                ++n;
                --n2;
            }
            return dArray2;
        }

        public Map<Gene.Transcript, int[]> pickTranscripts(Map<Gene.Transcript, int[]> map) {
            double d;
            Object object;
            double d2;
            Object object2;
            HashMap hashMap = new HashMap();
            for (Gene gene : RnaSeqMetricsCollector.this.geneOverlapDetector.getAll()) {
                object2 = null;
                d2 = 0.0;
                for (Gene.Transcript object3 : gene) {
                    object = map.get(object3);
                    if (object3.length() < Math.max(RnaSeqMetricsCollector.this.minimumLength, 100) || object == null || (d = MathUtil.mean(MathUtil.promote(object), 0, ((int[])object).length)) < 1.0 || object2 != null && !(d > d2)) continue;
                    object2 = object3;
                    d2 = d;
                }
                if (object2 == null) continue;
                hashMap.put(object2, d2);
            }
            Object object4 = new double[hashMap.size()];
            int n = 0;
            object2 = hashMap.values().iterator();
            while (object2.hasNext()) {
                d2 = (Double)object2.next();
                object4[n++] = d2;
            }
            Arrays.sort((double[])object4);
            double d3 = ((Object)object4).length == 0 ? 0.0 : (double)object4[Math.max(0, ((Object)object4).length - 1001)];
            HashMap<Gene.Transcript, int[]> hashMap2 = new HashMap<Gene.Transcript, int[]>();
            for (Map.Entry entry : hashMap.entrySet()) {
                object = (Gene.Transcript)entry.getKey();
                d = (Double)entry.getValue();
                if (!(d >= d3)) continue;
                hashMap2.put((Gene.Transcript)object, map.get(object));
            }
            return hashMap2;
        }
    }

    public static enum StrandSpecificity {
        NONE,
        FIRST_READ_TRANSCRIPTION_STRAND,
        SECOND_READ_TRANSCRIPTION_STRAND;

    }
}

