/*
 * Decompiled with CFR 0.152.
 */
package picard.cmdline;

import com.google.common.base.CharMatcher;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import picard.PicardException;
import picard.cmdline.CommandLineParseException;
import picard.cmdline.CommandLineParserDefinitionException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.NestedOptions;
import picard.cmdline.Option;
import picard.cmdline.PositionalArguments;

public class CommandLineParser {
    private static final int OPTION_COLUMN_WIDTH = 30;
    private static final int DESCRIPTION_COLUMN_WIDTH = 90;
    private static final Boolean[] TRUE_FALSE_VALUES = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
    private static final String[] PACKAGES_WITH_WEB_DOCUMENTATION = new String[]{"picard"};
    private static final String defaultUsagePreamble = "Usage: program [options...]\n";
    private static final String defaultUsagePreambleWithPositionalArguments = "Usage: program [options...] [positional-arguments...]\n";
    private static final String OPTIONS_FILE = "OPTIONS_FILE";
    private static final String PRECEDENCE_SYMBOL = "++";
    private static final String[][] FRAMEWORK_OPTION_DOC = new String[][]{{"--help", "-h", "Displays options specific to this tool."}, {"--stdhelp", "-H", "Displays options specific to this tool AND options common to all Picard command line tools."}, {"--version", null, "Displays program version."}};
    private final Set<String> optionsThatCannotBeOverridden = new HashSet<String>();
    private final Object callerOptions;
    private final String prefix;
    private final String prefixDot;
    private Field positionalArguments;
    private int minPositionalArguments;
    private int maxPositionalArguments;
    private final List<OptionDefinition> optionDefinitions = new ArrayList<OptionDefinition>();
    private final Map<String, OptionDefinition> optionMap = new HashMap<String, OptionDefinition>();
    private final Map<String, CommandLineParser> childOptionsMap = new LinkedHashMap<String, CommandLineParser>();
    private final CollectionUtil.MultiMap<String, ChildOptionArg> childOptionArguments = new CollectionUtil.MultiMap();
    private PrintStream messageStream;
    private String[] argv;
    private String programVersion = null;
    private String commandLine = "";
    public File IGNORE_THIS_PROPERTY;
    private final CommandLineProgramProperties programProperties;
    private static final Map<String, String> htmlToText = new LinkedHashMap<String, String>(){
        {
            this.put("&lt;", "<");
            this.put("&gt;", ">");
            this.put("&ge;", ">=");
            this.put("&le;", "<=");
            this.put("<p>", "\n");
        }
    };

    public static String getStandardUsagePreamble(Class clazz) {
        return "USAGE: " + clazz.getSimpleName() + " [options]\n\n" + (CommandLineParser.hasWebDocumentation(clazz) ? "Documentation: http://broadinstitute.github.io/picard/command-line-overview.html#" + clazz.getSimpleName() + "\n\n" : "");
    }

    public static boolean hasWebDocumentation(Class clazz) {
        for (String string : PACKAGES_WITH_WEB_DOCUMENTATION) {
            if (!clazz.getPackage().getName().startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public static String getFaqLink() {
        return "To get help, see http://broadinstitute.github.io/picard/index.html#GettingHelp";
    }

    static Map<String, Object> getNestedOptions(Object object) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        Class<?> clazz = object.getClass();
        for (Field field : CommandLineParser.getAllFields(clazz)) {
            if (field.getAnnotation(NestedOptions.class) == null) continue;
            field.setAccessible(true);
            try {
                linkedHashMap.put(field.getName(), field.get(object));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Should never happen.", illegalAccessException);
            }
        }
        return linkedHashMap;
    }

    public CommandLineParser(Object object) {
        this(object, "");
    }

    private String getUsagePreamble() {
        String string = "";
        string = null != this.programProperties ? string + this.programProperties.usage() : (this.positionalArguments == null ? string + defaultUsagePreamble : string + defaultUsagePreambleWithPositionalArguments);
        if (null != this.programVersion && 0 < this.programVersion.length()) {
            string = string + "Version: " + this.getVersion() + "\n";
        }
        return string;
    }

    private CommandLineParser(Object object, String string) {
        this.callerOptions = object;
        this.prefix = string;
        this.prefixDot = string.isEmpty() ? "" : string + ".";
        int n = 1;
        for (Field field : CommandLineParser.getAllFields(this.callerOptions.getClass())) {
            if (field.getAnnotation(PositionalArguments.class) != null) {
                this.handlePositionalArgumentAnnotation(field);
            }
            if (field.getAnnotation(Option.class) != null) {
                this.handleOptionAnnotation(field, n);
                if (field.getAnnotation(Option.class).printOrder() != Integer.MAX_VALUE) continue;
                ++n;
                continue;
            }
            if (this.isCommandLineProgram() || field.getAnnotation(NestedOptions.class) == null) continue;
            this.handleNestedOptionsAnnotation(field);
        }
        if (this.optionDefinitions != null && !this.optionDefinitions.isEmpty()) {
            Collections.sort(this.optionDefinitions, new OptionDefinitionByPrintOrderComparator());
        }
        this.programProperties = this.callerOptions.getClass().getAnnotation(CommandLineProgramProperties.class);
    }

    private boolean isCommandLineProgram() {
        return this.callerOptions instanceof CommandLineProgram;
    }

    private static List<Field> getAllFields(Class clazz) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        do {
            arrayList.addAll(Arrays.asList(clazz.getDeclaredFields()));
        } while ((clazz = clazz.getSuperclass()) != null);
        return arrayList;
    }

    public String getVersion() {
        return this.callerOptions.getClass().getPackage().getImplementationVersion();
    }

    public void usage(PrintStream printStream, boolean bl) {
        Object object;
        if (this.prefix.isEmpty()) {
            object = CommandLineParser.htmlUnescape(CommandLineParser.convertFromHtml(CommandLineParser.getStandardUsagePreamble(this.callerOptions.getClass()) + this.getUsagePreamble()));
            CommandLineParser.checkForNonASCII((String)object, "Tool description");
            printStream.print((String)object);
            printStream.println("\nVersion: " + this.getVersion());
            printStream.println("\n\nOptions:\n");
            for (String[] stringArray : FRAMEWORK_OPTION_DOC) {
                this.printOptionParamUsage(printStream, stringArray[0], stringArray[1], null, stringArray[2]);
            }
        }
        if (!this.optionDefinitions.isEmpty()) {
            this.optionDefinitions.stream().filter(optionDefinition -> bl || !optionDefinition.isCommon).forEach(optionDefinition -> this.printOptionUsage(printStream, (OptionDefinition)optionDefinition));
        }
        if (bl) {
            try {
                object = this.getClass().getField("IGNORE_THIS_PROPERTY");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new PicardException("Should never happen", noSuchFieldException);
            }
            String[][] stringArray = new OptionDefinition((Field)object, OPTIONS_FILE, "", "File of OPTION_NAME=value pairs.  No positional parameters allowed.  Unlike command-line options, unrecognized options are ignored.  A single-valued option set in an options file may be overridden by a subsequent command-line option.  A line starting with '#' is considered a comment.", false, true, false, 0, Integer.MAX_VALUE, null, true, new String[0], Integer.MAX_VALUE);
            this.printOptionUsage(printStream, (OptionDefinition)stringArray);
        }
        this.getChildParsersForHelp().stream().forEach(commandLineParser -> commandLineParser.usage(printStream, bl));
    }

    static void checkForNonASCII(String string, String string2) {
        if (!CharMatcher.ASCII.matchesAllOf((CharSequence)string)) {
            throw new AssertionError((Object)("Non-ASCII character used in documentation (" + string2 + "). Only ASCII characters are allowed."));
        }
        if (Pattern.compile(".*&[a-zA-Z]*?;.*", 8).matcher(string).find()) {
            throw new AssertionError((Object)("Non-ASCII character used in documentation (" + string2 + "). Only ASCII characters are allowed."));
        }
    }

    static String convertFromHtml(String string3) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("< *a *href=['\"](.*?)['\"] *>(.*?)</ *a *>", "$2 ($1)");
        linkedHashMap.put("< *a *href=['\"](.*?)['\"] *>(.*?)< *a */>", "$2 ($1)");
        linkedHashMap.put("</ *(br|p|table|h[1-4]|pre|hr|li|ul) *>", "\n");
        linkedHashMap.put("< *(br|p|table|h[1-4]|pre|hr|li|ul) */>", "\n");
        linkedHashMap.put("< *(p|table|h[1-4]|ul|pre) *>", "\n");
        linkedHashMap.put("<li>", " - ");
        linkedHashMap.put("</th>", "\t");
        linkedHashMap.put("<\\w*?>", "");
        return ((Stream)linkedHashMap.entrySet().stream().sequential()).reduce(string3, (string, entry) -> string.replaceAll((String)entry.getKey(), (String)entry.getValue()), (string, string2) -> string2);
    }

    private Collection<CommandLineParser> getChildParsersForHelp() {
        ArrayList<CommandLineParser> arrayList;
        if (this.isCommandLineProgram()) {
            arrayList = new ArrayList();
            for (Map.Entry<String, Object> entry : ((CommandLineProgram)this.callerOptions).getNestedOptionsForHelp().entrySet()) {
                if (entry.getKey().contains(".")) {
                    throw new IllegalArgumentException("Prefix for nested options should not contain period: " + entry.getKey());
                }
                arrayList.add(new CommandLineParser(entry.getValue(), this.prefixDot + entry.getKey()));
            }
        } else {
            arrayList = this.childOptionsMap.values();
        }
        return arrayList;
    }

    public void htmlUsage(PrintStream printStream, String string, boolean bl) {
        printStream.println("<h3 id=\"" + string + "\">" + string + "</h3>");
        printStream.println("<section>");
        printStream.println("<p>" + this.getUsagePreamble() + "</p>");
        boolean bl2 = false;
        for (OptionDefinition optionDefinition : this.optionDefinitions) {
            if (optionDefinition.isCommon && !bl) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            this.htmlPrintOptions(printStream, bl);
        }
        printStream.println("</section>");
    }

    public void htmlPrintOptions(PrintStream printStream, boolean bl) {
        printStream.println("<table>");
        printStream.println("<tr><th>Option</th><th>Description</th></tr>");
        if (bl) {
            for (String[] stringArray : FRAMEWORK_OPTION_DOC) {
                printStream.println("<tr><td>" + stringArray[0] + "</td><td>" + stringArray[2] + "</td></tr>");
            }
        }
        this.htmlPrintOptionTableRows(printStream, bl);
        printStream.println("</table>");
    }

    private void htmlPrintOptionTableRows(PrintStream printStream, boolean bl) {
        for (OptionDefinition object : this.optionDefinitions) {
            CommandLineParser.checkForNonASCII(object.doc, object.name);
            if (object.isCommon && !bl) continue;
            this.printHtmlOptionUsage(printStream, object);
        }
        for (CommandLineParser commandLineParser : this.getChildParsersForHelp()) {
            commandLineParser.htmlPrintOptionTableRows(printStream, false);
        }
    }

    static String htmlUnescape(String string3) {
        return ((Stream)htmlToText.entrySet().stream().sequential()).reduce(string3, (string, entry) -> string.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue()), (string, string2) -> string2);
    }

    public boolean parseOptions(PrintStream printStream, String[] stringArray) {
        this.argv = stringArray;
        this.messageStream = printStream;
        if (this.prefix.isEmpty()) {
            this.commandLine = this.callerOptions.getClass().getName();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("-h") || string.equals("--help")) {
                this.usage(printStream, false);
                return false;
            }
            if (string.equals("-H") || string.equals("--stdhelp")) {
                this.usage(printStream, true);
                return false;
            }
            if (string.equals("--version")) {
                printStream.println(this.getVersion());
                return false;
            }
            String[] stringArray2 = string.split("=", 2);
            if (stringArray2.length == 2 && stringArray2[1].isEmpty() && i < stringArray.length - 1) {
                stringArray2[1] = stringArray[++i];
            }
            if (stringArray2.length == 2) {
                if (this.parseOption(stringArray2[0], stringArray2[1], false)) continue;
                printStream.println();
                this.usage(printStream, true);
                return false;
            }
            if (this.parsePositionalArgument(string)) continue;
            printStream.println();
            this.usage(printStream, false);
            return false;
        }
        if (!this.checkNumArguments()) {
            printStream.println();
            this.usage(printStream, false);
            return false;
        }
        if (!this.parseChildOptions()) {
            printStream.println();
            this.usage(printStream, false);
            return false;
        }
        return true;
    }

    private boolean checkNumArguments() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            for (OptionDefinition object : this.optionDefinitions) {
                string = this.prefixDot + object.name;
                StringBuilder stringBuilder2 = new StringBuilder();
                for (String string2 : object.mutuallyExclusive) {
                    OptionDefinition optionDefinition = this.optionMap.get(string2);
                    if (optionDefinition == null || !optionDefinition.hasBeenSet) continue;
                    stringBuilder2.append(' ').append(this.prefixDot).append(optionDefinition.name);
                }
                if (object.hasBeenSet && stringBuilder2.length() > 0) {
                    this.messageStream.println("ERROR: Option '" + string + "' cannot be used in conjunction with option(s)" + stringBuilder2.toString());
                    return false;
                }
                if (object.isCollection) {
                    Collection collection = (Collection)object.field.get(this.callerOptions);
                    if (collection.size() >= object.minElements) continue;
                    this.messageStream.println("ERROR: Option '" + string + "' must be specified at least " + object.minElements + " times.");
                    return false;
                }
                if (object.optional || object.hasBeenSet || object.hasBeenSetFromParent || stringBuilder2.length() != 0) continue;
                this.messageStream.print("ERROR: Option '" + string + "' is required");
                if (object.mutuallyExclusive.isEmpty()) {
                    this.messageStream.println(".");
                } else {
                    this.messageStream.println(" unless any of " + object.mutuallyExclusive + " are specified.");
                }
                return false;
            }
            if (this.positionalArguments != null) {
                Collection collection = (Collection)this.positionalArguments.get(this.callerOptions);
                if (collection.size() < this.minPositionalArguments) {
                    this.messageStream.println("ERROR: At least " + this.minPositionalArguments + " positional arguments must be specified.");
                    return false;
                }
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    string = iterator.next();
                    stringBuilder.append(' ').append(string.toString());
                }
            }
            for (OptionDefinition optionDefinition : this.optionDefinitions) {
                if (!optionDefinition.hasBeenSet) continue;
                stringBuilder.append(' ').append(this.prefixDot).append(optionDefinition.name).append('=').append(optionDefinition.field.get(this.callerOptions));
            }
            stringBuilder.append("   ");
            for (OptionDefinition optionDefinition : this.optionDefinitions) {
                if (optionDefinition.hasBeenSet || optionDefinition.defaultValue.equals("null")) continue;
                stringBuilder.append(' ').append(this.prefixDot).append(optionDefinition.name).append('=').append(optionDefinition.defaultValue);
            }
            this.commandLine = this.commandLine + stringBuilder.toString();
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    private boolean parsePositionalArgument(String string) {
        Collection collection;
        Object object;
        if (this.positionalArguments == null) {
            this.messageStream.println("ERROR: Invalid argument '" + string + "'.");
            return false;
        }
        try {
            object = this.constructFromString(this.getUnderlyingType(this.positionalArguments), string);
        }
        catch (CommandLineParseException commandLineParseException) {
            this.messageStream.println("ERROR: " + commandLineParseException.getMessage());
            return false;
        }
        try {
            collection = (Collection)this.positionalArguments.get(this.callerOptions);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        if (collection.size() >= this.maxPositionalArguments) {
            this.messageStream.println("ERROR: No more than " + this.maxPositionalArguments + " positional arguments may be specified on the command line.");
            return false;
        }
        collection.add(object);
        return true;
    }

    private boolean parseOption(String string, String string2, boolean bl) {
        return this.parseOption(string, string2, bl, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parseOption(String string, String string2, boolean bl, boolean bl2) {
        Object object;
        Integer n;
        if ((string = string.toUpperCase()).equals(OPTIONS_FILE)) {
            this.commandLine = this.commandLine + " " + this.prefix + OPTIONS_FILE + "=" + string2;
            return this.parseOptionsFile(string2);
        }
        if (string.startsWith(PRECEDENCE_SYMBOL)) {
            string = string.substring(PRECEDENCE_SYMBOL.length());
            bl2 = true;
        }
        if ((n = Integer.valueOf(string.indexOf(46))) != -1) {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1);
            if (!string4.isEmpty()) {
                this.childOptionArguments.append((Object)string3, (Object)new ChildOptionArg(string4, string2, bl, bl2));
                return true;
            }
            this.messageStream.println("ERROR: Unrecognized option: " + string);
            return false;
        }
        OptionDefinition optionDefinition = this.optionMap.get(string);
        if (optionDefinition == null) {
            if (bl) {
                return true;
            }
            this.messageStream.println("ERROR: Unrecognized option: " + string);
            return false;
        }
        if (this.optionsThatCannotBeOverridden.contains(optionDefinition.name)) {
            return true;
        }
        if (bl2) {
            this.optionsThatCannotBeOverridden.add(optionDefinition.name);
        }
        if (!optionDefinition.isCollection && optionDefinition.hasBeenSet && !optionDefinition.hasBeenSetFromOptionsFile) {
            this.messageStream.println("ERROR: Option '" + string + "' cannot be specified more than once.");
            return false;
        }
        try {
            if (string2.equals("null")) {
                if (!optionDefinition.optional) {
                    this.messageStream.println("ERROR: non-null value must be provided for '" + string + "'.");
                    return false;
                }
                object = null;
            } else {
                object = this.constructFromString(this.getUnderlyingType(optionDefinition.field), string2);
            }
        }
        catch (CommandLineParseException commandLineParseException) {
            this.messageStream.println("ERROR: " + commandLineParseException.getMessage());
            return false;
        }
        try {
            Field[] fieldArray;
            if (optionDefinition.isCollection) {
                Collection collection = (Collection)optionDefinition.field.get(this.callerOptions);
                if (object == null) {
                    collection.clear();
                } else {
                    if (collection.size() >= optionDefinition.maxElements) {
                        this.messageStream.println("ERROR: Option '" + string + "' cannot be used more than " + optionDefinition.maxElements + " times.");
                        return false;
                    }
                    collection.add(object);
                }
                optionDefinition.hasBeenSet = true;
                optionDefinition.hasBeenSetFromOptionsFile = bl;
                return true;
            }
            String string5 = optionDefinition.field.getName();
            for (Field field : fieldArray = this.callerOptions.getClass().getFields()) {
                if (!field.getName().equals(string5)) continue;
                field.set(this.callerOptions, object);
                optionDefinition.hasBeenSet = true;
            }
            if (!optionDefinition.hasBeenSet) {
                optionDefinition.field.set(this.callerOptions, object);
                optionDefinition.hasBeenSet = true;
            }
            optionDefinition.hasBeenSetFromOptionsFile = bl;
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    private boolean parseOptionsFile(String string) {
        return this.parseOptionsFile(string, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean parseOptionsFile(String var1_1, boolean var2_2) {
        block8: {
            var3_3 = null;
            try {
                var3_3 = new BufferedReader(new FileReader(var1_1));
                while ((var4_4 = var3_3.readLine()) != null) {
                    if (var4_4.startsWith("#") || var4_4.trim().isEmpty()) continue;
                    var5_6 = var4_4.split("=", 2);
                    if (var5_6.length == 2) {
                        if (this.parseOption(var5_6[0], var5_6[1], var2_2)) continue;
                        this.messageStream.println();
                        this.usage(this.messageStream, true);
                        var6_8 = false;
                        break block8;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl-1000
            }
            catch (IOException var4_5) {
                try {
                    throw new PicardException("I/O error loading OPTIONS_FILE=" + var1_1, var4_5);
                }
                catch (Throwable var7_10) {
                    CloserUtil.close(var3_3);
                    throw var7_10;
                }
            }
        }
        CloserUtil.close((Object)var3_3);
        return var6_8;
lbl-1000:
        // 1 sources

        {
            this.messageStream.println("Strange line in OPTIONS_FILE " + var1_1 + ": " + var4_4);
            this.usage(this.messageStream, true);
            var6_9 = false;
        }
        CloserUtil.close((Object)var3_3);
        return var6_9;
lbl-1000:
        // 1 sources

        {
            var3_3.close();
            var5_7 = true;
        }
        CloserUtil.close((Object)var3_3);
        return var5_7;
    }

    private void printHtmlOptionUsage(PrintStream printStream, OptionDefinition optionDefinition) {
        String string = this.getUnderlyingType(optionDefinition.field).getSimpleName();
        String string2 = this.prefixDot + optionDefinition.name + " (" + string + ")";
        printStream.println("<tr><td>" + string2 + "</td><td>" + this.makeOptionDescription(optionDefinition) + "</td></tr>");
    }

    private void printOptionUsage(PrintStream printStream, OptionDefinition optionDefinition) {
        this.printOptionParamUsage(printStream, optionDefinition.name, optionDefinition.shortName, this.getUnderlyingType(optionDefinition.field).getSimpleName(), this.makeOptionDescription(optionDefinition));
    }

    private void printOptionParamUsage(PrintStream printStream, String string, String string2, String string3, String string4) {
        String string5 = this.prefixDot + string;
        if (string3 != null) {
            string5 = string5 + "=" + string3;
        }
        printStream.print(string5);
        if (string2 != null && !string2.isEmpty()) {
            printStream.println();
            string5 = this.prefixDot + string2;
            if (string3 != null) {
                string5 = string5 + "=" + string3;
            }
            printStream.print(string5);
        }
        int n = 30 - string5.length();
        if (string5.length() > 30) {
            printStream.println();
            n = 30;
        }
        this.printSpaces(printStream, n);
        CommandLineParser.checkForNonASCII(string4, string);
        String string6 = StringUtil.wordWrap((String)CommandLineParser.convertFromHtml(string4), (int)90);
        String[] stringArray = string6.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                this.printSpaces(printStream, 30);
            }
            printStream.println(stringArray[i]);
        }
        printStream.println();
    }

    private String makeOptionDescription(OptionDefinition optionDefinition) {
        Object[] objectArray;
        StringBuilder stringBuilder = new StringBuilder();
        if (!optionDefinition.doc.isEmpty()) {
            stringBuilder.append(optionDefinition.doc);
            stringBuilder.append("  ");
        }
        if (optionDefinition.optional) {
            stringBuilder.append("Default value: ");
            stringBuilder.append(optionDefinition.defaultValue);
            stringBuilder.append(". ");
            if (!optionDefinition.defaultValue.equals("null")) {
                stringBuilder.append("This option can be set to 'null' to clear the default value. ");
            }
        } else if (!optionDefinition.isCollection) {
            stringBuilder.append("Required. ");
        }
        if ((objectArray = this.getUnderlyingType(optionDefinition.field).getEnumConstants()) == null && this.getUnderlyingType(optionDefinition.field) == Boolean.class) {
            objectArray = TRUE_FALSE_VALUES;
        }
        if (objectArray != null) {
            Boolean bl = objectArray.length > 0 && objectArray[0] instanceof ClpEnum;
            stringBuilder.append("Possible values: {");
            if (bl.booleanValue()) {
                stringBuilder.append('\n');
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0 && !bl.booleanValue()) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(objectArray[i].toString());
                if (!bl.booleanValue()) continue;
                stringBuilder.append(" (").append(((ClpEnum)objectArray[i]).getHelpDoc()).append(")\n");
            }
            stringBuilder.append("} ");
        }
        if (optionDefinition.isCollection) {
            if (optionDefinition.minElements == 0) {
                if (optionDefinition.maxElements == Integer.MAX_VALUE) {
                    stringBuilder.append("This option may be specified 0 or more times. ");
                } else {
                    stringBuilder.append("This option must be specified no more than ").append(optionDefinition.maxElements).append(" times. ");
                }
            } else if (optionDefinition.maxElements == Integer.MAX_VALUE) {
                stringBuilder.append("This option must be specified at least ").append(optionDefinition.minElements).append(" times. ");
            } else {
                stringBuilder.append("This option may be specified between ").append(optionDefinition.minElements).append(" and ").append(optionDefinition.maxElements).append(" times. ");
            }
            if (!optionDefinition.defaultValue.equals("null")) {
                stringBuilder.append("This option can be set to 'null' to clear the default list. ");
            }
        }
        if (!optionDefinition.mutuallyExclusive.isEmpty()) {
            stringBuilder.append(" Cannot be used in conjuction with option(s)");
            for (String string : optionDefinition.mutuallyExclusive) {
                OptionDefinition optionDefinition2 = this.optionMap.get(string);
                if (optionDefinition2 == null) {
                    throw new PicardException("Invalid option definition in source code.  " + string + " doesn't match any known option.");
                }
                stringBuilder.append(' ').append(optionDefinition2.name);
                if (optionDefinition2.shortName.isEmpty()) continue;
                stringBuilder.append(" (").append(optionDefinition2.shortName).append(')');
            }
        }
        return stringBuilder.toString();
    }

    private void printSpaces(PrintStream printStream, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        printStream.print(stringBuilder);
    }

    private void handleOptionAnnotation(Field field, int n) {
        try {
            field.setAccessible(true);
            Option option = field.getAnnotation(Option.class);
            boolean bl = this.isCollectionField(field);
            if (bl) {
                if (option.maxElements() == 0) {
                    throw new CommandLineParserDefinitionException("@Option member " + field.getName() + "has maxElements = 0");
                }
                if (option.minElements() > option.maxElements()) {
                    throw new CommandLineParserDefinitionException("In @Option member " + field.getName() + ", minElements cannot be > maxElements");
                }
                if (field.get(this.callerOptions) == null) {
                    this.createCollection(field, this.callerOptions, "@Option");
                }
            }
            if (!this.canBeMadeFromString(this.getUnderlyingType(field))) {
                throw new CommandLineParserDefinitionException("@Option member " + field.getName() + " must have a String ctor or be an enum");
            }
            int n2 = option.printOrder();
            if (n2 == Integer.MAX_VALUE) {
                n2 = n * 1000;
            }
            OptionDefinition optionDefinition = new OptionDefinition(field, field.getName(), option.shortName(), option.doc(), option.optional() || field.get(this.callerOptions) != null, option.overridable(), bl, option.minElements(), option.maxElements(), field.get(this.callerOptions), option.common(), option.mutex(), n2);
            for (String string : option.mutex()) {
                OptionDefinition optionDefinition2 = this.optionMap.get(string);
                if (optionDefinition2 == null) continue;
                optionDefinition2.mutuallyExclusive.add(field.getName());
            }
            if (!optionDefinition.overridable && this.optionMap.containsKey(optionDefinition.name)) {
                throw new CommandLineParserDefinitionException(optionDefinition.name + " has already been used.");
            }
            if (!optionDefinition.shortName.isEmpty() && !optionDefinition.shortName.equals(optionDefinition.name)) {
                if (this.optionMap.containsKey(optionDefinition.shortName)) {
                    if (!optionDefinition.overridable) {
                        throw new CommandLineParserDefinitionException(optionDefinition.shortName + " has already been used");
                    }
                } else {
                    this.optionMap.put(optionDefinition.shortName, optionDefinition);
                }
            }
            if (!optionDefinition.overridable || !this.optionMap.containsKey(optionDefinition.name)) {
                this.optionDefinitions.add(optionDefinition);
                this.optionMap.put(optionDefinition.name, optionDefinition);
            } else if (this.optionMap.containsKey(optionDefinition.name)) {
                field.set(this.callerOptions, this.optionMap.get((Object)optionDefinition.name).field.get(this.callerOptions));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CommandLineParserDefinitionException(field.getName() + " must have public visibility to have @Option annotation");
        }
    }

    private void handlePositionalArgumentAnnotation(Field field) {
        if (this.positionalArguments != null) {
            throw new CommandLineParserDefinitionException("@PositionalArguments cannot be used more than once in an option class.");
        }
        field.setAccessible(true);
        this.positionalArguments = field;
        if (!this.isCollectionField(field)) {
            throw new CommandLineParserDefinitionException("@PositionalArguments must be applied to a Collection");
        }
        if (!this.canBeMadeFromString(this.getUnderlyingType(field))) {
            throw new CommandLineParserDefinitionException("@PositionalParameters member " + field.getName() + "does not have a String ctor");
        }
        PositionalArguments positionalArguments = field.getAnnotation(PositionalArguments.class);
        this.minPositionalArguments = positionalArguments.minElements();
        this.maxPositionalArguments = positionalArguments.maxElements();
        if (this.minPositionalArguments > this.maxPositionalArguments) {
            throw new CommandLineParserDefinitionException("In @PositionalArguments, minElements cannot be > maxElements");
        }
        try {
            if (field.get(this.callerOptions) == null) {
                this.createCollection(field, this.callerOptions, "@PositionalParameters");
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CommandLineParserDefinitionException(field.getName() + " must have public visibility to have @PositionalParameters annotation");
        }
    }

    private void handleNestedOptionsAnnotation(Field field) {
        field.setAccessible(true);
        try {
            this.childOptionsMap.put(field.getName(), new CommandLineParser(field.get(this.callerOptions), this.prefixDot + field.getName()));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CommandLineParserDefinitionException("Should never happen.", illegalAccessException);
        }
    }

    private boolean isCollectionField(Field field) {
        try {
            field.getType().asSubclass(Collection.class);
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    private void createCollection(Field field, Object object, String string) throws IllegalAccessException {
        try {
            field.set(object, field.getType().newInstance());
        }
        catch (Exception exception) {
            try {
                field.set(object, new ArrayList());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CommandLineParserDefinitionException("In collection " + string + " member " + field.getName() + " cannot be constructed or auto-initialized with ArrayList, so collection must be initialized explicitly.");
            }
        }
    }

    private Class getUnderlyingType(Field field) {
        if (this.isCollectionField(field)) {
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            if (typeArray.length != 1) {
                throw new CommandLineParserDefinitionException("Strange collection type for field " + field.getName());
            }
            return (Class)typeArray[0];
        }
        Class<?> clazz = field.getType();
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        return clazz;
    }

    private boolean canBeMadeFromString(Class clazz) {
        if (clazz.isEnum()) {
            return true;
        }
        try {
            clazz.getConstructor(String.class);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    private Object constructFromString(Class clazz, String string) {
        try {
            if (clazz.isEnum()) {
                try {
                    return Enum.valueOf(clazz, string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new CommandLineParseException("'" + string + "' is not a valid value for " + clazz.getSimpleName() + ".", illegalArgumentException);
                }
            }
            Constructor constructor = clazz.getConstructor(String.class);
            return constructor.newInstance(string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CommandLineParseException("Cannot find string ctor for " + clazz.getName(), noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            throw new CommandLineParseException("Abstract class '" + clazz.getSimpleName() + "'cannot be used for an option value type.", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CommandLineParseException("String constructor for option value type '" + clazz.getSimpleName() + "' must be public.", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CommandLineParseException("Problem constructing " + clazz.getSimpleName() + " from the string '" + string + "'.", invocationTargetException.getCause());
        }
    }

    public String[] getArgv() {
        return this.argv;
    }

    private boolean parseChildOptions() {
        Object object;
        if (this.isCommandLineProgram()) {
            CommandLineProgram commandLineProgram = (CommandLineProgram)this.callerOptions;
            for (Map.Entry object2 : commandLineProgram.getNestedOptions().entrySet()) {
                if (((String)object2.getKey()).contains(".")) {
                    throw new IllegalArgumentException("Prefix for nested options should not contain period: " + (String)object2.getKey());
                }
                this.childOptionsMap.put((String)object2.getKey(), new CommandLineParser(object2.getValue(), this.prefixDot + (String)object2.getKey()));
            }
        }
        boolean bl = true;
        for (String string : this.childOptionArguments.keySet()) {
            if (this.childOptionsMap.containsKey(string)) continue;
            this.messageStream.println("ERROR: Option prefix '" + string + "' is not valid.");
            bl = false;
        }
        try {
            for (OptionDefinition optionDefinition : this.optionDefinitions) {
                if (optionDefinition.isCollection || (object = optionDefinition.field.get(this.callerOptions)) == null) continue;
                for (CommandLineParser commandLineParser : this.childOptionsMap.values()) {
                    this.maybePropagateValueToChild(commandLineParser, optionDefinition, object);
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Should never happen", illegalAccessException);
        }
        for (Map.Entry entry : this.childOptionsMap.entrySet()) {
            object = (String)entry.getKey();
            CommandLineParser commandLineParser = (CommandLineParser)entry.getValue();
            commandLineParser.messageStream = this.messageStream;
            Collection collection = (Collection)this.childOptionArguments.get(object);
            if (collection != null) {
                for (ChildOptionArg childOptionArg : collection) {
                    super.parseOption(childOptionArg.name, childOptionArg.value, childOptionArg.fromFile, childOptionArg.precedenceSet);
                }
            }
            if (!super.checkNumArguments()) {
                bl = false;
            }
            if (!super.parseChildOptions()) {
                bl = false;
            }
            this.commandLine = this.commandLine + " " + commandLineParser.getCommandLine();
        }
        return bl;
    }

    private void maybePropagateValueToChild(CommandLineParser commandLineParser, OptionDefinition optionDefinition, Object object) {
        try {
            Object object2;
            OptionDefinition optionDefinition2 = commandLineParser.optionMap.get(optionDefinition.name);
            if (optionDefinition2 != null && ((object2 = optionDefinition2.field.get(commandLineParser.callerOptions)) == null || optionDefinition.hasBeenSet)) {
                optionDefinition2.field.set(commandLineParser.callerOptions, object);
                optionDefinition2.hasBeenSetFromParent = true;
                optionDefinition2.hasBeenSetFromOptionsFile = optionDefinition.hasBeenSetFromOptionsFile;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Should never happen", illegalAccessException);
        }
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public void setMessageStream(PrintStream printStream) {
        this.messageStream = printStream;
    }

    public Object getCallerOptions() {
        return this.callerOptions;
    }

    private static final class ChildOptionArg {
        final String name;
        final String value;
        final boolean fromFile;
        final boolean precedenceSet;

        private ChildOptionArg(String string, String string2, boolean bl, boolean bl2) {
            this.name = string;
            this.value = string2;
            this.fromFile = bl;
            this.precedenceSet = bl2;
        }
    }

    protected static final class OptionDefinition {
        final Field field;
        final String name;
        final String shortName;
        final String doc;
        final boolean optional;
        final boolean overridable;
        final boolean isCollection;
        final int minElements;
        final int maxElements;
        final int printOrder;
        final String defaultValue;
        final boolean isCommon;
        boolean hasBeenSet = false;
        boolean hasBeenSetFromOptionsFile = false;
        boolean hasBeenSetFromParent = false;
        final Set<String> mutuallyExclusive;

        private OptionDefinition(Field field, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, int n, int n2, Object object, boolean bl4, String[] stringArray, int n3) {
            this.field = field;
            this.name = string.toUpperCase();
            this.shortName = string2.toUpperCase();
            this.doc = string3;
            this.optional = bl;
            this.overridable = bl2;
            this.isCollection = bl3;
            this.minElements = n;
            this.maxElements = n2;
            this.defaultValue = object != null ? (this.isCollection && ((Collection)object).isEmpty() ? "null" : object.toString()) : "null";
            this.isCommon = bl4;
            this.mutuallyExclusive = new HashSet<String>(Arrays.asList(stringArray));
            this.printOrder = n3;
        }
    }

    protected static class OptionDefinitionByPrintOrderComparator
    implements Comparator<OptionDefinition> {
        protected OptionDefinitionByPrintOrderComparator() {
        }

        @Override
        public int compare(OptionDefinition optionDefinition, OptionDefinition optionDefinition2) {
            return optionDefinition.printOrder - optionDefinition2.printOrder;
        }
    }

    public static interface ClpEnum {
        public String getHelpDoc();
    }
}

