/*
 * Decompiled with CFR 0.152.
 */
package picard.fastq;

import htsjdk.samtools.util.StringUtil;
import picard.fastq.ReadNameEncoder;
import picard.illumina.parser.ClusterData;

public class Casava18ReadNameEncoder
implements ReadNameEncoder {
    static final int CONTROL_FIELD_VALUE = 0;
    final String runId;
    final String instrumentName;
    final String flowcellId;

    public Casava18ReadNameEncoder(String string, String string2, String string3) {
        this.runId = string2;
        this.instrumentName = string;
        this.flowcellId = string3;
    }

    @Override
    public String generateReadName(ClusterData clusterData, Integer n) {
        return this.instrumentName + ":" + this.runId + ":" + this.flowcellId + ":" + clusterData.getLane() + ":" + clusterData.getTile() + ":" + clusterData.getX() + ":" + clusterData.getY() + " " + StringUtil.asEmptyIfNull((Object)n) + ":" + (Object)((Object)IsFilteredLabel.get(clusterData.isPf())) + ":" + 0 + ":" + StringUtil.asEmptyIfNull((Object)clusterData.getMatchedBarcode());
    }

    static enum IsFilteredLabel {
        Y,
        N;


        static IsFilteredLabel get(boolean bl) {
            return bl ? N : Y;
        }
    }
}

