/*
 * Decompiled with CFR 0.152.
 */
package picard.fastq;

import picard.fastq.ReadNameEncoder;
import picard.illumina.parser.ClusterData;

public class IlluminaReadNameEncoder
implements ReadNameEncoder {
    final String runBarcode;

    public IlluminaReadNameEncoder(String string) {
        this.runBarcode = string;
    }

    @Override
    public String generateReadName(ClusterData clusterData, Integer n) {
        return this.runBarcode + ":" + clusterData.getLane() + ":" + clusterData.getTile() + ":" + clusterData.getX() + ":" + clusterData.getY() + IlluminaReadNameEncoder.generatePairNumberSuffix(n);
    }

    private static String generatePairNumberSuffix(Integer n) {
        if (n == null) {
            return "";
        }
        return "/" + n;
    }
}

