/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.variant.utils.SAMSequenceDictionaryExtractor;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import picard.PicardException;
import picard.analysis.FingerprintingDetailMetrics;
import picard.analysis.FingerprintingSummaryMetrics;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Alpha;
import picard.fingerprint.DiploidGenotype;
import picard.fingerprint.FingerprintChecker;
import picard.fingerprint.FingerprintResults;
import picard.fingerprint.LocusResult;
import picard.fingerprint.MatchResults;

@CommandLineProgramProperties(usage="Computes a fingerprint from the supplied SAM/BAM file and compares it to the expected fingerprint genotypes provided. The key output is a LOD score which represents the relative likelihood of the sequence data originating from the same sample as the genotypes vs. from a random sample.  Two outputs are produced: (1) a summary metrics file that gives metrics related single read group (lane or index within a lane) versus a set of known genotypes for the expected sample, and (2) a detail metrics file that contains an individual SNP/Haplotype comparison within a fingerprint comparison.  The two files may be specified individually using the SUMMARY_OUTPUT and DETAIL_OUTPUT options.  Alternatively the OUTPUT option may be used instead to give the base of the two output files, with the summary metrics having a file extension 'fingerprinting_summary_metrics' and the detail metrics having a file extension 'fingerprinting_detail_metrics'.", usageShort="Computes a fingerprint from the supplied SAM/BAM file and compares it to the provided genotypes", programGroup=Alpha.class)
public class CheckFingerprint
extends CommandLineProgram {
    static final String USAGE_DETAILS = "Computes a fingerprint from the supplied SAM/BAM file and compares it to the expected fingerprint genotypes provided. The key output is a LOD score which represents the relative likelihood of the sequence data originating from the same sample as the genotypes vs. from a random sample.  Two outputs are produced: (1) a summary metrics file that gives metrics related single read group (lane or index within a lane) versus a set of known genotypes for the expected sample, and (2) a detail metrics file that contains an individual SNP/Haplotype comparison within a fingerprint comparison.  The two files may be specified individually using the SUMMARY_OUTPUT and DETAIL_OUTPUT options.  Alternatively the OUTPUT option may be used instead to give the base of the two output files, with the summary metrics having a file extension 'fingerprinting_summary_metrics' and the detail metrics having a file extension 'fingerprinting_detail_metrics'.";
    @Option(shortName="I", doc="Input SAM or BAM file.")
    public File INPUT;
    @Option(shortName="O", doc="The base of output files to write.  The summary metrics will have the file extension 'fingerprinting_summary_metrics' and the detail metrics will have the extension 'fingerprinting_detail_metrics'.", mutex={"SUMMARY_OUTPUT", "DETAIL_OUTPUT"})
    public String OUTPUT;
    @Option(shortName="S", doc="The text file to which to write summary metrics.", mutex={"OUTPUT"})
    public File SUMMARY_OUTPUT;
    @Option(shortName="D", doc="The text file to which to write detail metrics.", mutex={"OUTPUT"})
    public File DETAIL_OUTPUT;
    @Option(shortName="G", doc="File of genotypes (VCF or GELI) to be used in comparison. May contain any number of genotypes; CheckFingerprint will use only those that are usable for fingerprinting.")
    public File GENOTYPES;
    @Option(optional=true, doc="If using VCF format genotypes, this parameter can be used to specify which sample's genotypes to use from the VCF file.  If not supplied the sample name from the BAM read group header is used instead.")
    public String SAMPLE_ALIAS;
    @Option(shortName="H", doc="A file of haplotype information produced by the CheckFingerprint program.")
    public File HAPLOTYPE_MAP;
    @Option(shortName="LOD", doc="When counting haplotypes checked and matching, count only haplotypes where the most likely haplotype achieves at least this LOD.")
    public double GENOTYPE_LOD_THRESHOLD = 5.0;
    @Option(shortName="IGNORE_RG", doc="If true, treat the entire input BAM as one single read group in the calculation, ignoring RG annotations, and producing a single fingerprint metric for the entire BAM.")
    public boolean IGNORE_READ_GROUPS = false;
    private final Log log = Log.getInstance(CheckFingerprint.class);
    public static final String FINGERPRINT_SUMMARY_FILE_SUFFIX = "fingerprinting_summary_metrics";
    public static final String FINGERPRINT_DETAIL_FILE_SUFFIX = "fingerprinting_detail_metrics";

    public static void main(String[] stringArray) {
        new CheckFingerprint().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        MetricsFile metricsFile2;
        Object object;
        File file;
        File file2;
        if (this.OUTPUT == null) {
            file2 = this.DETAIL_OUTPUT;
            file = this.SUMMARY_OUTPUT;
        } else {
            if (!this.OUTPUT.endsWith(".")) {
                this.OUTPUT = this.OUTPUT + ".";
            }
            file2 = new File(this.OUTPUT + FINGERPRINT_DETAIL_FILE_SUFFIX);
            file = new File(this.OUTPUT + FINGERPRINT_SUMMARY_FILE_SUFFIX);
        }
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsReadable((File)this.HAPLOTYPE_MAP);
        IOUtil.assertFileIsReadable((File)this.GENOTYPES);
        IOUtil.assertFileIsWritable((File)file2);
        IOUtil.assertFileIsWritable((File)file);
        FingerprintChecker fingerprintChecker = new FingerprintChecker(this.HAPLOTYPE_MAP);
        SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)SAMSequenceDictionaryExtractor.extractDictionary((File)this.INPUT), (SAMSequenceDictionary)SAMSequenceDictionaryExtractor.extractDictionary((File)this.GENOTYPES), (boolean)true);
        SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)SAMSequenceDictionaryExtractor.extractDictionary((File)this.INPUT), (SAMSequenceDictionary)fingerprintChecker.getHeader().getSequenceDictionary(), (boolean)true);
        if (this.SAMPLE_ALIAS == null) {
            object = SamReaderFactory.makeDefault().open(this.INPUT);
            for (MetricsFile metricsFile2 : object.getFileHeader().getReadGroups()) {
                if (this.SAMPLE_ALIAS == null) {
                    this.SAMPLE_ALIAS = metricsFile2.getSample();
                    continue;
                }
                if (this.SAMPLE_ALIAS.equals(metricsFile2.getSample())) continue;
                throw new PicardException("SAM File must not contain data from multiple samples.");
            }
            CloserUtil.close((Object)object);
        }
        object = fingerprintChecker.checkFingerprints(Arrays.asList(this.INPUT), Arrays.asList(this.GENOTYPES), this.SAMPLE_ALIAS, this.IGNORE_READ_GROUPS);
        Iterator iterator = this.getMetricsFile();
        metricsFile2 = this.getMetricsFile();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            FingerprintResults fingerprintResults = (FingerprintResults)iterator2.next();
            MatchResults matchResults = fingerprintResults.getMatchResults().first();
            FingerprintingSummaryMetrics fingerprintingSummaryMetrics = new FingerprintingSummaryMetrics();
            fingerprintingSummaryMetrics.READ_GROUP = fingerprintResults.getReadGroup();
            fingerprintingSummaryMetrics.SAMPLE = this.SAMPLE_ALIAS;
            fingerprintingSummaryMetrics.LL_EXPECTED_SAMPLE = matchResults.getSampleLikelihood();
            fingerprintingSummaryMetrics.LL_RANDOM_SAMPLE = matchResults.getPopulationLikelihood();
            fingerprintingSummaryMetrics.LOD_EXPECTED_SAMPLE = matchResults.getLOD();
            for (LocusResult locusResult : matchResults.getLocusResults()) {
                DiploidGenotype diploidGenotype = locusResult.getExpectedGenotype();
                DiploidGenotype diploidGenotype2 = locusResult.getMostLikelyGenotype();
                ++fingerprintingSummaryMetrics.HAPLOTYPES_WITH_GENOTYPES;
                if (locusResult.getLodGenotype() >= this.GENOTYPE_LOD_THRESHOLD) {
                    ++fingerprintingSummaryMetrics.HAPLOTYPES_CONFIDENTLY_CHECKED;
                    if (locusResult.getExpectedGenotype() == locusResult.getMostLikelyGenotype()) {
                        ++fingerprintingSummaryMetrics.HAPLOTYPES_CONFIDENTLY_MATCHING;
                    }
                    if (diploidGenotype.isHeterozygous() && diploidGenotype2.isHomomozygous()) {
                        ++fingerprintingSummaryMetrics.HET_AS_HOM;
                    }
                    if (diploidGenotype.isHomomozygous() && diploidGenotype2.isHeterozygous()) {
                        ++fingerprintingSummaryMetrics.HOM_AS_HET;
                    }
                    if (diploidGenotype.isHomomozygous() && diploidGenotype2.isHomomozygous() && diploidGenotype.compareTo(diploidGenotype2) != 0) {
                        ++fingerprintingSummaryMetrics.HOM_AS_OTHER_HOM;
                    }
                }
                FingerprintingDetailMetrics fingerprintingDetailMetrics = new FingerprintingDetailMetrics();
                fingerprintingDetailMetrics.READ_GROUP = fingerprintResults.getReadGroup();
                fingerprintingDetailMetrics.SAMPLE = this.SAMPLE_ALIAS;
                fingerprintingDetailMetrics.SNP = locusResult.getSnp().getName();
                fingerprintingDetailMetrics.SNP_ALLELES = locusResult.getSnp().getAlleleString();
                fingerprintingDetailMetrics.CHROM = locusResult.getSnp().getChrom();
                fingerprintingDetailMetrics.POSITION = locusResult.getSnp().getPos();
                fingerprintingDetailMetrics.EXPECTED_GENOTYPE = diploidGenotype.toString();
                fingerprintingDetailMetrics.OBSERVED_GENOTYPE = diploidGenotype2.toString();
                fingerprintingDetailMetrics.LOD = locusResult.getLodGenotype();
                fingerprintingDetailMetrics.OBS_A = locusResult.getAllele1Count();
                fingerprintingDetailMetrics.OBS_B = locusResult.getAllele2Count();
                metricsFile2.addMetric((MetricBase)fingerprintingDetailMetrics);
            }
            iterator.addMetric(fingerprintingSummaryMetrics);
            this.log.info(new Object[]{fingerprintingSummaryMetrics.READ_GROUP + " vs. " + fingerprintingSummaryMetrics.SAMPLE + ": LOD = " + fingerprintingSummaryMetrics.LOD_EXPECTED_SAMPLE});
        }
        iterator.write(file);
        metricsFile2.write(file2);
        return 0;
    }
}

