/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.HaplotypeProbabilitiesFromSequence;

public class Fingerprint
extends TreeMap<HaplotypeBlock, HaplotypeProbabilities> {
    private final String sample;
    private final File source;
    private final String info;

    public Fingerprint(String string, File file, String string2) {
        this.sample = string;
        this.source = file;
        this.info = string2;
    }

    public String getSample() {
        return this.sample;
    }

    public File getSource() {
        return this.source;
    }

    public String getInfo() {
        return this.info;
    }

    public String getPrintableId() {
        return this.getSample() + "@" + (this.source == null ? "" : this.source.getName()) + (this.info == null ? "" : ":" + this.info);
    }

    public void add(HaplotypeProbabilities haplotypeProbabilities) {
        this.put(haplotypeProbabilities.getHaplotype(), haplotypeProbabilities);
    }

    public void merge(Fingerprint fingerprint) {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.keySet());
        hashSet.addAll(fingerprint.keySet());
        for (HaplotypeBlock haplotypeBlock : hashSet) {
            HaplotypeProbabilities haplotypeProbabilities = (HaplotypeProbabilities)this.get(haplotypeBlock);
            HaplotypeProbabilities haplotypeProbabilities2 = (HaplotypeProbabilities)fingerprint.get(haplotypeBlock);
            if (haplotypeProbabilities == null) {
                haplotypeProbabilities = haplotypeProbabilities2;
                this.put(haplotypeBlock, haplotypeProbabilities);
                continue;
            }
            if (haplotypeProbabilities2 == null) continue;
            haplotypeProbabilities.merge(haplotypeProbabilities2);
        }
    }

    public void filterSuspectSites() {
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            HaplotypeProbabilitiesFromSequence haplotypeProbabilitiesFromSequence;
            Map.Entry entry = iterator.next();
            HaplotypeProbabilities haplotypeProbabilities = (HaplotypeProbabilities)entry.getValue();
            if (!(haplotypeProbabilities instanceof HaplotypeProbabilitiesFromSequence) || !((haplotypeProbabilitiesFromSequence = (HaplotypeProbabilitiesFromSequence)haplotypeProbabilities).getLodMostProbableGenotype() >= 3.0) || !(haplotypeProbabilitiesFromSequence.getFractionUnexpectedAlleleObs() > 0.1)) continue;
            iterator.remove();
        }
    }
}

