/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.tribble.readers.LineIteratorImpl;
import htsjdk.tribble.readers.LineReaderUtil;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFCodec;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import picard.PicardException;

public class GenotypeReader {
    public VariantIterator read(File file) {
        if (this.isVcf(file)) {
            return this.readVcf(file);
        }
        throw new PicardException("File doe not appear to be of a supported type: " + file);
    }

    public VariantIterator read(File file, IntervalList intervalList) {
        final VariantIterator variantIterator = this.read(file);
        final OverlapDetector overlapDetector = new OverlapDetector(0, 0);
        overlapDetector.addAll(intervalList.getIntervals(), intervalList.getIntervals());
        return new VariantIterator(variantIterator.getSequenceDictionary(), variantIterator.getHeader()){
            private VariantContext next;
            {
                super(sAMSequenceDictionary, object);
                this.next = null;
            }

            public boolean hasNext() {
                if (this.next == null) {
                    while (variantIterator.hasNext()) {
                        VariantContext variantContext = (VariantContext)variantIterator.next();
                        Interval interval = new Interval(variantContext.getChr(), variantContext.getStart(), variantContext.getEnd());
                        Collection collection = overlapDetector.getOverlaps(interval);
                        if (collection == null || collection.isEmpty()) continue;
                        this.next = variantContext;
                        break;
                    }
                }
                return this.next != null;
            }

            public VariantContext next() {
                if (!this.hasNext()) {
                    throw new IllegalStateException("next() called on exhausted iterator.");
                }
                VariantContext variantContext = this.next;
                this.next = null;
                return variantContext;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void close() {
                variantIterator.close();
            }
        };
    }

    boolean isVcf(File file) {
        String string = file.getName();
        return string.endsWith(".vcf") || string.endsWith(".vcf.gz");
    }

    VariantIterator readVcf(File file) {
        LineIteratorImpl lineIteratorImpl = new LineIteratorImpl(LineReaderUtil.fromBufferedStream((InputStream)new BufferedInputStream(IOUtil.openFileForReading((File)file))));
        VCFCodec vCFCodec = new VCFCodec();
        Object object = vCFCodec.readActualHeader((LineIterator)lineIteratorImpl);
        return new VariantIterator(null, object, (LineIterator)lineIteratorImpl, vCFCodec){
            final /* synthetic */ LineIterator val$reader;
            final /* synthetic */ VCFCodec val$codec;
            {
                this.val$reader = lineIterator;
                this.val$codec = vCFCodec;
                super(sAMSequenceDictionary, object);
            }

            public boolean hasNext() {
                return this.val$reader.hasNext();
            }

            public VariantContext next() {
                return this.val$codec.decode((String)this.val$reader.next());
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void close() {
                this.val$codec.close(this.val$reader);
            }
        };
    }

    public static abstract class VariantIterator
    implements CloseableIterator<VariantContext> {
        private final SAMSequenceDictionary dictionary;
        private final Object header;

        protected VariantIterator(SAMSequenceDictionary sAMSequenceDictionary, Object object) {
            this.dictionary = sAMSequenceDictionary;
            this.header = object;
        }

        public SAMSequenceDictionary getSequenceDictionary() {
            return this.dictionary;
        }

        public Object getHeader() {
            return this.header;
        }
    }
}

