/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.util.FormatUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.LineReader;
import htsjdk.samtools.util.StringLineReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import picard.PicardException;
import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.Snp;

public class HaplotypeMap {
    private final List<HaplotypeBlock> haplotypeBlocks = new ArrayList<HaplotypeBlock>();
    private final Map<Snp, HaplotypeBlock> haplotypesBySnp = new HashMap<Snp, HaplotypeBlock>();
    private final Map<String, HaplotypeBlock> haplotypesBySnpName = new HashMap<String, HaplotypeBlock>();
    private final Map<String, HaplotypeBlock> haplotypesBySnpLocus = new HashMap<String, HaplotypeBlock>();
    private final Map<String, Snp> snpsByPosition = new HashMap<String, Snp>();
    private final IntervalList intervals;
    private final SAMFileHeader header;

    public HaplotypeMap(File file) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(IOUtil.openFileForReading((File)file)));
            StringBuilder stringBuilder = new StringBuilder(4096);
            String string = null;
            while ((string = bufferedReader.readLine()) != null && string.startsWith("@")) {
                stringBuilder.append(string).append('\n');
            }
            if (stringBuilder.length() == 0) {
                throw new IllegalStateException("Haplotype map file must contain header: " + file.getAbsolutePath());
            }
            this.header = new SAMTextHeaderCodec().decode((LineReader)new StringLineReader(stringBuilder.toString()), "BufferedReader");
            this.intervals = new IntervalList(this.header);
            FormatUtil formatUtil = new FormatUtil();
            ArrayList<HaplotypeMapFileEntry> arrayList = new ArrayList<HaplotypeMapFileEntry>();
            HashMap<Object, HaplotypeBlock> hashMap = new HashMap<Object, HaplotypeBlock>();
            do {
                if (string.trim().isEmpty() || string.startsWith("#")) continue;
                String[] stringArray = string.split("\\t");
                if (stringArray.length < 6 || stringArray.length > 8) {
                    throw new PicardException("Invalid haplotype map record contains " + stringArray.length + " fields: " + string);
                }
                Object object2 = stringArray[0];
                int n = formatUtil.parseInt((String)stringArray[1]);
                Object object = stringArray[2];
                byte by = (byte)((String)stringArray[3]).charAt(0);
                byte by2 = (byte)((String)stringArray[4]).charAt(0);
                double d = formatUtil.parseDouble((String)stringArray[5]);
                Object object3 = stringArray.length > 6 ? stringArray[6] : null;
                Object object4 = stringArray.length > 7 ? stringArray[7] : null;
                ArrayList<String> arrayList2 = null;
                if (object4 != null) {
                    arrayList2 = new ArrayList<String>();
                    for (String string2 : ((String)object4).split(",")) {
                        arrayList2.add(string2);
                    }
                }
                if (object3 == null || ((String)object3).trim().equals("") || ((String)object).equals(object3)) {
                    HaplotypeBlock haplotypeBlock = new HaplotypeBlock(d);
                    haplotypeBlock.addSnp(new Snp((String)object, (String)object2, n, by, by2, d, arrayList2));
                    hashMap.put(object, haplotypeBlock);
                    continue;
                }
                HaplotypeMapFileEntry haplotypeMapFileEntry = new HaplotypeMapFileEntry((String)object2, n, (String)object, by, by2, d, (String)object3, arrayList2);
                arrayList.add(haplotypeMapFileEntry);
            } while ((string = bufferedReader.readLine()) != null);
            for (HaplotypeMapFileEntry haplotypeMapFileEntry : arrayList) {
                HaplotypeBlock haplotypeBlock = (HaplotypeBlock)hashMap.get(haplotypeMapFileEntry.anchorSnp);
                if (haplotypeBlock == null) {
                    throw new PicardException("No haplotype found for anchor snp " + haplotypeMapFileEntry.anchorSnp);
                }
                haplotypeBlock.addSnp(new Snp(haplotypeMapFileEntry.snpName, haplotypeMapFileEntry.chromosome, haplotypeMapFileEntry.position, haplotypeMapFileEntry.majorAllele, haplotypeMapFileEntry.minorAllele, haplotypeMapFileEntry.minorAlleleFrequency, haplotypeMapFileEntry.panels));
            }
            for (HaplotypeBlock haplotypeBlock : hashMap.values()) {
                this.addHaplotype(haplotypeBlock);
            }
        }
        catch (IOException iOException) {
            throw new PicardException("Error parsing haplotype map.", iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public HaplotypeMap(SAMFileHeader sAMFileHeader) {
        this.header = sAMFileHeader;
        this.intervals = new IntervalList(sAMFileHeader);
    }

    public void addHaplotype(HaplotypeBlock haplotypeBlock) {
        this.haplotypeBlocks.add(haplotypeBlock);
        for (Snp snp : haplotypeBlock.getSnps()) {
            this.haplotypesBySnp.put(snp, haplotypeBlock);
            this.haplotypesBySnpName.put(snp.getName(), haplotypeBlock);
            this.haplotypesBySnpLocus.put(this.toKey(snp.getChrom(), snp.getPos()), haplotypeBlock);
            this.snpsByPosition.put(this.toKey(snp.getChrom(), snp.getPos()), snp);
            this.intervals.add(new Interval(snp.getChrom(), snp.getPos(), snp.getPos(), false, snp.getName()));
        }
    }

    public HaplotypeBlock getHaplotype(Snp snp) {
        return this.haplotypesBySnp.get(snp);
    }

    public HaplotypeBlock getHaplotype(String string) {
        return this.haplotypesBySnpName.get(string);
    }

    public HaplotypeBlock getHaplotype(String string, int n) {
        return this.haplotypesBySnpLocus.get(this.toKey(string, n));
    }

    public List<HaplotypeBlock> getHaplotypes() {
        return Collections.unmodifiableList(this.haplotypeBlocks);
    }

    public Snp getSnp(String string, int n) {
        return this.snpsByPosition.get(this.toKey(string, n));
    }

    public Set<Snp> getAllSnps() {
        return Collections.unmodifiableSet(this.haplotypesBySnp.keySet());
    }

    public IntervalList getIntervalList() {
        this.intervals.sort();
        return this.intervals;
    }

    private String toKey(String string, int n) {
        return string + ":" + n;
    }

    public HaplotypeMap withoutChromosomes(Set<String> set) {
        HaplotypeMap haplotypeMap = new HaplotypeMap(this.getHeader());
        for (HaplotypeBlock haplotypeBlock : this.haplotypeBlocks) {
            if (set.contains(haplotypeBlock.getFirstSnp().getChrom())) continue;
            haplotypeMap.addHaplotype(haplotypeBlock);
        }
        return haplotypeMap;
    }

    public void writeToFile(File file) {
        try {
            Object object;
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(IOUtil.openFileForWriting((File)file)));
            FormatUtil formatUtil = new FormatUtil();
            if (this.header != null) {
                object = new SAMTextHeaderCodec();
                object.encode((Writer)bufferedWriter, this.header);
            }
            bufferedWriter.write("#CHROMOSOME\tPOSITION\tNAME\tMAJOR_ALLELE\tMINOR_ALLELE\tMAF\tANCHOR_SNP\tPANELS");
            bufferedWriter.newLine();
            object = new ArrayList();
            for (HaplotypeBlock comparable : this.getHaplotypes()) {
                String string = null;
                TreeSet<Snp> treeSet = new TreeSet<Snp>(comparable.getSnps());
                for (Snp snp : treeSet) {
                    object.add(new HaplotypeMapFileEntry(snp.getChrom(), snp.getPos(), snp.getName(), snp.getAllele1(), snp.getAllele2(), snp.getMaf(), string, snp.getFingerprintPanels()));
                    if (string != null) continue;
                    string = snp.getName();
                }
            }
            Collections.sort(object);
            Iterator<HaplotypeBlock> iterator = object.iterator();
            while (iterator.hasNext()) {
                HaplotypeMapFileEntry haplotypeMapFileEntry = (HaplotypeMapFileEntry)((Object)iterator.next());
                bufferedWriter.write(haplotypeMapFileEntry.chromosome + "\t");
                bufferedWriter.write(formatUtil.format(haplotypeMapFileEntry.position) + "\t");
                bufferedWriter.write(haplotypeMapFileEntry.snpName + "\t");
                bufferedWriter.write((char)haplotypeMapFileEntry.majorAllele + "\t");
                bufferedWriter.write((char)haplotypeMapFileEntry.minorAllele + "\t");
                bufferedWriter.write(formatUtil.format(haplotypeMapFileEntry.minorAlleleFrequency) + "\t");
                if (haplotypeMapFileEntry.anchorSnp != null) {
                    bufferedWriter.write(haplotypeMapFileEntry.anchorSnp);
                }
                bufferedWriter.write("\t");
                if (haplotypeMapFileEntry.getPanels() != null) {
                    bufferedWriter.write(haplotypeMapFileEntry.getPanels());
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new PicardException("Error writing out maplotype map to file: " + file.getAbsolutePath(), iOException);
        }
    }

    public SAMFileHeader getHeader() {
        return this.header;
    }

    private class HaplotypeMapFileEntry
    implements Comparable {
        private final String chromosome;
        private final int position;
        private final String snpName;
        private final byte majorAllele;
        private final byte minorAllele;
        private final double minorAlleleFrequency;
        private final String anchorSnp;
        private final List<String> panels;

        public HaplotypeMapFileEntry(String string, int n, String string2, byte by, byte by2, double d, String string3, List<String> list) {
            this.chromosome = string;
            this.position = n;
            this.snpName = string2;
            this.majorAllele = by;
            this.minorAllele = by2;
            this.minorAlleleFrequency = d;
            this.anchorSnp = string3;
            this.panels = new ArrayList<String>();
            if (list != null) {
                this.panels.addAll(list);
                Collections.sort(this.panels);
            }
        }

        public String getPanels() {
            if (this.panels == null) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.panels) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }

        public int compareTo(Object object) {
            HaplotypeMapFileEntry haplotypeMapFileEntry = (HaplotypeMapFileEntry)object;
            int n = HaplotypeMap.this.header.getSequenceIndex(this.chromosome) - HaplotypeMap.this.header.getSequenceIndex(haplotypeMapFileEntry.chromosome);
            if (n != 0) {
                return n;
            }
            n = this.position - haplotypeMapFileEntry.position;
            if (n != 0) {
                return n;
            }
            n = this.snpName.compareTo(haplotypeMapFileEntry.snpName);
            if (n != 0) {
                return n;
            }
            n = this.majorAllele - haplotypeMapFileEntry.majorAllele;
            if (n != 0) {
                return n;
            }
            n = this.minorAllele - haplotypeMapFileEntry.minorAllele;
            if (n != 0) {
                return n;
            }
            n = Double.compare(this.minorAlleleFrequency, haplotypeMapFileEntry.minorAlleleFrequency);
            if (n != 0) {
                return n;
            }
            n = this.anchorSnp != null ? (haplotypeMapFileEntry.anchorSnp != null ? this.anchorSnp.compareTo(haplotypeMapFileEntry.anchorSnp) : 1) : (haplotypeMapFileEntry.anchorSnp != null ? -1 : 0);
            if (n != 0) {
                return n;
            }
            String string = this.getPanels();
            String string2 = haplotypeMapFileEntry.getPanels();
            if (string != null) {
                if (string2 != null) {
                    return string.compareTo(string2);
                }
                return 1;
            }
            if (string2 != null) {
                return -1;
            }
            return 0;
        }
    }
}

