/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import java.util.Arrays;
import picard.fingerprint.DiploidGenotype;
import picard.fingerprint.DiploidHaplotype;
import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.Snp;
import picard.util.MathUtil;

public abstract class HaplotypeProbabilities {
    private final HaplotypeBlock haplotypeBlock;

    protected HaplotypeProbabilities(HaplotypeBlock haplotypeBlock) {
        this.haplotypeBlock = haplotypeBlock;
    }

    public HaplotypeBlock getHaplotype() {
        return this.haplotypeBlock;
    }

    public double[] getPriorProbablities() {
        return this.getHaplotype().getHaplotypeFrequencies();
    }

    public double[] getPosteriorProbabilities() {
        return MathUtil.pNormalizeVector(MathUtil.multiply(this.getLikelihoods(), this.getPriorProbablities()));
    }

    public abstract double[] getLikelihoods();

    public double[] getLogLikelihoods() {
        double[] dArray = this.getLikelihoods();
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = Math.log10(dArray[i]);
        }
        return dArray2;
    }

    public abstract Snp getRepresentativeSnp();

    public int getObsAllele1() {
        return 0;
    }

    public int getObsAllele2() {
        return 0;
    }

    public int getTotalObs() {
        return 0;
    }

    public boolean hasEvidence() {
        return true;
    }

    public abstract void merge(HaplotypeProbabilities var1);

    int getMostLikelyIndex() {
        double[] dArray = this.getPosteriorProbabilities();
        if (dArray[0] > dArray[1] && dArray[0] > dArray[2]) {
            return 0;
        }
        if (dArray[1] > dArray[2]) {
            return 1;
        }
        return 2;
    }

    public DiploidHaplotype getMostLikelyHaplotype() {
        return DiploidHaplotype.values()[this.getMostLikelyIndex()];
    }

    public DiploidGenotype getMostLikelyGenotype(Snp snp) {
        this.assertSnpPartOfHaplotype(snp);
        return snp.getGenotype(this.getMostLikelyHaplotype());
    }

    void assertSnpPartOfHaplotype(Snp snp) {
        if (!this.haplotypeBlock.getSnps().contains(snp)) {
            throw new IllegalArgumentException("Snp " + snp + " does not belong to haplotype " + this.haplotypeBlock);
        }
    }

    public double scaledEvidenceProbabilityUsingGenotypeFrequencies(double[] dArray) {
        double[] dArray2 = this.getLikelihoods();
        assert (dArray.length == dArray2.length);
        double d = 0.0;
        for (int i = 0; i < dArray2.length; ++i) {
            d += dArray2[i] * dArray[i];
        }
        return d;
    }

    public double shiftedLogEvidenceProbabilityUsingGenotypeFrequencies(double[] dArray) {
        return Math.log10(this.scaledEvidenceProbabilityUsingGenotypeFrequencies(dArray));
    }

    public double shiftedLogEvidenceProbabilityGivenOtherEvidence(HaplotypeProbabilities haplotypeProbabilities) {
        if (!this.haplotypeBlock.equals(haplotypeProbabilities.getHaplotype())) {
            throw new IllegalArgumentException("Haplotypes are from different HaplotypeBlocks!");
        }
        return this.shiftedLogEvidenceProbabilityUsingGenotypeFrequencies(haplotypeProbabilities.getPosteriorProbabilities());
    }

    public double shiftedLogEvidenceProbability() {
        return this.shiftedLogEvidenceProbabilityUsingGenotypeFrequencies(this.getPriorProbablities());
    }

    public double getLodMostProbableGenotype() {
        double[] dArray = this.getPosteriorProbabilities();
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = Math.log10(dArray[i]);
        }
        Arrays.sort(dArray2);
        return dArray2[2] - dArray2[1];
    }

    protected static enum Genotype {
        HOM_ALLELE1(0),
        HET_ALLELE12(1),
        HOM_ALLELE2(2);

        int v;

        private Genotype(int n2) {
            this.v = n2;
        }
    }
}

