/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.samtools.util.QualityUtil;
import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.HaplotypeProbabilitiesFromSequence;
import picard.fingerprint.Snp;
import picard.util.MathUtil;

public class HaplotypeProbabilitiesFromContaminatorSequence
extends HaplotypeProbabilitiesFromSequence {
    public double contamination;
    double[][] likelihoodMap = new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}};

    public HaplotypeProbabilitiesFromContaminatorSequence(HaplotypeBlock haplotypeBlock, double d) {
        super(haplotypeBlock);
        assert (d <= 1.0);
        assert (d >= 0.0);
        this.contamination = d;
    }

    @Override
    public void addToProbs(Snp snp, byte by, byte by2) {
        boolean bl;
        this.assertSnpPartOfHaplotype(snp);
        if (by == snp.getAllele1()) {
            ++this.obsAllele1;
            bl = false;
        } else if (by == snp.getAllele2()) {
            ++this.obsAllele2;
            bl = true;
        } else {
            ++this.obsAlleleOther;
            return;
        }
        double d = QualityUtil.getErrorProbabilityFromPhredScore((int)by2);
        for (HaplotypeProbabilities.Genotype genotype : HaplotypeProbabilities.Genotype.values()) {
            for (HaplotypeProbabilities.Genotype genotype2 : HaplotypeProbabilities.Genotype.values()) {
                double d2 = 0.5 * ((1.0 - this.contamination) * (double)genotype2.v + this.contamination * (double)genotype.v);
                double[] dArray = this.likelihoodMap[genotype.v];
                int n = genotype2.v;
                dArray[n] = dArray[n] * ((bl ? d2 : 1.0 - d2) * (1.0 - d) + (!bl ? d2 : 1.0 - d2) * d);
            }
        }
    }

    private void updateLikelihoods() {
        double[] dArray = new double[HaplotypeProbabilities.Genotype.values().length];
        for (HaplotypeProbabilities.Genotype genotype : HaplotypeProbabilities.Genotype.values()) {
            dArray[genotype.v] = Math.log10(MathUtil.sum(MathUtil.multiply(this.getPriorProbablities(), this.likelihoodMap[genotype.v])));
        }
        this.setLogLikelihoods(dArray);
    }

    @Override
    public void merge(HaplotypeProbabilities haplotypeProbabilities) {
        super.merge(haplotypeProbabilities);
        if (!this.getHaplotype().equals(haplotypeProbabilities.getHaplotype())) {
            throw new IllegalArgumentException("Mismatched haplotypes in call to HaplotypeProbabilities.merge(): " + this.getHaplotype() + ", " + haplotypeProbabilities.getHaplotype());
        }
        if (!(haplotypeProbabilities instanceof HaplotypeProbabilitiesFromContaminatorSequence)) {
            throw new IllegalArgumentException("Can only merge HaplotypeProbabilities of same class.");
        }
        HaplotypeProbabilitiesFromContaminatorSequence haplotypeProbabilitiesFromContaminatorSequence = (HaplotypeProbabilitiesFromContaminatorSequence)haplotypeProbabilities;
        if (haplotypeProbabilitiesFromContaminatorSequence.contamination != this.contamination) {
            throw new IllegalArgumentException("Can only merge HaplotypeProbabilitiesFromContaminatorSequence with the same contamination value.");
        }
        for (HaplotypeProbabilities.Genotype genotype : HaplotypeProbabilities.Genotype.values()) {
            this.likelihoodMap[genotype.v] = MathUtil.multiply(this.likelihoodMap[genotype.v], haplotypeProbabilitiesFromContaminatorSequence.likelihoodMap[genotype.v]);
        }
    }

    @Override
    public double[] getLogLikelihoods() {
        this.updateLikelihoods();
        return super.getLogLikelihoods();
    }
}

