/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.Snp;

public class HaplotypeProbabilitiesFromGenotype
extends HaplotypeProbabilities {
    private final Snp snp;
    private final double[] likelihoods;

    public HaplotypeProbabilitiesFromGenotype(Snp snp, HaplotypeBlock haplotypeBlock, double d, double d2, double d3) {
        super(haplotypeBlock);
        this.snp = snp;
        this.likelihoods = new double[]{d, d2, d3};
    }

    @Override
    public Snp getRepresentativeSnp() {
        return this.snp;
    }

    @Override
    public double[] getLikelihoods() {
        return this.likelihoods;
    }

    @Override
    public void merge(HaplotypeProbabilities haplotypeProbabilities) {
        if (!this.getHaplotype().equals(haplotypeProbabilities.getHaplotype())) {
            throw new IllegalArgumentException("Mismatched haplotypes in call to HaplotypeProbabilities.merge(): " + this.getHaplotype() + ", " + haplotypeProbabilities.getHaplotype());
        }
        if (!(haplotypeProbabilities instanceof HaplotypeProbabilitiesFromGenotype)) {
            throw new IllegalArgumentException("Can only merge HaplotypeProbabilities of same class.");
        }
        this.likelihoods[0] = this.likelihoods[0] * haplotypeProbabilities.getLikelihoods()[0];
        this.likelihoods[1] = this.likelihoods[1] * haplotypeProbabilities.getLikelihoods()[1];
        this.likelihoods[2] = this.likelihoods[2] * haplotypeProbabilities.getLikelihoods()[2];
    }
}

