/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.variant.variantcontext.Allele;
import java.util.List;
import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.HaplotypeProbabilitiesUsingLogLikelihoods;
import picard.fingerprint.Snp;
import picard.util.MathUtil;

public class HaplotypeProbabilitiesFromGenotypeLikelihoods
extends HaplotypeProbabilitiesUsingLogLikelihoods {
    public HaplotypeProbabilitiesFromGenotypeLikelihoods(HaplotypeBlock haplotypeBlock) {
        super(haplotypeBlock);
    }

    public void addToLogLikelihoods(Snp snp, List<Allele> list, double[] dArray) {
        byte by;
        this.assertSnpPartOfHaplotype(snp);
        assert (dArray.length == HaplotypeProbabilities.Genotype.values().length);
        assert (list.size() == 2);
        for (by = 0; by < 2; ++by) {
            assert (list.get(by).getBases().length == 1);
        }
        by = list.get(0).getBases()[0];
        byte by2 = list.get(1).getBases()[0];
        if (snp.getAllele1() == by && snp.getAllele2() == by2) {
            this.setLogLikelihoods(MathUtil.sum(this.getLogLikelihoods(), dArray));
            return;
        }
        if (snp.getAllele2() == by && snp.getAllele1() == by2) {
            double[] dArray2 = this.getLogLikelihoods();
            int n = HaplotypeProbabilities.Genotype.HOM_ALLELE1.v;
            dArray2[n] = dArray2[n] + dArray[HaplotypeProbabilities.Genotype.HOM_ALLELE2.v];
            int n2 = HaplotypeProbabilities.Genotype.HET_ALLELE12.v;
            dArray2[n2] = dArray2[n2] + dArray[HaplotypeProbabilities.Genotype.HET_ALLELE12.v];
            int n3 = HaplotypeProbabilities.Genotype.HOM_ALLELE2.v;
            dArray2[n3] = dArray2[n3] + dArray[HaplotypeProbabilities.Genotype.HOM_ALLELE1.v];
            this.setLogLikelihoods(dArray2);
            return;
        }
    }
}

