/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import java.util.Arrays;
import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.Snp;
import picard.util.MathUtil;

abstract class HaplotypeProbabilitiesUsingLogLikelihoods
extends HaplotypeProbabilities {
    private final double[] loglikelihoods = new double[HaplotypeProbabilities.Genotype.values().length];

    public HaplotypeProbabilitiesUsingLogLikelihoods(HaplotypeBlock haplotypeBlock) {
        super(haplotypeBlock);
    }

    @Override
    public Snp getRepresentativeSnp() {
        return this.getHaplotype().getFirstSnp();
    }

    @Override
    public boolean hasEvidence() {
        double[] dArray = this.getLogLikelihoods();
        return dArray[HaplotypeProbabilities.Genotype.HOM_ALLELE1.v] != 0.0 || dArray[HaplotypeProbabilities.Genotype.HET_ALLELE12.v] != 0.0 || dArray[HaplotypeProbabilities.Genotype.HOM_ALLELE2.v] != 0.0;
    }

    @Override
    public void merge(HaplotypeProbabilities haplotypeProbabilities) {
        if (!this.getHaplotype().equals(haplotypeProbabilities.getHaplotype())) {
            throw new IllegalArgumentException("Mismatched haplotypes in call to HaplotypeProbabilities.merge(): " + this.getHaplotype() + ", " + haplotypeProbabilities.getHaplotype());
        }
        if (!(haplotypeProbabilities instanceof HaplotypeProbabilitiesUsingLogLikelihoods)) {
            throw new IllegalArgumentException("Can only merge HaplotypeProbabilities of same class.");
        }
        HaplotypeProbabilitiesUsingLogLikelihoods haplotypeProbabilitiesUsingLogLikelihoods = (HaplotypeProbabilitiesUsingLogLikelihoods)haplotypeProbabilities;
        this.setLogLikelihoods(MathUtil.sum(this.getLogLikelihoods(), haplotypeProbabilitiesUsingLogLikelihoods.getLogLikelihoods()));
    }

    @Override
    public double[] getPosteriorProbabilities() {
        return MathUtil.pNormalizeLogProbability(this.getShiftedLogPosterior());
    }

    private double[] getShiftedLogPosterior() {
        double[] dArray = this.getLogLikelihoods();
        double[] dArray2 = new double[HaplotypeProbabilities.Genotype.values().length];
        double[] dArray3 = this.getPriorProbablities();
        for (HaplotypeProbabilities.Genotype genotype : HaplotypeProbabilities.Genotype.values()) {
            dArray2[genotype.v] = dArray[genotype.v] + Math.log10(dArray3[genotype.v]);
        }
        return dArray2;
    }

    @Override
    public double[] getLikelihoods() {
        return MathUtil.pNormalizeLogProbability(this.getLogLikelihoods());
    }

    @Override
    public double[] getLogLikelihoods() {
        return this.loglikelihoods;
    }

    public void setLogLikelihoods(double[] dArray) {
        assert (dArray.length == HaplotypeProbabilities.Genotype.values().length);
        System.arraycopy(dArray, 0, this.loglikelihoods, 0, dArray.length);
    }

    @Override
    public double getLodMostProbableGenotype() {
        double[] dArray = this.getShiftedLogPosterior();
        Arrays.sort(dArray);
        return dArray[HaplotypeProbabilities.Genotype.values().length - 1] - dArray[HaplotypeProbabilities.Genotype.values().length - 2];
    }
}

