/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import picard.fingerprint.DiploidGenotype;
import picard.fingerprint.Snp;

class LocusResult
implements Comparable<LocusResult> {
    private final Snp snp;
    private final DiploidGenotype expectedGenotype;
    private final DiploidGenotype mostLikelyGenotype;
    private final int allele1Count;
    private final int allele2Count;
    private final double lodGenotype;
    private final double lodExpectedSampleTumorNormal;
    private final double lodExpectedSampleNormalTumor;
    private final double lExpectedSample;
    private final double lRandomSample;

    LocusResult(Snp snp, DiploidGenotype diploidGenotype, DiploidGenotype diploidGenotype2, int n, int n2, double d, double d2, double d3, double d4, double d5) {
        this.snp = snp;
        this.expectedGenotype = diploidGenotype;
        this.mostLikelyGenotype = diploidGenotype2;
        this.allele1Count = n;
        this.allele2Count = n2;
        this.lodGenotype = d;
        this.lExpectedSample = d2;
        this.lRandomSample = d3;
        this.lodExpectedSampleTumorNormal = d4;
        this.lodExpectedSampleNormalTumor = d5;
    }

    public Snp getSnp() {
        return this.snp;
    }

    public DiploidGenotype getExpectedGenotype() {
        return this.expectedGenotype;
    }

    public DiploidGenotype getMostLikelyGenotype() {
        return this.mostLikelyGenotype;
    }

    public int getAllele1Count() {
        return this.allele1Count;
    }

    public int getAllele2Count() {
        return this.allele2Count;
    }

    public double getLodGenotype() {
        return this.lodGenotype;
    }

    public double getLodExpectedSampleNormalTumor() {
        return this.lodExpectedSampleNormalTumor;
    }

    public double getLodExpectedSampleTumorNormal() {
        return this.lodExpectedSampleTumorNormal;
    }

    public double lExpectedSample() {
        return this.lExpectedSample;
    }

    public double lRandomSample() {
        return this.lRandomSample;
    }

    @Override
    public int compareTo(LocusResult locusResult) {
        return this.snp.compareTo(locusResult.snp);
    }
}

