/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import java.io.File;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import picard.fingerprint.LocusResult;

public class MatchResults
implements Comparable<MatchResults> {
    private final File fingerprintFile;
    private final String sample;
    private final double sampleLikelihood;
    private final double populationLikelihood;
    private final double LOD;
    private final double lodTN;
    private final double lodNT;
    private final SortedSet<LocusResult> locusResults = new TreeSet<LocusResult>();

    public double getLodNT() {
        return this.lodNT;
    }

    public double getLodTN() {
        return this.lodTN;
    }

    MatchResults(File file, String string, double d, double d2, double d3, double d4, Collection<LocusResult> collection) {
        this.fingerprintFile = file;
        this.sample = string;
        this.sampleLikelihood = d;
        this.populationLikelihood = d2;
        this.LOD = d - d2;
        this.lodTN = d3;
        this.lodNT = d4;
        if (collection != null) {
            this.locusResults.addAll(collection);
        }
    }

    public void addLocusResult(LocusResult locusResult) {
        this.locusResults.add(locusResult);
    }

    @Override
    public int compareTo(MatchResults matchResults) {
        if (this.LOD != matchResults.LOD) {
            return this.LOD > matchResults.LOD ? -1 : 1;
        }
        return this.sample.compareTo(matchResults.sample);
    }

    public String getSample() {
        return this.sample;
    }

    public double getSampleLikelihood() {
        return this.sampleLikelihood;
    }

    public double getPopulationLikelihood() {
        return this.populationLikelihood;
    }

    public double getLOD() {
        return this.LOD;
    }

    public SortedSet<LocusResult> getLocusResults() {
        return this.locusResults;
    }

    public File getFingerprintFile() {
        return this.fingerprintFile;
    }
}

