/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.filter.SolexaNoiseFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import picard.PicardException;
import picard.fastq.IlluminaReadNameEncoder;
import picard.fastq.ReadNameEncoder;
import picard.illumina.IlluminaBasecallsConverter;
import picard.illumina.IlluminaBasecallsToSam;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.ReadData;
import picard.illumina.parser.ReadStructure;
import picard.util.AdapterMarker;
import picard.util.AdapterPair;
import picard.util.IlluminaUtil;

public class ClusterDataToSamConverter
implements IlluminaBasecallsConverter.ClusterDataConverter<IlluminaBasecallsToSam.SAMRecordsForCluster> {
    private final String readGroupId;
    private final SamRecordFilter filters = new SolexaNoiseFilter();
    private final boolean isPairedEnd;
    private final boolean hasSampleBarcode;
    private final boolean hasMolecularBarcode;
    private final int[] templateIndices;
    private final int[] sampleBarcodeIndices;
    private final int[] molecularBarcodeIndices;
    private final AdapterMarker adapterMarker;
    private final int outputRecordsPerCluster;
    private final ReadNameEncoder readNameEncoder;
    private String molecularIndexTag = "RX";
    private String molecularIndexQualityTag = "QX";
    private List<String> tagPerMolecularIndex = Collections.emptyList();

    public ClusterDataToSamConverter(String string, String string2, ReadStructure readStructure, List<IlluminaUtil.IlluminaAdapterPair> list) {
        this.readGroupId = string2;
        this.readNameEncoder = new IlluminaReadNameEncoder(string);
        this.isPairedEnd = readStructure.templates.length() == 2;
        this.hasSampleBarcode = !readStructure.sampleBarcodes.isEmpty();
        this.hasMolecularBarcode = !readStructure.molecularBarcode.isEmpty();
        this.adapterMarker = list.isEmpty() ? null : new AdapterMarker(list.toArray(new AdapterPair[list.size()]));
        this.templateIndices = readStructure.templates.getIndices();
        this.sampleBarcodeIndices = readStructure.sampleBarcodes.getIndices();
        this.molecularBarcodeIndices = readStructure.molecularBarcode.getIndices();
        this.outputRecordsPerCluster = readStructure.templates.length();
    }

    public ClusterDataToSamConverter withMolecularIndexTag(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Molecular index tag was null");
        }
        this.molecularIndexTag = string;
        return this;
    }

    public ClusterDataToSamConverter withMolecularIndexQualityTag(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Molecular index quality tag was null");
        }
        this.molecularIndexQualityTag = string;
        return this;
    }

    public ClusterDataToSamConverter withTagPerMolecularIndex(List<String> list) {
        if (list == null) {
            throw new IllegalArgumentException("Null given for tagPerMolecularIndex");
        }
        this.tagPerMolecularIndex = list;
        return this;
    }

    private SAMRecord createSamRecord(ReadData readData, String string, boolean bl, boolean bl2, String string2, List<String> list, List<String> list2) {
        SAMRecord sAMRecord = new SAMRecord(null);
        sAMRecord.setReadName(string);
        sAMRecord.setReadBases(readData.getBases());
        sAMRecord.setBaseQualities(readData.getQualities());
        sAMRecord.setReadPairedFlag(this.isPairedEnd);
        sAMRecord.setReadUnmappedFlag(true);
        sAMRecord.setReadFailsVendorQualityCheckFlag(!bl);
        if (this.isPairedEnd) {
            sAMRecord.setMateUnmappedFlag(true);
            sAMRecord.setFirstOfPairFlag(bl2);
            sAMRecord.setSecondOfPairFlag(!bl2);
        }
        if (this.filters.filterOut(sAMRecord)) {
            sAMRecord.setAttribute("XN", (Object)1);
        }
        if (this.readGroupId != null) {
            sAMRecord.setAttribute(SAMTag.RG.name(), (Object)this.readGroupId);
        }
        if (string2 != null) {
            sAMRecord.setAttribute(SAMTag.BC.name(), (Object)string2);
        }
        if (!list.isEmpty()) {
            if (!this.molecularIndexTag.isEmpty()) {
                sAMRecord.setAttribute(this.molecularIndexTag, (Object)String.join((CharSequence)"", list));
            }
            if (!this.molecularIndexQualityTag.isEmpty()) {
                sAMRecord.setAttribute(this.molecularIndexQualityTag, (Object)String.join((CharSequence)"", list2));
            }
            if (!this.tagPerMolecularIndex.isEmpty()) {
                if (this.tagPerMolecularIndex.size() != list.size()) {
                    throw new PicardException("Found " + list.size() + " molecular indexes but only " + this.tagPerMolecularIndex.size() + " SAM tags given.");
                }
                for (int i = 0; i < this.tagPerMolecularIndex.size(); ++i) {
                    sAMRecord.setAttribute(this.tagPerMolecularIndex.get(i), (Object)list.get(i));
                }
            }
        }
        return sAMRecord;
    }

    @Override
    public IlluminaBasecallsToSam.SAMRecordsForCluster convertClusterToOutputRecord(ClusterData clusterData) {
        SAMRecord sAMRecord;
        List<String> list;
        Object object;
        IlluminaBasecallsToSam.SAMRecordsForCluster sAMRecordsForCluster = new IlluminaBasecallsToSam.SAMRecordsForCluster(this.outputRecordsPerCluster);
        String string = this.readNameEncoder.generateReadName(clusterData, null);
        String string2 = null;
        if (this.hasSampleBarcode && clusterData.getMatchedBarcode() == null) {
            object = new byte[this.sampleBarcodeIndices.length][];
            for (int i = 0; i < this.sampleBarcodeIndices.length; ++i) {
                object[i] = clusterData.getRead(this.sampleBarcodeIndices[i]).getBases();
            }
            string2 = IlluminaUtil.barcodeSeqsToString((byte[][])object).replace('.', 'N');
        }
        if (this.hasMolecularBarcode) {
            object = new ArrayList();
            list = new ArrayList();
            for (int i = 0; i < this.molecularBarcodeIndices.length; ++i) {
                object.add(new String(clusterData.getRead(this.molecularBarcodeIndices[i]).getBases()).replace('.', 'N'));
                list.add(SAMUtils.phredToFastq((byte[])clusterData.getRead(this.molecularBarcodeIndices[i]).getQualities()));
            }
        } else {
            object = Collections.emptyList();
            list = Collections.emptyList();
        }
        sAMRecordsForCluster.records[0] = sAMRecord = this.createSamRecord(clusterData.getRead(this.templateIndices[0]), string, clusterData.isPf(), true, string2, (List<String>)object, list);
        SAMRecord sAMRecord2 = null;
        if (this.isPairedEnd) {
            sAMRecordsForCluster.records[1] = sAMRecord2 = this.createSamRecord(clusterData.getRead(this.templateIndices[1]), string, clusterData.isPf(), false, string2, (List<String>)object, list);
        }
        if (this.adapterMarker != null) {
            if (this.isPairedEnd) {
                this.adapterMarker.adapterTrimIlluminaPairedReads(sAMRecord, sAMRecord2);
            } else {
                this.adapterMarker.adapterTrimIlluminaSingleRead(sAMRecord);
            }
        }
        return sAMRecordsForCluster;
    }
}

