/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekIterator;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import picard.PicardException;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.IlluminaDataProvider;
import picard.illumina.parser.IlluminaDataProviderFactory;
import picard.illumina.parser.IlluminaDataType;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import picard.util.FileChannelJDKBugWorkAround;

public class IlluminaBasecallsConverter<CLUSTER_OUTPUT_RECORD> {
    private static final Log log = Log.getInstance(IlluminaBasecallsConverter.class);
    public static final IlluminaDataType[] DATA_TYPES_NO_BARCODE = new IlluminaDataType[]{IlluminaDataType.BaseCalls, IlluminaDataType.QualityScores, IlluminaDataType.Position, IlluminaDataType.PF};
    private static final IlluminaDataType[] DATA_TYPES_WITH_BARCODE = Arrays.copyOf(DATA_TYPES_NO_BARCODE, DATA_TYPES_NO_BARCODE.length + 1);
    public static final Comparator<Integer> TILE_NUMBER_COMPARATOR;
    private final Comparator<CLUSTER_OUTPUT_RECORD> outputRecordComparator;
    private final BclQualityEvaluationStrategy bclQualityEvaluationStrategy;
    private final Map<String, ? extends ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD>> barcodeRecordWriterMap;
    private final int maxReadsInRamPerTile;
    private final boolean demultiplex;
    private final List<File> tmpDirs;
    private final IlluminaDataProviderFactory factory;
    private ClusterDataConverter<CLUSTER_OUTPUT_RECORD> converter = null;
    private final ProgressLogger readProgressLogger = new ProgressLogger(log, 1000000, "Read");
    private final ProgressLogger writeProgressLogger = new ProgressLogger(log, 1000000, "Write");
    private int numThreads;
    private final TimerTask gcTimerTask;
    private List<Integer> tiles;
    private final boolean includeNonPfReads;
    private final boolean ignoreUnexpectedBarcodes;
    private final SortingCollection.Codec<CLUSTER_OUTPUT_RECORD> codecPrototype;
    private final Class<CLUSTER_OUTPUT_RECORD> outputRecordClass;

    public IlluminaBasecallsConverter(File file, int n, ReadStructure readStructure, Map<String, ? extends ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD>> map, boolean bl, int n2, List<File> list, int n3, boolean bl2, Integer n4, Integer n5, Comparator<CLUSTER_OUTPUT_RECORD> comparator, SortingCollection.Codec<CLUSTER_OUTPUT_RECORD> codec, Class<CLUSTER_OUTPUT_RECORD> clazz, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, boolean bl3, boolean bl4, boolean bl5) {
        this(file, null, n, readStructure, map, bl, n2, list, n3, bl2, n4, n5, comparator, codec, clazz, bclQualityEvaluationStrategy, bl3, bl4, bl5);
    }

    public IlluminaBasecallsConverter(File file, File file2, int n, ReadStructure readStructure, Map<String, ? extends ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD>> map, boolean bl, int n2, List<File> list, int n3, boolean bl2, Integer n4, Integer n5, Comparator<CLUSTER_OUTPUT_RECORD> comparator, SortingCollection.Codec<CLUSTER_OUTPUT_RECORD> codec, Class<CLUSTER_OUTPUT_RECORD> clazz, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, boolean bl3, boolean bl4, boolean bl5) {
        this.barcodeRecordWriterMap = map;
        this.demultiplex = bl;
        this.maxReadsInRamPerTile = n2;
        this.tmpDirs = list;
        this.outputRecordComparator = comparator;
        this.codecPrototype = codec;
        this.outputRecordClass = clazz;
        this.bclQualityEvaluationStrategy = bclQualityEvaluationStrategy;
        this.includeNonPfReads = bl4;
        this.ignoreUnexpectedBarcodes = bl5;
        if (bl2) {
            Timer timer = new Timer(true);
            this.gcTimerTask = new TimerTask(){

                @Override
                public void run() {
                    log.info(new Object[]{"Before explicit GC, Runtime.totalMemory()=" + Runtime.getRuntime().totalMemory()});
                    System.gc();
                    System.runFinalization();
                    log.info(new Object[]{"After explicit GC, Runtime.totalMemory()=" + Runtime.getRuntime().totalMemory()});
                }
            };
            timer.scheduleAtFixedRate(this.gcTimerTask, 300000L, 300000L);
        } else {
            this.gcTimerTask = null;
        }
        this.factory = new IlluminaDataProviderFactory(file, file2, n, readStructure, bclQualityEvaluationStrategy, IlluminaBasecallsConverter.getDataTypesFromReadStructure(readStructure, bl));
        this.factory.setApplyEamssFiltering(bl3);
        this.numThreads = n3 == 0 ? Runtime.getRuntime().availableProcessors() : (n3 < 0 ? Runtime.getRuntime().availableProcessors() + n3 : n3);
        this.tiles = new ArrayList<Integer>(this.factory.getAvailableTiles());
        Collections.sort(this.tiles, TILE_NUMBER_COMPARATOR);
        if (n4 != null) {
            for (int i = 0; i < this.tiles.size(); ++i) {
                if (this.tiles.get(i).intValue() != n4.intValue()) continue;
                this.tiles = this.tiles.subList(i, this.tiles.size());
                break;
            }
            if (this.tiles.get(0).intValue() != n4.intValue()) {
                throw new PicardException("firstTile=" + n4 + ", but that tile was not found.");
            }
        }
        if (n5 != null && this.tiles.size() > n5) {
            this.tiles = this.tiles.subList(0, n5);
        }
        this.numThreads = Math.max(1, Math.min(this.numThreads, this.tiles.size()));
    }

    public void setConverter(ClusterDataConverter<CLUSTER_OUTPUT_RECORD> clusterDataConverter) {
        this.converter = clusterDataConverter;
    }

    public IlluminaDataProviderFactory getFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doTileProcessing() {
        Object arrayList;
        try {
            FileChannelJDKBugWorkAround.doBugWorkAround();
            arrayList = new ArrayList<Tile>();
            for (Integer n : this.tiles) {
                arrayList.add((Tile)new Tile(n));
            }
            TileReadAggregator tileReadAggregator = new TileReadAggregator((Collection<Tile>)arrayList);
            tileReadAggregator.submit();
            try {
                tileReadAggregator.awaitWorkComplete();
            }
            catch (InterruptedException interruptedException) {
                log.error((Throwable)interruptedException, new Object[]{"Failure encountered in worker thread; attempting to shut down remaining worker threads and terminate ..."});
                throw new PicardException("Failure encountered in worker thread; see log for details.");
            }
            finally {
                tileReadAggregator.shutdown();
            }
            for (Map.Entry<Byte, Integer> entry : this.bclQualityEvaluationStrategy.getPoorQualityFrequencies().entrySet()) {
                log.warn(new Object[]{String.format("Observed low quality of %s %s times.", entry.getKey(), entry.getValue())});
            }
            this.bclQualityEvaluationStrategy.assertMinimumQualities();
        }
        catch (Throwable throwable) {
            try {
                if (this.gcTimerTask != null) {
                    this.gcTimerTask.cancel();
                }
            }
            catch (Throwable throwable2) {
                log.warn(throwable2, new Object[]{"Ignoring exception stopping background GC thread."});
            }
            Iterator<Map.Entry<String, ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD>>> iterator = this.barcodeRecordWriterMap.entrySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    throw throwable;
                }
                Map.Entry<String, ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD>> entry = iterator.next();
                ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD> convertedClusterDataWriter = entry.getValue();
                log.debug(new Object[]{String.format("Closing file for barcode %s.", entry.getKey())});
                convertedClusterDataWriter.close();
            }
        }
        try {
            if (this.gcTimerTask != null) {
                this.gcTimerTask.cancel();
            }
        }
        catch (Throwable throwable) {
            log.warn(throwable, new Object[]{"Ignoring exception stopping background GC thread."});
        }
        arrayList = this.barcodeRecordWriterMap.entrySet().iterator();
        while (arrayList.hasNext()) {
            Map.Entry entry = (Map.Entry)arrayList.next();
            ConvertedClusterDataWriter convertedClusterDataWriter = (ConvertedClusterDataWriter)entry.getValue();
            log.debug(new Object[]{String.format("Closing file for barcode %s.", entry.getKey())});
            convertedClusterDataWriter.close();
        }
        return;
    }

    private static IlluminaDataType[] getDataTypesFromReadStructure(ReadStructure readStructure, boolean bl) {
        if (readStructure.sampleBarcodes.isEmpty() || !bl) {
            return DATA_TYPES_NO_BARCODE;
        }
        return DATA_TYPES_WITH_BARCODE;
    }

    static /* synthetic */ int access$1400(IlluminaBasecallsConverter illuminaBasecallsConverter) {
        return illuminaBasecallsConverter.numThreads;
    }

    static {
        IlluminaBasecallsConverter.DATA_TYPES_WITH_BARCODE[IlluminaBasecallsConverter.DATA_TYPES_WITH_BARCODE.length - 1] = IlluminaDataType.Barcodes;
        TILE_NUMBER_COMPARATOR = new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                String string = n.toString();
                String string2 = n2.toString();
                if (string.length() < string2.length()) {
                    if (string2.startsWith(string)) {
                        return 1;
                    }
                } else if (string2.length() < string.length() && string.startsWith(string2)) {
                    return -1;
                }
                return string.compareTo(string2);
            }
        };
    }

    public static interface ConvertedClusterDataWriter<OUTPUT_RECORD> {
        public void write(OUTPUT_RECORD var1);

        public void close();
    }

    public static interface ClusterDataConverter<OUTPUT_RECORD> {
        public OUTPUT_RECORD convertClusterToOutputRecord(ClusterData var1);
    }

    private class TileReadAggregator {
        private final Map<Tile, TileProcessingRecord> tileRecords = new TreeMap<Tile, TileProcessingRecord>();
        private final ExecutorService prioritizingThreadPool = new ThreadPoolExecutor(IlluminaBasecallsConverter.access$1400(IlluminaBasecallsConverter.this), IlluminaBasecallsConverter.access$1400(IlluminaBasecallsConverter.this), 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(5, new Comparator<Runnable>(){

            @Override
            public int compare(Runnable runnable, Runnable runnable2) {
                return ((PriorityRunnable)runnable2).getPriority() - ((PriorityRunnable)runnable).getPriority();
            }
        }));
        private final Object completionLatch = new Object();
        private Thread parentThread;
        private final Object workEnqueueMonitor = new Object();
        private final AtomicBoolean submitted = new AtomicBoolean(false);

        public TileReadAggregator(Collection<Tile> collection) {
            for (Tile tile : collection) {
                this.tileRecords.put(tile, new TileProcessingRecord());
            }
        }

        public void submit() {
            if (!this.submitted.compareAndSet(false, true)) {
                throw new IllegalStateException("The submit() method may not be called more than once.");
            }
            this.parentThread = Thread.currentThread();
            int n = 0;
            for (Tile tile : this.tileRecords.keySet()) {
                final TileReader tileReader = new TileReader(tile, this, this.tileRecords.get(tile));
                this.prioritizingThreadPool.execute(new PriorityRunnable(--n){

                    @Override
                    public void run() {
                        try {
                            tileReader.process();
                        }
                        catch (RuntimeException runtimeException) {
                            TileReadAggregator.this.parentThread.interrupt();
                            throw runtimeException;
                        }
                        catch (Error error) {
                            TileReadAggregator.this.parentThread.interrupt();
                            throw error;
                        }
                    }
                });
            }
        }

        private void completeTile(Tile tile) {
            TileProcessingRecord tileProcessingRecord = this.tileRecords.get(tile);
            if (tileProcessingRecord.getState() == TileProcessingState.DONE_READING) {
                throw new IllegalStateException("This tile is already in the completed state.");
            }
            for (String string : tileProcessingRecord.getBarcodes()) {
                tileProcessingRecord.setBarcodeState(string, TileBarcodeProcessingState.READ);
                ((SortingCollection)tileProcessingRecord.barcodeToRecordCollection.get(string)).doneAdding();
            }
            tileProcessingRecord.setState(TileProcessingState.DONE_READING);
            log.debug(new Object[]{String.format("Completed reading tile %s; collected %s reads spanning %s barcodes.", tile.getNumber(), tileProcessingRecord.getRecordCount(), tileProcessingRecord.getBarcodeCount())});
            this.findAndEnqueueWorkOrSignalCompletion();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void awaitWorkComplete() throws InterruptedException {
            Object object = this.completionLatch;
            synchronized (object) {
                this.completionLatch.wait();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void signalWorkComplete() {
            Object object = this.completionLatch;
            synchronized (object) {
                this.completionLatch.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void findAndEnqueueWorkOrSignalCompletion() {
            Object object = this.workEnqueueMonitor;
            synchronized (object) {
                if (this.isWorkCompleted()) {
                    this.signalWorkComplete();
                } else {
                    LinkedList<PriorityRunnable> linkedList = new LinkedList<PriorityRunnable>();
                    block8: for (String object2 : IlluminaBasecallsConverter.this.barcodeRecordWriterMap.keySet()) {
                        block9: for (Map.Entry<Tile, TileProcessingRecord> entry : this.tileRecords.entrySet()) {
                            Tile tile = entry.getKey();
                            TileProcessingRecord tileProcessingRecord = entry.getValue();
                            if (tileProcessingRecord.getState() != TileProcessingState.DONE_READING) continue block8;
                            switch (tileProcessingRecord.getBarcodeState(object2)) {
                                case NA: 
                                case WRITTEN: {
                                    continue block9;
                                }
                                case QUEUED_FOR_WRITE: {
                                    continue block8;
                                }
                                case READ: {
                                    tileProcessingRecord.setBarcodeState(object2, TileBarcodeProcessingState.QUEUED_FOR_WRITE);
                                    log.debug(new Object[]{String.format("Enqueuing work for tile %s and barcode %s.", tile.getNumber(), object2)});
                                    linkedList.add(this.newBarcodeWorkInstance(tile, tileProcessingRecord, object2));
                                    continue block8;
                                }
                            }
                        }
                    }
                    for (Runnable runnable : linkedList) {
                        this.prioritizingThreadPool.execute(runnable);
                    }
                }
            }
        }

        private PriorityRunnable newBarcodeWorkInstance(final Tile tile, final TileProcessingRecord tileProcessingRecord, final String string) {
            return new PriorityRunnable(){

                @Override
                public void run() {
                    try {
                        SortingCollection sortingCollection = tileProcessingRecord.getBarcodeRecords().get(string);
                        ConvertedClusterDataWriter convertedClusterDataWriter = (ConvertedClusterDataWriter)IlluminaBasecallsConverter.this.barcodeRecordWriterMap.get(string);
                        log.debug(new Object[]{String.format("Writing records from tile %s with barcode %s ...", tile.getNumber(), string)});
                        PeekIterator peekIterator = new PeekIterator((Iterator)sortingCollection.iterator());
                        while (peekIterator.hasNext()) {
                            Object object = peekIterator.next();
                            if (peekIterator.hasNext()) {
                                Object object2 = peekIterator.peek();
                                if (IlluminaBasecallsConverter.this.outputRecordComparator.compare(object, object2) == 0) {
                                    peekIterator.next();
                                    log.info(new Object[]{"Skipping reads with identical read names: " + object.toString()});
                                    continue;
                                }
                            }
                            convertedClusterDataWriter.write(object);
                            IlluminaBasecallsConverter.this.writeProgressLogger.record(null, 0);
                        }
                        tileProcessingRecord.setBarcodeState(string, TileBarcodeProcessingState.WRITTEN);
                        TileReadAggregator.this.findAndEnqueueWorkOrSignalCompletion();
                    }
                    catch (RuntimeException runtimeException) {
                        TileReadAggregator.this.parentThread.interrupt();
                        throw runtimeException;
                    }
                    catch (Error error) {
                        TileReadAggregator.this.parentThread.interrupt();
                        throw error;
                    }
                }
            };
        }

        public boolean isWorkCompleted() {
            for (Map.Entry<Tile, TileProcessingRecord> entry : this.tileRecords.entrySet()) {
                TileProcessingRecord tileProcessingRecord = entry.getValue();
                if (tileProcessingRecord.getState() != TileProcessingState.DONE_READING) {
                    log.debug(new Object[]{String.format("Work is not completed because a tile isn't done being read: %s.", entry.getKey().getNumber())});
                    return false;
                }
                for (Map.Entry<String, TileBarcodeProcessingState> entry2 : tileProcessingRecord.getBarcodeProcessingStates().entrySet()) {
                    TileBarcodeProcessingState tileBarcodeProcessingState = entry2.getValue();
                    if (tileBarcodeProcessingState == TileBarcodeProcessingState.WRITTEN) continue;
                    log.debug(new Object[]{String.format("Work is not completed because a tile isn't done being read: Tile %s, Barcode %s, Processing State %s.", new Object[]{entry.getKey().getNumber(), entry2.getKey(), tileBarcodeProcessingState})});
                    return false;
                }
            }
            log.info(new Object[]{"All work is complete."});
            return true;
        }

        public void shutdown() {
            this.prioritizingThreadPool.shutdownNow();
        }
    }

    private class TileReader {
        private final Tile tile;
        private final TileReadAggregator handler;
        private final TileProcessingRecord processingRecord;

        public TileReader(Tile tile, TileReadAggregator tileReadAggregator, TileProcessingRecord tileProcessingRecord) {
            this.tile = tile;
            this.handler = tileReadAggregator;
            this.processingRecord = tileProcessingRecord;
        }

        public void process() {
            IlluminaDataProvider illuminaDataProvider = IlluminaBasecallsConverter.this.factory.makeDataProvider(Arrays.asList(this.tile.getNumber()));
            log.debug(new Object[]{String.format("Reading data from tile %s ...", this.tile.getNumber())});
            while (illuminaDataProvider.hasNext()) {
                ClusterData clusterData = illuminaDataProvider.next();
                IlluminaBasecallsConverter.this.readProgressLogger.record(null, 0);
                if (!clusterData.isPf().booleanValue() && !IlluminaBasecallsConverter.this.includeNonPfReads) continue;
                String string = IlluminaBasecallsConverter.this.demultiplex ? clusterData.getMatchedBarcode() : null;
                this.processingRecord.addRecord(string, IlluminaBasecallsConverter.this.converter.convertClusterToOutputRecord(clusterData));
            }
            this.handler.completeTile(this.tile);
            illuminaDataProvider.close();
        }
    }

    private class TileProcessingRecord {
        private final Map<String, SortingCollection<CLUSTER_OUTPUT_RECORD>> barcodeToRecordCollection = new HashMap();
        private final Map<String, TileBarcodeProcessingState> barcodeToProcessingState = new HashMap<String, TileBarcodeProcessingState>();
        private TileProcessingState state = TileProcessingState.NOT_DONE_READING;
        private long recordCount = 0L;

        private TileProcessingRecord() {
        }

        public synchronized TileProcessingState getState() {
            return this.state;
        }

        public synchronized void setState(TileProcessingState tileProcessingState) {
            this.state = tileProcessingState;
        }

        public synchronized void addRecord(String string, CLUSTER_OUTPUT_RECORD CLUSTER_OUTPUT_RECORD) {
            ++this.recordCount;
            SortingCollection sortingCollection = this.barcodeToRecordCollection.get(string);
            if (sortingCollection == null) {
                if (!IlluminaBasecallsConverter.this.barcodeRecordWriterMap.containsKey(string)) {
                    if (IlluminaBasecallsConverter.this.ignoreUnexpectedBarcodes) {
                        return;
                    }
                    throw new PicardException(String.format("Read records with barcode %s, but this barcode was not expected.  (Is it referenced in the parameters file?)", string));
                }
                sortingCollection = this.newSortingCollection();
                this.barcodeToRecordCollection.put(string, sortingCollection);
                this.barcodeToProcessingState.put(string, null);
            }
            sortingCollection.add(CLUSTER_OUTPUT_RECORD);
        }

        private synchronized SortingCollection<CLUSTER_OUTPUT_RECORD> newSortingCollection() {
            int n = Math.max(1, IlluminaBasecallsConverter.this.maxReadsInRamPerTile / IlluminaBasecallsConverter.this.barcodeRecordWriterMap.size());
            return SortingCollection.newInstance((Class)IlluminaBasecallsConverter.this.outputRecordClass, (SortingCollection.Codec)IlluminaBasecallsConverter.this.codecPrototype.clone(), (Comparator)IlluminaBasecallsConverter.this.outputRecordComparator, (int)n, (Collection)IlluminaBasecallsConverter.this.tmpDirs);
        }

        public synchronized long getBarcodeCount() {
            return this.barcodeToRecordCollection.size();
        }

        public synchronized long getRecordCount() {
            return this.recordCount;
        }

        public synchronized Map<String, SortingCollection<CLUSTER_OUTPUT_RECORD>> getBarcodeRecords() {
            return this.barcodeToRecordCollection;
        }

        public synchronized TileBarcodeProcessingState getBarcodeState(String string) {
            if (this.getState() == TileProcessingState.NOT_DONE_READING) {
                throw new IllegalStateException("A tile's barcode data's state cannot be queried until the tile has been completely read.");
            }
            if (this.barcodeToProcessingState.containsKey(string)) {
                return this.barcodeToProcessingState.get(string);
            }
            return TileBarcodeProcessingState.NA;
        }

        public synchronized Map<String, TileBarcodeProcessingState> getBarcodeProcessingStates() {
            return this.barcodeToProcessingState;
        }

        public synchronized void setBarcodeState(String string, TileBarcodeProcessingState tileBarcodeProcessingState) {
            if (!this.barcodeToProcessingState.containsKey(string)) {
                throw new NoSuchElementException(String.format("No record of the provided barcode, %s.", string));
            }
            this.barcodeToProcessingState.put(string, tileBarcodeProcessingState);
        }

        public synchronized Set<String> getBarcodes() {
            return this.getBarcodeRecords().keySet();
        }
    }

    private abstract class PriorityRunnable
    implements Runnable {
        private final int priority;

        public PriorityRunnable() {
            this(1);
        }

        public PriorityRunnable(int n) {
            this.priority = n;
        }

        int getPriority() {
            return this.priority;
        }
    }

    private static class Tile
    implements Comparable<Tile> {
        private final int tileNumber;

        public Tile(int n) {
            this.tileNumber = n;
        }

        public int getNumber() {
            return this.tileNumber;
        }

        public boolean equals(Object object) {
            return object instanceof Tile && this.getNumber() == ((Tile)object).getNumber();
        }

        @Override
        public int compareTo(Tile tile) {
            return TILE_NUMBER_COMPARATOR.compare(this.getNumber(), tile.getNumber());
        }
    }

    private static enum TileProcessingState {
        NOT_DONE_READING,
        DONE_READING;

    }

    private static enum TileBarcodeProcessingState {
        NA,
        READ,
        QUEUED_FOR_WRITE,
        WRITTEN;

    }
}

