/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Iso8601Date;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SortingCollection;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Illumina;
import picard.illumina.ClusterDataToSamConverter;
import picard.illumina.IlluminaBasecallsConverter;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import picard.util.IlluminaUtil;
import picard.util.TabbedTextFileWithHeaderParser;

@CommandLineProgramProperties(usage="Generate a SAM or BAM file from data in an Illumina basecalls output directory", usageShort="Generate a SAM or BAM file from data in an Illumina basecalls output directory", programGroup=Illumina.class)
public class IlluminaBasecallsToSam
extends CommandLineProgram {
    public static final String USAGE = "Generate a SAM or BAM file from data in an Illumina basecalls output directory";
    @Option(doc="The basecalls directory. ", shortName="B")
    public File BASECALLS_DIR;
    @Option(doc="The barcodes directory with _barcode.txt files (generated by ExtractIlluminaBarcodes). If not set, use BASECALLS_DIR. ", shortName="BCD", optional=true)
    public File BARCODES_DIR;
    @Option(doc="Lane number. ", shortName="L")
    public Integer LANE;
    @Option(doc="Deprecated (use LIBRARY_PARAMS).  The output SAM or BAM file. Format is determined by extension.", shortName="O", mutex={"BARCODE_PARAMS", "LIBRARY_PARAMS"})
    public File OUTPUT;
    @Option(doc="The barcode of the run.  Prefixed to read names.")
    public String RUN_BARCODE;
    @Option(doc="Deprecated (use LIBRARY_PARAMS).  The name of the sequenced sample", shortName="ALIAS", mutex={"BARCODE_PARAMS", "LIBRARY_PARAMS"})
    public String SAMPLE_ALIAS;
    @Option(doc="ID used to link RG header record with RG tag in SAM record.  If these are unique in SAM files that get merged, merge performance is better.  If not specified, READ_GROUP_ID will be set to <first 5 chars of RUN_BARCODE>.<LANE> .", shortName="RG", optional=true)
    public String READ_GROUP_ID;
    @Option(doc="Deprecated (use LIBRARY_PARAMS).  The name of the sequenced library", shortName="LIB", optional=true, mutex={"BARCODE_PARAMS", "LIBRARY_PARAMS"})
    public String LIBRARY_NAME;
    @Option(doc="The name of the sequencing center that produced the reads.  Used to set the RG.CN tag.", optional=true)
    public String SEQUENCING_CENTER = "BI";
    @Option(doc="The start date of the run.", optional=true)
    public Date RUN_START_DATE;
    @Option(doc="The name of the sequencing technology that produced the read.", optional=true)
    public String PLATFORM = "illumina";
    @Option(doc="A description of the logical structure of clusters in an Illumina Run, i.e. a description of the structure IlluminaBasecallsToSam assumes the  data to be in. It should consist of integer/character pairs describing the number of cycles and the type of those cycles (B for Sample Barcode, M for molecular barcode, T for Template, and S for skip).  E.g. If the input data consists of 80 base clusters and we provide a read structure of \"28T8M8B8S28T\" then the sequence may be split up into four reads:\n* read one with 28 cycles (bases) of template\n* read two with 8 cycles (bases) of molecular barcode (ex. unique molecular barcode)\n* read three with 8 cycles (bases) of sample barcode\n* 8 cycles (bases) skipped.\n* read four with 28 cycles (bases) of template\nThe skipped cycles would NOT be included in an output SAM/BAM file or in read groups therein.", shortName="RS")
    public String READ_STRUCTURE;
    @Option(doc="Deprecated (use LIBRARY_PARAMS).  Tab-separated file for creating all output BAMs for barcoded run with single IlluminaBasecallsToSam invocation.  Columns are BARCODE, OUTPUT, SAMPLE_ALIAS, and LIBRARY_NAME.  Row with BARCODE=N is used to specify a file for no barcode match", mutex={"OUTPUT", "SAMPLE_ALIAS", "LIBRARY_NAME", "LIBRARY_PARAMS"})
    public File BARCODE_PARAMS;
    @Option(doc="Tab-separated file for creating all output BAMs for a lane with single IlluminaBasecallsToSam invocation.  The columns are OUTPUT, SAMPLE_ALIAS, and LIBRARY_NAME, BARCODE_1, BARCODE_2 ... BARCODE_X where X = number of barcodes per cluster (optional).  Row with BARCODE_1 set to 'N' is used to specify a file for no barcode match.  You may also provide any 2 letter RG header attributes (excluding PU, CN, PL, and DT)  as columns in this file and the values for those columns will be inserted into the RG tag for the BAM file created for a given row.", mutex={"OUTPUT", "SAMPLE_ALIAS", "LIBRARY_NAME", "BARCODE_PARAMS"})
    public File LIBRARY_PARAMS;
    @Option(doc="Which adapters to look for in the read.")
    public List<IlluminaUtil.IlluminaAdapterPair> ADAPTERS_TO_CHECK = new ArrayList<IlluminaUtil.IlluminaAdapterPair>(Arrays.asList(IlluminaUtil.IlluminaAdapterPair.INDEXED, IlluminaUtil.IlluminaAdapterPair.DUAL_INDEXED, IlluminaUtil.IlluminaAdapterPair.NEXTERA_V2, IlluminaUtil.IlluminaAdapterPair.FLUIDIGM));
    @Option(doc="The number of threads to run in parallel. If NUM_PROCESSORS = 0, number of cores is automatically set to the number of cores available on the machine. If NUM_PROCESSORS < 0, then the number of cores used will be the number available on the machine less NUM_PROCESSORS.")
    public Integer NUM_PROCESSORS = 0;
    @Option(doc="If set, this is the first tile to be processed (used for debugging).  Note that tiles are not processed in numerical order.", optional=true)
    public Integer FIRST_TILE;
    @Option(doc="If set, process no more than this many tiles (used for debugging).", optional=true)
    public Integer TILE_LIMIT;
    @Option(doc="If true, call System.gc() periodically.  This is useful in cases in which the -Xmx value passed is larger than the available memory.")
    public Boolean FORCE_GC = true;
    @Option(doc="Apply EAMSS filtering to identify inappropriately quality scored bases towards the ends of reads and convert their quality scores to Q2.")
    public boolean APPLY_EAMSS_FILTER = true;
    @Option(doc="Configure SortingCollections to store this many records before spilling to disk. For an indexed run, each SortingCollection gets this value/number of indices.")
    public int MAX_READS_IN_RAM_PER_TILE = 1200000;
    @Option(doc="The minimum quality (after transforming 0s to 1s) expected from reads.  If qualities are lower than this value, an error is thrown.The default of 2 is what the Illumina's spec describes as the minimum, but in practice the value has been observed lower.")
    public int MINIMUM_QUALITY = 2;
    @Option(doc="Whether to include non-PF reads", shortName="NONPF", optional=true)
    public boolean INCLUDE_NON_PF_READS = true;
    @Option(doc="Whether to ignore reads whose barcodes are not found in LIBRARY_PARAMS.  Useful when outputting BAMs for only a subset of the barcodes in a lane.", shortName="INGORE_UNEXPECTED")
    public boolean IGNORE_UNEXPECTED_BARCODES = false;
    @Option(doc="The tag to use to store any molecular indexes.  If more than one molecular index is found, they will be concatenated and stored here.", optional=true)
    public String MOLECULAR_INDEX_TAG = "RX";
    @Option(doc="The tag to use to store any molecular index base qualities.  If more than one molecular index is found, their qualities will be concatenated and stored here (.i.e. the number of \"M\" operators in the READ_STRUCTURE)", optional=true)
    public String MOLECULAR_INDEX_BASE_QUALITY_TAG = "QX";
    @Option(doc="The list of tags to store each molecular index.  The number of tags should match the number of molecular indexes.", optional=true)
    public List<String> TAG_PER_MOLECULAR_INDEX;
    private final Map<String, SAMFileWriterWrapper> barcodeSamWriterMap = new HashMap<String, SAMFileWriterWrapper>();
    private ReadStructure readStructure;
    IlluminaBasecallsConverter<SAMRecordsForCluster> basecallsConverter;
    private static final Log log = Log.getInstance(IlluminaBasecallsToSam.class);
    private BclQualityEvaluationStrategy bclQualityEvaluationStrategy;

    @Override
    protected int doWork() {
        this.initialize();
        this.basecallsConverter.doTileProcessing();
        return 0;
    }

    private void initialize() {
        this.bclQualityEvaluationStrategy = new BclQualityEvaluationStrategy(this.MINIMUM_QUALITY);
        if (this.OUTPUT != null) {
            IOUtil.assertFileIsWritable((File)this.OUTPUT);
        }
        if (this.LIBRARY_PARAMS != null) {
            IOUtil.assertFileIsReadable((File)this.LIBRARY_PARAMS);
        }
        if (this.OUTPUT != null) {
            this.barcodeSamWriterMap.put(null, this.buildSamFileWriter(this.OUTPUT, this.SAMPLE_ALIAS, this.LIBRARY_NAME, this.buildSamHeaderParameters(null)));
        } else {
            this.populateWritersFromLibraryParams();
        }
        int n = this.readStructure.templates.length();
        this.basecallsConverter = new IlluminaBasecallsConverter<SAMRecordsForCluster>(this.BASECALLS_DIR, this.BARCODES_DIR, this.LANE, this.readStructure, this.barcodeSamWriterMap, true, this.MAX_READS_IN_RAM_PER_TILE / n, this.TMP_DIR, this.NUM_PROCESSORS, this.FORCE_GC, this.FIRST_TILE, this.TILE_LIMIT, new QueryNameComparator(), new Codec(n), SAMRecordsForCluster.class, this.bclQualityEvaluationStrategy, this.APPLY_EAMSS_FILTER, this.INCLUDE_NON_PF_READS, this.IGNORE_UNEXPECTED_BARCODES);
        log.info(new Object[]{"DONE_READING STRUCTURE IS " + this.readStructure.toString()});
        ClusterDataToSamConverter clusterDataToSamConverter = new ClusterDataToSamConverter(this.RUN_BARCODE, this.READ_GROUP_ID, this.basecallsConverter.getFactory().getOutputReadStructure(), this.ADAPTERS_TO_CHECK).withMolecularIndexTag(this.MOLECULAR_INDEX_TAG).withMolecularIndexQualityTag(this.MOLECULAR_INDEX_BASE_QUALITY_TAG).withTagPerMolecularIndex(this.TAG_PER_MOLECULAR_INDEX);
        this.basecallsConverter.setConverter(clusterDataToSamConverter);
    }

    private Set<String> findAndFilterExpectedColumns(Set<String> set, Set<String> set2) {
        HashSet<String> hashSet = new HashSet<String>(set2);
        hashSet.removeAll(set);
        if (!hashSet.isEmpty()) {
            throw new PicardException(String.format("LIBRARY_PARAMS file %s is missing the following columns: %s.", this.LIBRARY_PARAMS.getAbsolutePath(), StringUtil.join((String)", ", hashSet)));
        }
        HashSet<String> hashSet2 = new HashSet<String>(set);
        hashSet2.removeAll(set2);
        return hashSet2;
    }

    private void checkRgTagColumns(Set<String> set) {
        Set<String> set2 = this.buildSamHeaderParameters(null).keySet();
        set2.retainAll(set);
        if (!set2.isEmpty()) {
            throw new PicardException("Illegal ReadGroup tags in library params(barcode params) file(" + this.LIBRARY_PARAMS.getAbsolutePath() + ") Offending headers = " + StringUtil.join((String)", ", set2));
        }
        for (String string : set) {
            if (string.length() <= 2) continue;
            throw new PicardException("Column label (" + string + ") unrecognized.  Library params(barcode params) can only contain the columns " + "(OUTPUT, LIBRARY_NAME, SAMPLE_ALIAS, BARCODE, BARCODE_<X> where X is a positive integer) OR two letter RG tags!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void populateWritersFromLibraryParams() {
        TabbedTextFileWithHeaderParser tabbedTextFileWithHeaderParser = new TabbedTextFileWithHeaderParser(this.LIBRARY_PARAMS);
        Set set = CollectionUtil.makeSet((Object[])new String[]{"OUTPUT", "SAMPLE_ALIAS", "LIBRARY_NAME"});
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.readStructure.sampleBarcodes.length() == 1) {
            if (tabbedTextFileWithHeaderParser.hasColumn("BARCODE")) {
                arrayList.add("BARCODE");
            } else {
                if (!tabbedTextFileWithHeaderParser.hasColumn("BARCODE_1")) throw new PicardException("LIBRARY_PARAMS(BARCODE_PARAMS) file " + this.LIBRARY_PARAMS + " does not have column BARCODE or BARCODE_1.");
                arrayList.add("BARCODE_1");
            }
        } else {
            for (int i = 1; i <= this.readStructure.sampleBarcodes.length(); ++i) {
                arrayList.add("BARCODE_" + i);
            }
        }
        set.addAll(arrayList);
        Set<String> set2 = this.findAndFilterExpectedColumns(tabbedTextFileWithHeaderParser.columnLabels(), set);
        this.checkRgTagColumns(set2);
        for (TabbedTextFileWithHeaderParser.Row row : tabbedTextFileWithHeaderParser) {
            Object object;
            Iterator iterator;
            ArrayList<String> arrayList2 = null;
            if (!arrayList.isEmpty()) {
                arrayList2 = new ArrayList<String>();
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    arrayList2.add(row.getField((String)object));
                }
            }
            Iterator iterator2 = iterator = arrayList2 == null || arrayList2.contains("N") ? null : StringUtil.join((String)"", arrayList2);
            if (this.barcodeSamWriterMap.containsKey(iterator)) {
                throw new PicardException("Row for barcode " + iterator + " appears more than once in LIBRARY_PARAMS or BARCODE_PARAMS file " + this.LIBRARY_PARAMS);
            }
            object = this.buildSamHeaderParameters(arrayList2);
            for (String string : set2) {
                object.put(string, row.getField(string));
            }
            SAMFileWriterWrapper sAMFileWriterWrapper = this.buildSamFileWriter(new File(row.getField("OUTPUT")), row.getField("SAMPLE_ALIAS"), row.getField("LIBRARY_NAME"), (Map<String, String>)object);
            this.barcodeSamWriterMap.put((String)((Object)iterator), sAMFileWriterWrapper);
        }
        if (this.barcodeSamWriterMap.isEmpty()) {
            throw new PicardException("LIBRARY_PARAMS(BARCODE_PARAMS) file " + this.LIBRARY_PARAMS + " does have any data rows.");
        }
        tabbedTextFileWithHeaderParser.close();
    }

    private Map<String, String> buildSamHeaderParameters(List<String> list) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        String string = this.RUN_BARCODE + "." + this.LANE;
        if (list != null) {
            string = string + "." + IlluminaUtil.barcodeSeqsToString(list);
        }
        linkedHashMap.put("PL", this.PLATFORM);
        linkedHashMap.put("PU", string);
        linkedHashMap.put("CN", this.SEQUENCING_CENTER);
        linkedHashMap.put("DT", this.RUN_START_DATE == null ? null : new Iso8601Date(this.RUN_START_DATE).toString());
        return linkedHashMap;
    }

    private SAMFileWriterWrapper buildSamFileWriter(File file, String string, String string2, Map<String, String> map) {
        IOUtil.assertFileIsWritable((File)file);
        SAMReadGroupRecord sAMReadGroupRecord = new SAMReadGroupRecord(this.READ_GROUP_ID);
        sAMReadGroupRecord.setSample(string);
        if (string2 != null) {
            sAMReadGroupRecord.setLibrary(string2);
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            sAMReadGroupRecord.setAttribute(entry.getKey(), entry.getValue());
        }
        SAMFileHeader sAMFileHeader = new SAMFileHeader();
        sAMFileHeader.setSortOrder(SAMFileHeader.SortOrder.queryname);
        sAMFileHeader.addReadGroup(sAMReadGroupRecord);
        return new SAMFileWriterWrapper(new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileHeader, true, file));
    }

    public static void main(String[] stringArray) {
        System.exit(new IlluminaBasecallsToSam().instanceMain(stringArray));
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.BARCODE_PARAMS != null) {
            this.LIBRARY_PARAMS = this.BARCODE_PARAMS;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        this.readStructure = new ReadStructure(this.READ_STRUCTURE);
        if (!this.readStructure.sampleBarcodes.isEmpty() && this.LIBRARY_PARAMS == null) {
            arrayList.add("BARCODE_PARAMS or LIBRARY_PARAMS is missing.  If READ_STRUCTURE contains a B (barcode) then either LIBRARY_PARAMS or BARCODE_PARAMS(deprecated) must be provided!");
        }
        if (this.READ_GROUP_ID == null) {
            this.READ_GROUP_ID = this.RUN_BARCODE.substring(0, 5) + "." + this.LANE;
        }
        if (!this.TAG_PER_MOLECULAR_INDEX.isEmpty() && this.TAG_PER_MOLECULAR_INDEX.size() != this.readStructure.molecularBarcode.length()) {
            arrayList.add("The number of tags given in TAG_PER_MOLECULAR_INDEX does not match the number of molecular indexes in READ_STRUCTURE");
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static class Codec
    implements SortingCollection.Codec<SAMRecordsForCluster> {
        private final BAMRecordCodec bamCodec;
        private final int numRecords;

        Codec(int n, BAMRecordCodec bAMRecordCodec) {
            this.numRecords = n;
            this.bamCodec = bAMRecordCodec;
        }

        Codec(int n) {
            this(n, new BAMRecordCodec(null));
        }

        public void setOutputStream(OutputStream outputStream) {
            this.bamCodec.setOutputStream(outputStream);
        }

        public void setInputStream(InputStream inputStream) {
            this.bamCodec.setInputStream(inputStream);
        }

        public void encode(SAMRecordsForCluster sAMRecordsForCluster) {
            if (sAMRecordsForCluster.records.length != this.numRecords) {
                throw new IllegalStateException(String.format("Expected number of clusters %d != actual %d", this.numRecords, sAMRecordsForCluster.records.length));
            }
            for (SAMRecord sAMRecord : sAMRecordsForCluster.records) {
                this.bamCodec.encode(sAMRecord);
            }
        }

        public SAMRecordsForCluster decode() {
            SAMRecord sAMRecord = this.bamCodec.decode();
            if (sAMRecord == null) {
                return null;
            }
            SAMRecordsForCluster sAMRecordsForCluster = new SAMRecordsForCluster(this.numRecords);
            sAMRecordsForCluster.records[0] = sAMRecord;
            for (int i = 1; i < this.numRecords; ++i) {
                sAMRecordsForCluster.records[i] = this.bamCodec.decode();
                if (sAMRecordsForCluster.records[i] != null) continue;
                throw new IllegalStateException(String.format("Expected to read %d records but read only %d", this.numRecords, i));
            }
            return sAMRecordsForCluster;
        }

        public SortingCollection.Codec<SAMRecordsForCluster> clone() {
            return new Codec(this.numRecords, this.bamCodec.clone());
        }
    }

    static class QueryNameComparator
    implements Comparator<SAMRecordsForCluster> {
        private final SAMRecordQueryNameComparator comparator = new SAMRecordQueryNameComparator();

        QueryNameComparator() {
        }

        @Override
        public int compare(SAMRecordsForCluster sAMRecordsForCluster, SAMRecordsForCluster sAMRecordsForCluster2) {
            return this.comparator.compare(sAMRecordsForCluster.records[0], sAMRecordsForCluster2.records[0]);
        }
    }

    static class SAMRecordsForCluster {
        final SAMRecord[] records;

        SAMRecordsForCluster(int n) {
            this.records = new SAMRecord[n];
        }
    }

    private static final class SAMFileWriterWrapper
    implements IlluminaBasecallsConverter.ConvertedClusterDataWriter<SAMRecordsForCluster> {
        public final SAMFileWriter writer;

        private SAMFileWriterWrapper(SAMFileWriter sAMFileWriter) {
            this.writer = sAMFileWriter;
        }

        @Override
        public void write(SAMRecordsForCluster sAMRecordsForCluster) {
            for (SAMRecord sAMRecord : sAMRecordsForCluster.records) {
                this.writer.addAlignment(sAMRecord);
            }
        }

        @Override
        public void close() {
            this.writer.close();
        }
    }
}

