/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import picard.PicardException;
import picard.illumina.parser.BarcodeData;
import picard.illumina.parser.BaseData;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.FourChannelIntensityData;
import picard.illumina.parser.IlluminaDataType;
import picard.illumina.parser.IlluminaParser;
import picard.illumina.parser.NoiseData;
import picard.illumina.parser.OutputMapping;
import picard.illumina.parser.PfData;
import picard.illumina.parser.PositionalData;
import picard.illumina.parser.QualityData;
import picard.illumina.parser.RawIntensityData;
import picard.illumina.parser.ReadDescriptor;
import picard.illumina.parser.ReadType;

public class IlluminaDataProvider
implements Iterator<ClusterData>,
Iterable<ClusterData> {
    private final File basecallDirectory;
    private final int lane;
    private final IlluminaParser[] parsers;
    private final IlluminaDataType[][] dataTypes;
    private final ReadType[] outputReadTypes;
    private final int numReads;

    IlluminaDataProvider(OutputMapping outputMapping, Map<IlluminaParser, Set<IlluminaDataType>> map, File file, int n) {
        this.basecallDirectory = file;
        this.lane = n;
        this.numReads = outputMapping.numOutputReads();
        int n2 = map.size();
        if (n2 == 0) {
            throw new PicardException("There were 0 parsers passed to IlluminaDataProvider!");
        }
        int n3 = 0;
        this.parsers = new IlluminaParser[n2];
        this.dataTypes = new IlluminaDataType[n2][];
        for (Map.Entry<IlluminaParser, Set<IlluminaDataType>> object : map.entrySet()) {
            this.parsers[n3] = object.getKey();
            Set<IlluminaDataType> set = object.getValue();
            this.dataTypes[n3] = new IlluminaDataType[set.size()];
            set.toArray(this.dataTypes[n3++]);
        }
        this.outputReadTypes = new ReadType[this.numReads];
        n3 = 0;
        for (ReadDescriptor readDescriptor : outputMapping.getOutputDescriptors()) {
            this.outputReadTypes[n3++] = readDescriptor.type;
        }
    }

    @Override
    public boolean hasNext() {
        boolean bl = this.parsers[0].hasNext();
        if (!bl) {
            for (int i = 1; i < this.parsers.length; ++i) {
                if (!this.parsers[i].hasNext()) continue;
                throw new PicardException("Unequal length Illumina files in " + this.basecallDirectory + ", lane " + this.lane + ". Failing parser: " + this.parsers[i].getClass().getName());
            }
        }
        return bl;
    }

    @Override
    public ClusterData next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ClusterData clusterData = new ClusterData(this.outputReadTypes);
        clusterData.setLane(this.lane);
        clusterData.setTile(this.parsers[0].getTileOfNextCluster());
        for (int i = 0; i < this.parsers.length; ++i) {
            Object object = this.parsers[i].next();
            block8: for (IlluminaDataType illuminaDataType : this.dataTypes[i]) {
                switch (illuminaDataType) {
                    case Position: {
                        this.addData(clusterData, (PositionalData)object);
                        continue block8;
                    }
                    case PF: {
                        this.addData(clusterData, (PfData)object);
                        continue block8;
                    }
                    case Barcodes: {
                        this.addData(clusterData, (BarcodeData)object);
                        continue block8;
                    }
                    case BaseCalls: {
                        this.addReadData(clusterData, this.numReads, (BaseData)object);
                        continue block8;
                    }
                    case QualityScores: {
                        this.addReadData(clusterData, this.numReads, (QualityData)object);
                        continue block8;
                    }
                    default: {
                        throw new PicardException("Unknown data type " + (Object)((Object)illuminaDataType) + " requested by IlluminaDataProviderFactory");
                    }
                }
            }
        }
        return clusterData;
    }

    private void addData(ClusterData clusterData, PositionalData positionalData) {
        clusterData.setX(positionalData.getXCoordinate());
        clusterData.setY(positionalData.getYCoordinate());
    }

    private void addData(ClusterData clusterData, PfData pfData) {
        clusterData.setPf(pfData.isPf());
    }

    private void addData(ClusterData clusterData, BarcodeData barcodeData) {
        clusterData.setMatchedBarcode(barcodeData.getBarcode());
    }

    private void addReadData(ClusterData clusterData, int n, BaseData baseData) {
        byte[][] byArray = baseData.getBases();
        for (int i = 0; i < n; ++i) {
            clusterData.getRead(i).setBases(byArray[i]);
        }
    }

    private void addReadData(ClusterData clusterData, int n, QualityData qualityData) {
        byte[][] byArray = qualityData.getQualities();
        for (int i = 0; i < n; ++i) {
            clusterData.getRead(i).setQualities(byArray[i]);
        }
    }

    private void addReadData(ClusterData clusterData, int n, RawIntensityData rawIntensityData) {
        FourChannelIntensityData[] fourChannelIntensityDataArray = rawIntensityData.getRawIntensities();
        for (int i = 0; i < n; ++i) {
            clusterData.getRead(i).setRawIntensities(fourChannelIntensityDataArray[i]);
        }
    }

    private void addReadData(ClusterData clusterData, int n, NoiseData noiseData) {
        FourChannelIntensityData[] fourChannelIntensityDataArray = noiseData.getNoise();
        for (int i = 0; i < n; ++i) {
            clusterData.getRead(i).setNoise(fourChannelIntensityDataArray[i]);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void seekToTile(int n) {
        for (IlluminaParser illuminaParser : this.parsers) {
            illuminaParser.seekToTile(n);
        }
    }

    @Override
    public Iterator<ClusterData> iterator() {
        return this;
    }

    public void close() {
        for (IlluminaParser illuminaParser : this.parsers) {
            illuminaParser.close();
        }
    }
}

