/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import picard.PicardException;
import picard.illumina.parser.BarcodeData;
import picard.illumina.parser.BarcodeParser;
import picard.illumina.parser.BclParser;
import picard.illumina.parser.CycleIlluminaFileMap;
import picard.illumina.parser.FilterParser;
import picard.illumina.parser.IlluminaDataProvider;
import picard.illumina.parser.IlluminaDataType;
import picard.illumina.parser.IlluminaFileMap;
import picard.illumina.parser.IlluminaFileUtil;
import picard.illumina.parser.IlluminaParser;
import picard.illumina.parser.MultiTileBclFileUtil;
import picard.illumina.parser.MultiTileBclParser;
import picard.illumina.parser.MultiTileFilterFileUtil;
import picard.illumina.parser.MultiTileLocsFileUtil;
import picard.illumina.parser.OutputMapping;
import picard.illumina.parser.PerTileFileUtil;
import picard.illumina.parser.PerTilePerCycleFileUtil;
import picard.illumina.parser.PosParser;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;

public class IlluminaDataProviderFactory {
    private static final Log log = Log.getInstance(IlluminaDataProviderFactory.class);
    private static final Map<IlluminaDataType, List<IlluminaFileUtil.SupportedIlluminaFormat>> DATA_TYPE_TO_PREFERRED_FORMATS = new HashMap<IlluminaDataType, List<IlluminaFileUtil.SupportedIlluminaFormat>>();
    private final File basecallDirectory;
    private final File barcodesDirectory;
    private final int lane;
    private boolean applyEamssFiltering = true;
    protected final Map<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>> formatToDataTypes;
    private final IlluminaFileUtil fileUtil;
    private final List<Integer> availableTiles;
    private final OutputMapping outputMapping;
    private final BclQualityEvaluationStrategy bclQualityEvaluationStrategy;

    public IlluminaDataProviderFactory(File file, int n, ReadStructure readStructure, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, IlluminaDataType ... illuminaDataTypeArray) {
        this(file, null, n, readStructure, bclQualityEvaluationStrategy, illuminaDataTypeArray);
    }

    public IlluminaDataProviderFactory(File file, File file2, int n, ReadStructure readStructure, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, IlluminaDataType ... illuminaDataTypeArray) {
        this.basecallDirectory = file;
        this.barcodesDirectory = file2;
        this.bclQualityEvaluationStrategy = bclQualityEvaluationStrategy;
        this.lane = n;
        Set<IlluminaDataType> set = Collections.unmodifiableSet(new HashSet<IlluminaDataType>(Arrays.asList(illuminaDataTypeArray)));
        if (set.isEmpty()) {
            throw new PicardException("No data types have been specified for basecall output " + file + ", lane " + n);
        }
        this.fileUtil = new IlluminaFileUtil(file, file2, n);
        this.formatToDataTypes = IlluminaDataProviderFactory.determineFormats(set, this.fileUtil);
        Set<IlluminaDataType> set2 = IlluminaDataProviderFactory.findUnmatchedTypes(set, this.formatToDataTypes);
        if (!set2.isEmpty()) {
            throw new PicardException("Could not find a format with available files for the following data types: " + StringUtil.join((String)", ", new ArrayList<IlluminaDataType>(set2)));
        }
        log.debug(new Object[]{"The following file formats will be used by IlluminaDataProvider: " + StringUtil.join((String)("," + this.formatToDataTypes.keySet()), (Object[])new Object[0])});
        this.availableTiles = this.fileUtil.getActualTiles(new ArrayList<IlluminaFileUtil.SupportedIlluminaFormat>(this.formatToDataTypes.keySet()));
        if (this.availableTiles.isEmpty()) {
            throw new PicardException("No available tiles were found, make sure that " + file.getAbsolutePath() + " has a lane " + n);
        }
        this.outputMapping = new OutputMapping(readStructure);
    }

    public ReadStructure getOutputReadStructure() {
        return this.outputMapping.getOutputReadStructure();
    }

    public List<Integer> getAvailableTiles() {
        return this.availableTiles;
    }

    public void setApplyEamssFiltering(boolean bl) {
        this.applyEamssFiltering = bl;
    }

    public IlluminaDataProvider makeDataProvider() {
        return this.makeDataProvider(null);
    }

    public IlluminaDataProvider makeDataProvider(List<Integer> list) {
        if (list == null) {
            list = this.availableTiles;
        } else if (list.isEmpty()) {
            throw new PicardException("Zero length tile list supplied to makeDataProvider, you must specify at least 1 tile OR pass NULL to use all available tiles");
        }
        HashMap<IlluminaParser, Set<IlluminaDataType>> hashMap = new HashMap<IlluminaParser, Set<IlluminaDataType>>();
        for (Map.Entry<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>> entry : this.formatToDataTypes.entrySet()) {
            hashMap.put(this.makeParser(entry.getKey(), list), entry.getValue());
        }
        log.debug(new Object[]{"The following parsers will be used by IlluminaDataProvider: " + StringUtil.join((String)("," + hashMap.keySet()), (Object[])new Object[0])});
        return new IlluminaDataProvider(this.outputMapping, hashMap, this.basecallDirectory, this.lane);
    }

    public static Set<IlluminaDataType> findUnmatchedTypes(Set<IlluminaDataType> set, Map<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>> map) {
        HashSet<IlluminaDataType> hashSet = new HashSet<IlluminaDataType>(set);
        for (Set<IlluminaDataType> set2 : map.values()) {
            hashSet.removeAll(set2);
        }
        return hashSet;
    }

    public static Map<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>> determineFormats(Set<IlluminaDataType> set, IlluminaFileUtil illuminaFileUtil) {
        IlluminaFileUtil.SupportedIlluminaFormat supportedIlluminaFormat;
        TreeSet<IlluminaDataType> treeSet = new TreeSet<IlluminaDataType>(set);
        HashMap<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>> hashMap = new HashMap<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>>();
        HashMap<IlluminaDataType, IlluminaFileUtil.SupportedIlluminaFormat> hashMap2 = new HashMap<IlluminaDataType, IlluminaFileUtil.SupportedIlluminaFormat>();
        for (IlluminaDataType illuminaDataType : treeSet) {
            supportedIlluminaFormat = IlluminaDataProviderFactory.findPreferredAvailableFormat(illuminaDataType, illuminaFileUtil);
            if (supportedIlluminaFormat == null) continue;
            hashMap2.put(illuminaDataType, supportedIlluminaFormat);
        }
        for (IlluminaDataType illuminaDataType : treeSet) {
            supportedIlluminaFormat = (IlluminaFileUtil.SupportedIlluminaFormat)((Object)hashMap2.get((Object)illuminaDataType));
            if (supportedIlluminaFormat == null) continue;
            if (hashMap.containsKey((Object)supportedIlluminaFormat)) {
                ((Set)hashMap.get((Object)supportedIlluminaFormat)).add(illuminaDataType);
                continue;
            }
            hashMap.put((IlluminaFileUtil.SupportedIlluminaFormat)((Object)hashMap2.get((Object)illuminaDataType)), CollectionUtil.makeSet((Object[])new IlluminaDataType[]{illuminaDataType}));
        }
        return hashMap;
    }

    private static IlluminaFileUtil.SupportedIlluminaFormat findPreferredAvailableFormat(IlluminaDataType illuminaDataType, IlluminaFileUtil illuminaFileUtil) {
        return IlluminaDataProviderFactory.findPreferredFormat(illuminaDataType, illuminaFileUtil, true);
    }

    public static IlluminaFileUtil.SupportedIlluminaFormat findPreferredFormat(IlluminaDataType illuminaDataType, IlluminaFileUtil illuminaFileUtil) {
        return IlluminaDataProviderFactory.findPreferredFormat(illuminaDataType, illuminaFileUtil, false);
    }

    private static IlluminaFileUtil.SupportedIlluminaFormat findPreferredFormat(IlluminaDataType illuminaDataType, IlluminaFileUtil illuminaFileUtil, boolean bl) {
        List<IlluminaFileUtil.SupportedIlluminaFormat> list = DATA_TYPE_TO_PREFERRED_FORMATS.get((Object)illuminaDataType);
        IlluminaFileUtil.SupportedIlluminaFormat supportedIlluminaFormat = null;
        for (int i = 0; i < list.size() && supportedIlluminaFormat == null; ++i) {
            if (bl && illuminaFileUtil.getUtil(list.get(i)).filesAvailable()) {
                supportedIlluminaFormat = list.get(i);
                continue;
            }
            if (bl) continue;
            supportedIlluminaFormat = list.get(i);
        }
        return supportedIlluminaFormat;
    }

    private IlluminaParser makeParser(IlluminaFileUtil.SupportedIlluminaFormat supportedIlluminaFormat, List<Integer> list) {
        IlluminaParser<BarcodeData> illuminaParser;
        switch (supportedIlluminaFormat) {
            case Barcode: {
                illuminaParser = new BarcodeParser(((PerTileFileUtil)this.fileUtil.getUtil(IlluminaFileUtil.SupportedIlluminaFormat.Barcode)).getFiles(list));
                break;
            }
            case Bcl: {
                CycleIlluminaFileMap cycleIlluminaFileMap = ((PerTilePerCycleFileUtil)this.fileUtil.getUtil(IlluminaFileUtil.SupportedIlluminaFormat.Bcl)).getFiles(list, this.outputMapping.getOutputCycles());
                cycleIlluminaFileMap.assertValid(list, this.outputMapping.getOutputCycles());
                illuminaParser = new BclParser(this.basecallDirectory, this.lane, cycleIlluminaFileMap, this.outputMapping, this.applyEamssFiltering, this.bclQualityEvaluationStrategy);
                break;
            }
            case Filter: {
                IlluminaFileMap illuminaFileMap = ((PerTileFileUtil)this.fileUtil.getUtil(IlluminaFileUtil.SupportedIlluminaFormat.Filter)).getFiles(list);
                illuminaParser = new FilterParser(illuminaFileMap);
                break;
            }
            case Locs: 
            case Clocs: 
            case Pos: {
                PerTileFileUtil perTileFileUtil = (PerTileFileUtil)this.fileUtil.getUtil(supportedIlluminaFormat);
                illuminaParser = new PosParser(perTileFileUtil.getFiles(list), supportedIlluminaFormat);
                break;
            }
            case MultiTileFilter: {
                illuminaParser = ((MultiTileFilterFileUtil)this.fileUtil.getUtil(IlluminaFileUtil.SupportedIlluminaFormat.MultiTileFilter)).makeParser(list);
                break;
            }
            case MultiTileLocs: {
                illuminaParser = ((MultiTileLocsFileUtil)this.fileUtil.getUtil(IlluminaFileUtil.SupportedIlluminaFormat.MultiTileLocs)).makeParser(list);
                break;
            }
            case MultiTileBcl: {
                MultiTileBclFileUtil multiTileBclFileUtil = (MultiTileBclFileUtil)this.fileUtil.getUtil(IlluminaFileUtil.SupportedIlluminaFormat.MultiTileBcl);
                CycleIlluminaFileMap cycleIlluminaFileMap = multiTileBclFileUtil.getFiles(list, this.outputMapping.getOutputCycles());
                cycleIlluminaFileMap.assertValid(list, this.outputMapping.getOutputCycles());
                illuminaParser = new MultiTileBclParser(this.basecallDirectory, this.lane, cycleIlluminaFileMap, this.outputMapping, this.applyEamssFiltering, this.bclQualityEvaluationStrategy, multiTileBclFileUtil.tileIndex);
                break;
            }
            default: {
                throw new PicardException("Unrecognized data type(" + (Object)((Object)supportedIlluminaFormat) + ") found by IlluminaDataProviderFactory!");
            }
        }
        return illuminaParser;
    }

    static {
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.BaseCalls, CollectionUtil.makeList((Object[])new IlluminaFileUtil.SupportedIlluminaFormat[]{IlluminaFileUtil.SupportedIlluminaFormat.MultiTileBcl, IlluminaFileUtil.SupportedIlluminaFormat.Bcl}));
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.QualityScores, CollectionUtil.makeList((Object[])new IlluminaFileUtil.SupportedIlluminaFormat[]{IlluminaFileUtil.SupportedIlluminaFormat.MultiTileBcl, IlluminaFileUtil.SupportedIlluminaFormat.Bcl}));
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.PF, CollectionUtil.makeList((Object[])new IlluminaFileUtil.SupportedIlluminaFormat[]{IlluminaFileUtil.SupportedIlluminaFormat.MultiTileFilter, IlluminaFileUtil.SupportedIlluminaFormat.Filter}));
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.Position, CollectionUtil.makeList((Object[])new IlluminaFileUtil.SupportedIlluminaFormat[]{IlluminaFileUtil.SupportedIlluminaFormat.MultiTileLocs, IlluminaFileUtil.SupportedIlluminaFormat.Locs, IlluminaFileUtil.SupportedIlluminaFormat.Clocs, IlluminaFileUtil.SupportedIlluminaFormat.Pos}));
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.Barcodes, CollectionUtil.makeList((Object[])new IlluminaFileUtil.SupportedIlluminaFormat[]{IlluminaFileUtil.SupportedIlluminaFormat.Barcode}));
    }
}

