/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

public enum IlluminaMetricsCode {
    DENSITY_ID(100),
    CLUSTER_ID(102),
    PHASING_BASE(200),
    PREPHASING_BASE(201);

    private final int metricsCode;

    private IlluminaMetricsCode(int n2) {
        this.metricsCode = n2;
    }

    public static int getPhasingCode(int n, IlluminaMetricsCode illuminaMetricsCode) {
        if (!IlluminaMetricsCode.isPhasing(illuminaMetricsCode)) {
            throw new IllegalArgumentException("phasingType must be PHASING_BASE or PREPHASING_BASE");
        }
        return illuminaMetricsCode.getMetricsCode() + n * 2;
    }

    public static boolean isPhasing(IlluminaMetricsCode illuminaMetricsCode) {
        return illuminaMetricsCode.equals((Object)PHASING_BASE) || illuminaMetricsCode.equals((Object)PREPHASING_BASE);
    }

    public int getMetricsCode() {
        return this.metricsCode;
    }
}

