/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import picard.illumina.parser.IlluminaFileMap;
import picard.illumina.parser.IlluminaFileUtil;
import picard.illumina.parser.ParameterizedFileUtil;
import picard.illumina.parser.fakers.FileFaker;

public class PerTileFileUtil
extends ParameterizedFileUtil {
    private final IlluminaFileMap fileMap;

    public PerTileFileUtil(String string, File file, FileFaker fileFaker, int n) {
        this(string, file, fileFaker, n, true);
    }

    public PerTileFileUtil(String string, File file, FileFaker fileFaker, int n, boolean bl) {
        super(true, string, file, fileFaker, n, bl);
        this.fileMap = this.getTiledFiles(file, this.matchPattern);
        this.tiles = !this.fileMap.isEmpty() ? Collections.unmodifiableList(new ArrayList(this.fileMap.keySet())) : new ArrayList();
    }

    @Override
    public boolean filesAvailable() {
        return !this.fileMap.isEmpty();
    }

    public IlluminaFileMap getFiles() {
        return this.fileMap;
    }

    public IlluminaFileMap getFiles(List<Integer> list) {
        return this.fileMap.keep(list);
    }

    @Override
    public List<String> verify(List<Integer> list, int[] nArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (!this.base.exists()) {
            linkedList.add("Base directory(" + this.base.getAbsolutePath() + ") does not exist!");
        } else if (!this.tiles.containsAll(list)) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(list);
            arrayList.removeAll(this.tiles);
            linkedList.add("Missing tile " + arrayList + " for file type " + this.extension + ".");
        }
        return linkedList;
    }

    @Override
    public List<String> fakeFiles(List<Integer> list, int[] nArray, IlluminaFileUtil.SupportedIlluminaFormat supportedIlluminaFormat) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (!this.base.exists()) {
            linkedList.add("Base directory(" + this.base.getAbsolutePath() + ") does not exist!");
        } else {
            for (Integer n : list) {
                if (this.tiles.contains(n) && ((File)this.fileMap.get(n)).length() != 0L) continue;
                try {
                    this.faker.fakeFile(this.base, n, this.lane, this.extension);
                }
                catch (IOException iOException) {
                    linkedList.add(String.format("Could not create fake file %s: %s", this.fileMap.get(n), iOException.getMessage()));
                }
            }
        }
        return linkedList;
    }
}

