/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CollectionUtil;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import picard.PicardException;
import picard.illumina.parser.IlluminaDataType;
import picard.illumina.parser.IlluminaFileMap;
import picard.illumina.parser.IlluminaFileUtil;
import picard.illumina.parser.PerTileParser;
import picard.illumina.parser.PositionalData;
import picard.illumina.parser.readers.AbstractIlluminaPositionFileReader;
import picard.illumina.parser.readers.ClocsFileReader;
import picard.illumina.parser.readers.LocsFileReader;
import picard.illumina.parser.readers.PosFileReader;

public class PosParser
extends PerTileParser<PositionalData> {
    private static Set<IlluminaDataType> supportedTypes = Collections.unmodifiableSet(CollectionUtil.makeSet((Object[])new IlluminaDataType[]{IlluminaDataType.Position}));
    private final IlluminaFileUtil.SupportedIlluminaFormat fileType;

    public PosParser(IlluminaFileMap illuminaFileMap, IlluminaFileUtil.SupportedIlluminaFormat supportedIlluminaFormat) {
        super(illuminaFileMap);
        this.fileType = supportedIlluminaFormat;
    }

    public PosParser(IlluminaFileMap illuminaFileMap, int n, IlluminaFileUtil.SupportedIlluminaFormat supportedIlluminaFormat) {
        super(illuminaFileMap, n);
        this.fileType = supportedIlluminaFormat;
    }

    @Override
    protected CloseableIterator<PositionalData> makeTileIterator(File file) {
        AbstractIlluminaPositionFileReader abstractIlluminaPositionFileReader;
        switch (this.fileType) {
            case Pos: {
                abstractIlluminaPositionFileReader = new PosFileReader(file);
                break;
            }
            case Locs: {
                abstractIlluminaPositionFileReader = new LocsFileReader(file);
                break;
            }
            case Clocs: {
                abstractIlluminaPositionFileReader = new ClocsFileReader(file);
                break;
            }
            default: {
                throw new PicardException("Unrecognized pos file type " + this.fileType.name());
            }
        }
        return new CloseableIterator<PositionalData>(){
            private AbstractIlluminaPositionFileReader reader;
            {
                this.reader = abstractIlluminaPositionFileReader;
            }

            public void close() {
                this.reader.close();
            }

            public boolean hasNext() {
                return this.reader.hasNext();
            }

            public PositionalData next() {
                final AbstractIlluminaPositionFileReader.PositionInfo positionInfo = this.reader.next();
                return new PositionalData(){

                    @Override
                    public int getXCoordinate() {
                        return positionInfo.xQseqCoord;
                    }

                    @Override
                    public int getYCoordinate() {
                        return positionInfo.yQseqCoord;
                    }

                    public int getLane() {
                        return positionInfo.lane;
                    }

                    public int getTile() {
                        return positionInfo.tile;
                    }
                };
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Set<IlluminaDataType> supportedTypes() {
        return supportedTypes;
    }
}

