/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser.readers;

import java.io.File;
import java.nio.ByteBuffer;
import picard.PicardException;
import picard.illumina.parser.readers.BinaryFileIterator;
import picard.illumina.parser.readers.MMapBackedIteratorFactory;

public class BclIndexReader {
    private static final int BCI_HEADER_SIZE = 8;
    private static final int BCI_VERSION = 0;
    private final BinaryFileIterator<Long> bciIterator;
    private final int numTiles;
    private final File bciFile;
    private int nextRecordNumber = 0;

    public BclIndexReader(File file) {
        this.bciFile = new File(file.getAbsolutePath() + ".bci");
        this.bciIterator = MMapBackedIteratorFactory.getLongIterator(8, this.bciFile);
        ByteBuffer byteBuffer = this.bciIterator.getHeaderBytes();
        int n = byteBuffer.getInt();
        if (n != 0) {
            throw new PicardException(String.format("Unexpected version number %d in %s", n, this.bciFile.getAbsolutePath()));
        }
        this.numTiles = byteBuffer.getInt();
    }

    public int getNumTiles() {
        return this.numTiles;
    }

    public long get(int n) {
        if (n < this.nextRecordNumber) {
            throw new IllegalArgumentException("Can only read forward");
        }
        if (n > this.nextRecordNumber) {
            this.bciIterator.skipElements(n - this.nextRecordNumber);
            this.nextRecordNumber = n;
        }
        ++this.nextRecordNumber;
        return this.bciIterator.getElement();
    }

    public File getBciFile() {
        return this.bciFile;
    }
}

