/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser.readers;

import htsjdk.samtools.util.CollectionUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import picard.PicardException;

public class BclQualityEvaluationStrategy {
    public static final int ILLUMINA_ALLEGED_MINIMUM_QUALITY = 2;
    private final int minimumRevisedQuality;
    private final Map<Byte, AtomicInteger> qualityCountMap = Collections.synchronizedMap(new CollectionUtil.DefaultingMap((CollectionUtil.DefaultingMap.Factory)new CollectionUtil.DefaultingMap.Factory<AtomicInteger, Byte>(){

        public AtomicInteger make(Byte by) {
            return new AtomicInteger(0);
        }
    }, true));

    public BclQualityEvaluationStrategy(int n) {
        this.minimumRevisedQuality = n;
    }

    private static byte generateRevisedQuality(byte by) {
        return (byte)Math.max(by, 1);
    }

    public byte reviseAndConditionallyLogQuality(byte by) {
        byte by2 = BclQualityEvaluationStrategy.generateRevisedQuality(by);
        if (by < 2) {
            this.qualityCountMap.get(by).incrementAndGet();
        }
        return by2;
    }

    public void assertMinimumQualities() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Map.Entry<Byte, AtomicInteger> entry : this.qualityCountMap.entrySet()) {
            if (BclQualityEvaluationStrategy.generateRevisedQuality(entry.getKey()) >= this.minimumRevisedQuality) continue;
            linkedList.add(String.format("quality %s observed %s times", entry.getKey(), entry.getValue()));
        }
        if (!linkedList.isEmpty()) {
            throw new PicardException(String.format("Found BCL qualities that fell beneath minimum threshold of %s: %s.", this.minimumRevisedQuality, CollectionUtil.join(linkedList, (String)"; ")));
        }
    }

    public Map<Byte, Integer> getPoorQualityFrequencies() {
        HashMap<Byte, Integer> hashMap = new HashMap<Byte, Integer>();
        for (Map.Entry<Byte, AtomicInteger> entry : this.qualityCountMap.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().intValue());
        }
        return Collections.unmodifiableMap(hashMap);
    }
}

