/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser.readers;

import htsjdk.samtools.util.CloserUtil;
import java.io.File;
import picard.PicardException;
import picard.illumina.parser.readers.AbstractIlluminaPositionFileReader;
import picard.util.BasicInputParser;

public class PosFileReader
extends AbstractIlluminaPositionFileReader {
    private final BasicInputParser parser;

    public PosFileReader(File file) {
        super(file);
        this.parser = new BasicInputParser(true, file);
    }

    @Override
    protected AbstractIlluminaPositionFileReader.PositionInfo unsafeNextInfo() {
        String[] stringArray = (String[])this.parser.next();
        if (stringArray.length != 2) {
            throw new PicardException("Pos file number of values != 2, found (" + stringArray.length + ")" + this.makeExceptionMsg());
        }
        try {
            float f = Float.parseFloat(stringArray[0]);
            float f2 = Float.parseFloat(stringArray[1]);
            if (f < 0.0f || f2 < 0.0f) {
                throw new NumberFormatException("X and Y pos values cannot be negative!");
            }
            return new AbstractIlluminaPositionFileReader.PositionInfo(f, f2, this.getLane(), this.getTile());
        }
        catch (NumberFormatException numberFormatException) {
            throw new PicardException("Bad x or y value in " + this.makeExceptionMsg(), numberFormatException);
        }
    }

    @Override
    protected String makeExceptionMsg() {
        return "pos file( " + this.parser.getFileName() + " ) on line number( " + this.parser.getCurrentLineNumber() + " ) with current line = " + this.parser.getCurrentLine();
    }

    @Override
    public boolean hasNext() {
        return this.parser.hasNext();
    }

    public void close() {
        CloserUtil.close((Object)this.parser);
    }
}

