/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser.readers;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import picard.PicardException;
import picard.illumina.parser.readers.BinaryFileIterator;
import picard.illumina.parser.readers.MMapBackedIteratorFactory;
import picard.util.UnsignedTypeUtil;

public class TileMetricsOutReader
implements Iterator<IlluminaTileMetrics> {
    private static final int HEADER_SIZE = 2;
    private static final int EXPECTED_RECORD_SIZE = 10;
    private static final int EXPECTED_VERSION = 2;
    private final BinaryFileIterator<ByteBuffer> bbIterator;

    public TileMetricsOutReader(File file) {
        this.bbIterator = MMapBackedIteratorFactory.getByteBufferIterator(2, 10, file);
        ByteBuffer byteBuffer = this.bbIterator.getHeaderBytes();
        int n = UnsignedTypeUtil.uByteToInt(byteBuffer.get());
        if (n != 2) {
            throw new PicardException("TileMetricsOutReader expects the version number to be 2.  Actual Version in Header( " + n + ")");
        }
        int n2 = UnsignedTypeUtil.uByteToInt(byteBuffer.get());
        if (10 != n2) {
            throw new PicardException("TileMetricsOutReader expects the record size to be 10.  Actual Record Size in Header( " + n2 + ")");
        }
    }

    @Override
    public boolean hasNext() {
        return this.bbIterator.hasNext();
    }

    @Override
    public IlluminaTileMetrics next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return new IlluminaTileMetrics(this.bbIterator.next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class IlluminaLaneTileCode {
        private final int laneNumber;
        private final int tileNumber;
        private final int metricCode;

        public IlluminaLaneTileCode(int n, int n2, int n3) {
            this.laneNumber = n;
            this.tileNumber = n2;
            this.metricCode = n3;
        }

        public int getLaneNumber() {
            return this.laneNumber;
        }

        public int getTileNumber() {
            return this.tileNumber;
        }

        public int getMetricCode() {
            return this.metricCode;
        }

        public boolean equals(Object object) {
            if (object instanceof IlluminaLaneTileCode) {
                IlluminaLaneTileCode illuminaLaneTileCode = (IlluminaLaneTileCode)object;
                return this.laneNumber == illuminaLaneTileCode.laneNumber && this.tileNumber == illuminaLaneTileCode.tileNumber && this.metricCode == illuminaLaneTileCode.metricCode;
            }
            return false;
        }

        public int hashCode() {
            int n = this.laneNumber;
            n = 31 * n + this.tileNumber;
            n = 31 * n + this.metricCode;
            return n;
        }
    }

    public static class IlluminaTileMetrics {
        private final IlluminaLaneTileCode laneTileCode;
        private final float metricValue;

        public IlluminaTileMetrics(ByteBuffer byteBuffer) {
            this(UnsignedTypeUtil.uShortToInt(byteBuffer.getShort()), UnsignedTypeUtil.uShortToInt(byteBuffer.getShort()), UnsignedTypeUtil.uShortToInt(byteBuffer.getShort()), byteBuffer.getFloat());
        }

        public IlluminaTileMetrics(int n, int n2, int n3, float f) {
            this.laneTileCode = new IlluminaLaneTileCode(n, n2, n3);
            this.metricValue = f;
        }

        public int getLaneNumber() {
            return this.laneTileCode.getLaneNumber();
        }

        public int getTileNumber() {
            return this.laneTileCode.getTileNumber();
        }

        public int getMetricCode() {
            return this.laneTileCode.getMetricCode();
        }

        public float getMetricValue() {
            return this.metricValue;
        }

        public IlluminaLaneTileCode getLaneTileCode() {
            return this.laneTileCode;
        }

        public boolean equals(Object object) {
            if (object instanceof IlluminaTileMetrics) {
                IlluminaTileMetrics illuminaTileMetrics = (IlluminaTileMetrics)object;
                return this.laneTileCode == illuminaTileMetrics.laneTileCode && this.metricValue == illuminaTileMetrics.metricValue;
            }
            return false;
        }

        public int hashCode() {
            return String.format("%s:%s:%s:%s", this.laneTileCode.getLaneNumber(), this.laneTileCode.getTileNumber(), this.laneTileCode.getMetricCode(), Float.valueOf(this.metricValue)).hashCode();
        }
    }
}

