/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.quality;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.IlluminaDataProvider;
import picard.illumina.parser.IlluminaDataProviderFactory;
import picard.illumina.parser.IlluminaDataType;
import picard.illumina.parser.ReadData;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;

@CommandLineProgramProperties(usage="Classify PF-Failing reads in a HiSeqX Illumina Basecalling directory into various categories. The classification is based on a heuristic that was derived by looking at a few titration experiments.", usageShort="Classify PF-Failing reads in a HiSeqX Illumina Basecalling directory into various categories.", programGroup=Metrics.class)
public class CollectHiSeqXPfFailMetrics
extends CommandLineProgram {
    @Option(doc="The Illumina basecalls directory. ", shortName="B")
    public File BASECALLS_DIR;
    @Option(shortName="O", doc="Basename for metrics file. Resulting file will be <OUTPUT>.pffail_summary_metrics", optional=false)
    public File OUTPUT;
    @Option(shortName="P", doc="The fraction of (non-PF) reads for which to output explicit classification. Output file will be <OUTPUT>.pffail_detailed_metrics (if PROB_EXPLICIT_READS != 0)", optional=true)
    public double PROB_EXPLICIT_READS = 0.0;
    @Option(doc="Lane number.", shortName="L")
    public Integer LANE;
    @Option(shortName="NP", doc="Run this many PerTileBarcodeExtractors in parallel.  If NUM_PROCESSORS = 0, number of cores is automatically set to the number of cores available on the machine. If NUM_PROCESSORS < 0 then the number of cores used will be the number available on the machine less NUM_PROCESSORS.", optional=true)
    public int NUM_PROCESSORS = 1;
    @Option(doc="Number of cycles to look at. At time of writing PF status gets determined at cycle 24 so numbers greater than this will yield strange results. In addition, PF status is currently determined at cycle 24, so running this with any other value is neither tested nor recommended.", optional=true)
    public int N_CYCLES = 24;
    private static final Log LOG = Log.getInstance(CollectHiSeqXPfFailMetrics.class);
    private final Map<Integer, PFFailSummaryMetric> tileToSummaryMetrics = new LinkedHashMap<Integer, PFFailSummaryMetric>();
    private final Map<Integer, List<PFFailDetailedMetric>> tileToDetailedMetrics = new LinkedHashMap<Integer, List<PFFailDetailedMetric>>();
    private final ReadStructure READ_STRUCTURE = new ReadStructure(this.N_CYCLES + "T");
    public static final String detailedMetricsExtension = ".pffail_detailed_metrics";
    public static final String summaryMetricsExtension = ".pffail_summary_metrics";

    @Override
    protected String[] customCommandLineValidation() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.N_CYCLES < 0) {
            arrayList.add("Number of Cycles to look at must be greater than 0");
        }
        if (this.PROB_EXPLICIT_READS > 1.0 || this.PROB_EXPLICIT_READS < 0.0) {
            arrayList.add("PROB_EXPLICIT_READS must be a probability, i.e., 0 <= PROB_EXPLICIT_READS <= 1");
        }
        if (!arrayList.isEmpty()) {
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return super.customCommandLineValidation();
    }

    public static void main(String[] stringArray) {
        new CollectHiSeqXPfFailMetrics().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IlluminaDataProviderFactory illuminaDataProviderFactory = new IlluminaDataProviderFactory(this.BASECALLS_DIR, this.LANE, this.READ_STRUCTURE, new BclQualityEvaluationStrategy(2), IlluminaDataType.BaseCalls, IlluminaDataType.PF, IlluminaDataType.QualityScores, IlluminaDataType.Position);
        File file = new File(this.OUTPUT + summaryMetricsExtension);
        File file2 = new File(this.OUTPUT + detailedMetricsExtension);
        IOUtil.assertFileIsWritable((File)file);
        if (this.PROB_EXPLICIT_READS != 0.0) {
            IOUtil.assertFileIsWritable((File)file2);
        }
        int n = this.NUM_PROCESSORS == 0 ? Runtime.getRuntime().availableProcessors() : (this.NUM_PROCESSORS < 0 ? Runtime.getRuntime().availableProcessors() + this.NUM_PROCESSORS : this.NUM_PROCESSORS);
        LOG.info(new Object[]{"Processing with " + n + " PerTilePFMetricsExtractor(s)."});
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        ArrayList<PerTilePFMetricsExtractor> arrayList = new ArrayList<PerTilePFMetricsExtractor>(illuminaDataProviderFactory.getAvailableTiles().size());
        for (int n2 : illuminaDataProviderFactory.getAvailableTiles()) {
            this.tileToSummaryMetrics.put(n2, new PFFailSummaryMetric(Integer.toString(n2)));
            this.tileToDetailedMetrics.put(n2, new ArrayList());
            PerTilePFMetricsExtractor iterator3 = new PerTilePFMetricsExtractor(n2, this.tileToSummaryMetrics.get(n2), (Collection<PFFailDetailedMetric>)this.tileToDetailedMetrics.get(n2), illuminaDataProviderFactory, this.PROB_EXPLICIT_READS);
            arrayList.add(iterator3);
        }
        try {
            for (PerTilePFMetricsExtractor perTilePFMetricsExtractor : arrayList) {
                executorService.submit(perTilePFMetricsExtractor);
            }
            executorService.shutdown();
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (Throwable throwable) {
            LOG.error(throwable, new Object[]{"Parent thread encountered problem submitting extractors to thread pool or awaiting shutdown of threadpool.  Attempting to kill threadpool."});
            executorService.shutdownNow();
            return 2;
        }
        LOG.info(new Object[]{"Processed " + arrayList.size() + " tiles."});
        for (PerTilePFMetricsExtractor perTilePFMetricsExtractor : arrayList) {
            if (perTilePFMetricsExtractor.getException() == null) continue;
            LOG.error(new Object[]{"Abandoning metrics calculation because one or more PerTilePFMetricsExtractors failed."});
            return 4;
        }
        Iterator<Integer> iterator2 = this.getMetricsFile();
        for (Collection collection : this.tileToDetailedMetrics.values()) {
            for (PFFailDetailedMetric pFFailDetailedMetric : collection) {
                iterator2.addMetric(pFFailDetailedMetric);
            }
        }
        if (this.PROB_EXPLICIT_READS > 0.0) {
            iterator2.write(file2);
        }
        PFFailSummaryMetric pFFailSummaryMetric = new PFFailSummaryMetric("All");
        for (PFFailSummaryMetric pFFailSummaryMetric2 : this.tileToSummaryMetrics.values()) {
            pFFailSummaryMetric.merge(pFFailSummaryMetric2);
        }
        pFFailSummaryMetric.calculateDerivedFields();
        MetricsFile metricsFile = this.getMetricsFile();
        metricsFile.addMetric((MetricBase)pFFailSummaryMetric);
        for (PFFailSummaryMetric pFFailSummaryMetric3 : this.tileToSummaryMetrics.values()) {
            pFFailSummaryMetric3.calculateDerivedFields();
            metricsFile.addMetric((MetricBase)pFFailSummaryMetric3);
        }
        metricsFile.write(file);
        return 0;
    }

    private static int countEquals(byte[] byArray, byte by) {
        int n = 0;
        for (byte by2 : byArray) {
            if (by2 != by) continue;
            ++n;
        }
        return n;
    }

    private static int countGreaterThan(byte[] byArray, byte by) {
        int n = 0;
        for (byte by2 : byArray) {
            if (by2 <= by) continue;
            ++n;
        }
        return n;
    }

    public static class PFFailSummaryMetric
    extends MetricBase {
        public String TILE = null;
        public int READS = 0;
        public int PF_FAIL_READS = 0;
        public double PCT_PF_FAIL_READS = 0.0;
        public int PF_FAIL_EMPTY = 0;
        public double PCT_PF_FAIL_EMPTY = 0.0;
        public int PF_FAIL_POLYCLONAL = 0;
        public double PCT_PF_FAIL_POLYCLONAL = 0.0;
        public int PF_FAIL_MISALIGNED = 0;
        public double PCT_PF_FAIL_MISALIGNED = 0.0;
        public int PF_FAIL_UNKNOWN = 0;
        public double PCT_PF_FAIL_UNKNOWN = 0.0;

        public PFFailSummaryMetric(String string) {
            this.TILE = string;
        }

        public PFFailSummaryMetric() {
        }

        public void merge(PFFailSummaryMetric pFFailSummaryMetric) {
            this.READS += pFFailSummaryMetric.READS;
            this.PF_FAIL_READS += pFFailSummaryMetric.PF_FAIL_READS;
            this.PF_FAIL_EMPTY += pFFailSummaryMetric.PF_FAIL_EMPTY;
            this.PF_FAIL_MISALIGNED += pFFailSummaryMetric.PF_FAIL_MISALIGNED;
            this.PF_FAIL_POLYCLONAL += pFFailSummaryMetric.PF_FAIL_POLYCLONAL;
            this.PF_FAIL_UNKNOWN += pFFailSummaryMetric.PF_FAIL_UNKNOWN;
        }

        public void calculateDerivedFields() {
            if (this.READS != 0) {
                this.PCT_PF_FAIL_READS = (double)this.PF_FAIL_READS / (double)this.READS;
                this.PCT_PF_FAIL_EMPTY = (double)this.PF_FAIL_EMPTY / (double)this.READS;
                this.PCT_PF_FAIL_MISALIGNED = (double)this.PF_FAIL_MISALIGNED / (double)this.READS;
                this.PCT_PF_FAIL_POLYCLONAL = (double)this.PF_FAIL_POLYCLONAL / (double)this.READS;
                this.PCT_PF_FAIL_UNKNOWN = (double)this.PF_FAIL_UNKNOWN / (double)this.READS;
            }
        }
    }

    public static class PFFailDetailedMetric
    extends MetricBase {
        public Integer TILE;
        public int X;
        public int Y;
        public int NUM_N;
        public int NUM_Q_GT_TWO;
        public ReadClassifier.PfFailReason CLASSIFICATION;

        public PFFailDetailedMetric(Integer n, int n2, int n3, int n4, int n5, ReadClassifier.PfFailReason pfFailReason) {
            this.TILE = n;
            this.X = n2;
            this.Y = n3;
            this.NUM_N = n4;
            this.NUM_Q_GT_TWO = n5;
            this.CLASSIFICATION = pfFailReason;
        }

        public PFFailDetailedMetric() {
        }
    }

    protected static class ReadClassifier {
        private final int numNs;
        private final int numQGtTwo;
        private PfFailReason failClass = null;

        public ReadClassifier(ReadData readData) {
            int n = readData.getBases().length;
            this.numNs = CollectHiSeqXPfFailMetrics.countEquals(readData.getBases(), (byte)46);
            this.numQGtTwo = CollectHiSeqXPfFailMetrics.countGreaterThan(readData.getQualities(), (byte)2);
            this.failClass = PfFailReason.UNKNOWN;
            if (this.numNs >= n - 1) {
                this.failClass = PfFailReason.MISALIGNED;
            } else if (this.numNs <= 1) {
                if (this.numQGtTwo <= n / 3) {
                    this.failClass = PfFailReason.EMPTY;
                } else if (this.numQGtTwo >= n / 2) {
                    this.failClass = PfFailReason.POLYCLONAL;
                }
            }
        }

        public static enum PfFailReason {
            EMPTY,
            POLYCLONAL,
            MISALIGNED,
            UNKNOWN;

        }
    }

    private static class PerTilePFMetricsExtractor
    implements Runnable {
        private final int tile;
        private final PFFailSummaryMetric summaryMetric;
        final Collection<PFFailDetailedMetric> detailedMetrics;
        private Exception exception = null;
        private final IlluminaDataProvider provider;
        private final double pWriteDetailed;
        private final Random random = new Random();

        public PerTilePFMetricsExtractor(int n, PFFailSummaryMetric pFFailSummaryMetric, Collection<PFFailDetailedMetric> collection, IlluminaDataProviderFactory illuminaDataProviderFactory, double d) {
            this.tile = n;
            this.summaryMetric = pFFailSummaryMetric;
            this.detailedMetrics = collection;
            this.pWriteDetailed = d;
            this.provider = illuminaDataProviderFactory.makeDataProvider(Arrays.asList(n));
        }

        public Exception getException() {
            return this.exception;
        }

        @Override
        public void run() {
            try {
                LOG.info(new Object[]{"Extracting PF metrics for tile " + this.tile});
                block11: while (this.provider.hasNext()) {
                    ClusterData clusterData = this.provider.next();
                    ++this.summaryMetric.READS;
                    if (clusterData.isPf().booleanValue()) continue;
                    ++this.summaryMetric.PF_FAIL_READS;
                    ReadClassifier readClassifier = new ReadClassifier(clusterData.getRead(0));
                    if (this.random.nextDouble() < this.pWriteDetailed) {
                        this.detailedMetrics.add(new PFFailDetailedMetric(this.tile, clusterData.getX(), clusterData.getY(), readClassifier.numNs, readClassifier.numQGtTwo, readClassifier.failClass));
                    }
                    switch (readClassifier.failClass) {
                        case EMPTY: {
                            ++this.summaryMetric.PF_FAIL_EMPTY;
                            continue block11;
                        }
                        case MISALIGNED: {
                            ++this.summaryMetric.PF_FAIL_MISALIGNED;
                            continue block11;
                        }
                        case POLYCLONAL: {
                            ++this.summaryMetric.PF_FAIL_POLYCLONAL;
                            continue block11;
                        }
                        case UNKNOWN: {
                            ++this.summaryMetric.PF_FAIL_UNKNOWN;
                            continue block11;
                        }
                    }
                    LOG.error(new Object[]{"Got unexpected fail Reason"});
                }
            }
            catch (Exception exception) {
                LOG.error((Throwable)exception, new Object[]{"Error processing tile ", this.tile});
                this.exception = exception;
            }
            finally {
                this.provider.close();
            }
        }
    }
}

